/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.audio;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Owned;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.control.BufferControl;
import javax.media.control.FrameProcessingControl;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.sf.fmj.media.AbstractGainControl;
import net.sf.fmj.media.AudioFormatCompleter;
import net.sf.fmj.media.codec.audio.alaw.Decoder;
import net.sf.fmj.media.renderer.audio.JavaSoundGainControl;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.ControlCollection;
import net.sf.fmj.utility.LoggerSingleton;

public class JavaSoundRenderer
implements Renderer {
    private static final Logger logger = LoggerSingleton.logger;
    private String name = "FMJ Audio Renderer";
    private int buflen;
    private long buflenMS = -1L;
    private Boolean bufferSizeChanged = new Boolean(false);
    private SourceDataLine sourceLine;
    private AudioFormat inputFormat;
    private javax.sound.sampled.AudioFormat audioFormat;
    private javax.sound.sampled.AudioFormat sampledFormat;
    private final ControlCollection controls = new ControlCollection();
    private Codec codec;
    private final Buffer codecBuffer = new Buffer();
    private long lastSequenceNumber = -1L;
    private int framesDropped = 0;
    private PeakVolumeMeter levelControl;
    private Format[] supportedInputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("ULAW", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("alaw", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final boolean NON_BLOCKING = false;

    public JavaSoundRenderer() {
        this.levelControl = new PeakVolumeMeter();
        this.levelControl.setMute(true);
    }

    public void close() {
        logger.info("JavaSoundRenderer closing...");
        this.controls.clear();
        if (this.codec != null) {
            this.codec.close();
            this.codec = null;
        }
        this.sourceLine.close();
        this.sourceLine = null;
    }

    public Object getControl(String string) {
        return this.controls.getControl(string);
    }

    public Object[] getControls() {
        return this.controls.getControls();
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void logControls(Control[] controlArray) {
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            logger.fine("control: " + control);
            Control.Type type = control.getType();
            if (!(type instanceof CompoundControl.Type)) continue;
            this.logControls(((CompoundControl)control).getMemberControls());
        }
    }

    public void open() throws ResourceUnavailableException {
        this.audioFormat = JavaSoundUtils.convertFormat(this.inputFormat);
        logger.info("JavaSoundRenderer opening with javax.sound format: " + this.audioFormat);
        try {
            Object object;
            Format[] formatArray;
            if (!this.inputFormat.getEncoding().equals("LINEAR")) {
                logger.info("JavaSoundRenderer: Audio format is not linear, creating conversion");
                if (this.inputFormat.getEncoding().equals("ULAW")) {
                    this.codec = new net.sf.fmj.media.codec.audio.ulaw.Decoder();
                } else if (this.inputFormat.getEncoding().equals("alaw")) {
                    this.codec = new Decoder();
                } else {
                    throw new ResourceUnavailableException("Unsupported input format encoding: " + this.inputFormat.getEncoding());
                }
                if (this.codec.setInputFormat(this.inputFormat) == null) {
                    throw new ResourceUnavailableException("Codec rejected input format: " + this.inputFormat);
                }
                formatArray = this.codec.getSupportedOutputFormats(this.inputFormat);
                if (formatArray.length < 1) {
                    throw new ResourceUnavailableException("Unable to get an output format for input format: " + this.inputFormat);
                }
                object = AudioFormatCompleter.complete((AudioFormat)formatArray[0]);
                if (this.codec.setOutputFormat((Format)object) == null) {
                    throw new ResourceUnavailableException("Codec rejected output format: " + object);
                }
                this.audioFormat = JavaSoundUtils.convertFormat((AudioFormat)object);
                this.codec.open();
                logger.info("JavaSoundRenderer: Audio format is not linear, created conversion from " + this.inputFormat + " to " + object);
            }
            formatArray = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            this.sourceLine = (SourceDataLine)AudioSystem.getLine((Line.Info)formatArray);
            logger.info("JavaSoundRenderer: sourceLine=" + this.sourceLine);
            this.sourceLine.open(this.audioFormat);
            logger.info("JavaSoundRenderer: buflen=" + this.sourceLine.getBufferSize());
            object = null;
            try {
                object = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "" + exception, exception);
            }
            logger.fine("JavaSoundRenderer: gainFloatControl=" + object);
            BooleanControl booleanControl = null;
            try {
                booleanControl = (BooleanControl)this.sourceLine.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "" + exception, exception);
            }
            logger.fine("JavaSoundRenderer: muteBooleanControl=" + booleanControl);
            JavaSoundGainControl javaSoundGainControl = new JavaSoundGainControl((FloatControl)object, booleanControl);
            this.controls.addControl(javaSoundGainControl);
            this.controls.addControl(new JavaSoundRendererBufferControl());
            this.controls.addControl(new FPC());
            this.controls.addControl(this.levelControl);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new ResourceUnavailableException(lineUnavailableException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        int n;
        if (this.codec != null) {
            n = this.codec.process(buffer, this.codecBuffer);
            if (n == 1) {
                return 1;
            }
            if (n == 4) {
                return 0;
            }
            this.codecBuffer.setRtpTimeStamp(buffer.getRtpTimeStamp());
            this.codecBuffer.setHeaderExtension(buffer.getHeaderExtension());
            this.codecBuffer.setTimeStamp(buffer.getTimeStamp());
            this.codecBuffer.setFlags(buffer.getFlags());
            this.codecBuffer.setSequenceNumber(buffer.getSequenceNumber());
            buffer = this.codecBuffer;
        }
        this.levelControl.processData(buffer);
        n = buffer.getLength();
        int n2 = buffer.getOffset();
        Format format = buffer.getFormat();
        Class<?> clazz = format.getDataType();
        if (clazz != Format.byteArray) {
            return 1;
        }
        byte[] byArray = (byte[])buffer.getData();
        try {
            Boolean bl = this.bufferSizeChanged;
            synchronized (bl) {
                if (this.bufferSizeChanged.booleanValue()) {
                    this.bufferSizeChanged = Boolean.FALSE;
                    this.sourceLine.stop();
                    this.sourceLine.flush();
                    this.sourceLine.close();
                    this.buflen = (int)((float)this.audioFormat.getFrameSize() * this.audioFormat.getSampleRate() * (float)this.buflenMS / 1000.0f);
                    this.sourceLine.open(this.audioFormat, this.buflen);
                    logger.info("JavaSoundRenderer: buflen=" + this.sourceLine.getBufferSize());
                    this.sourceLine.start();
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
        }
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        if (n == 0) {
            logger.finer("Buffer has zero length, flags = " + buffer.getFlags());
        }
        if (-1L == this.lastSequenceNumber) {
            this.lastSequenceNumber = buffer.getSequenceNumber();
        } else {
            if ((short)(this.lastSequenceNumber + 1L) != (short)buffer.getSequenceNumber()) {
                int n5 = ((short)buffer.getSequenceNumber() - (short)this.lastSequenceNumber & 0xFFFF) - 1;
                this.framesDropped += n5;
            }
            this.lastSequenceNumber = buffer.getSequenceNumber();
        }
        while (n > 0) {
            int n6 = this.sourceLine.write(byArray, n2, n);
            Thread.yield();
            if (n6 >= n) break;
            if (n6 == 0) {
                logger.warning("sourceLine.write returned 0, offset=" + n2 + "; length=" + n + "; available=" + this.sourceLine.available() + "; frame size in bytes" + this.sourceLine.getFormat().getFrameSize() + "; sourceLine.isActive() = " + this.sourceLine.isActive() + "; " + this.sourceLine.isOpen() + "; sourceLine.isRunning()=" + this.sourceLine.isRunning());
                return 1;
            }
            n2 += n6;
            n -= n6;
        }
        if (bl) {
            buffer.setLength(n3);
            buffer.setOffset(n4);
            return 2;
        }
        if (buffer.isEOM()) {
            this.sourceLine.drain();
        }
        return 0;
    }

    public void reset() {
        logger.info("JavaSoundRenderer resetting...");
    }

    public Format setInputFormat(Format format) {
        logger.info("JavaSoundRenderer setting input format to: " + format);
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        this.inputFormat = (AudioFormat)format;
        return this.inputFormat;
    }

    public void start() {
        logger.info("JavaSoundRenderer starting...");
        this.sourceLine.start();
    }

    public void stop() {
        logger.info("JavaSoundRenderer stopping...");
        this.sourceLine.stop();
    }

    private class PeakVolumeMeter
    extends AbstractGainControl {
        float peakLevel = 0.0f;

        private PeakVolumeMeter() {
        }

        public float getLevel() {
            return this.peakLevel;
        }

        public void processData(Buffer buffer) {
            if (this.getMute() || buffer.isDiscard() || buffer.getLength() <= 0) {
                return;
            }
            AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
            byte[] byArray = (byte[])buffer.getData();
            if (audioFormat.getEncoding().equalsIgnoreCase("LINEAR") && audioFormat.getSampleSizeInBits() == 16) {
                int n = 0;
                int n2 = 1;
                if (audioFormat.getEndian() == 0) {
                    n = 1;
                    n2 = 0;
                }
                if (audioFormat.getSigned() == 1) {
                    int n3 = 0;
                    int n4 = byArray.length / 2;
                    for (int i = 0; i < n4; ++i) {
                        int n5 = (byArray[i * 2 + n] << 8) + (byArray[i * 2 + n2] & 0xFF);
                        if (n5 < 0) {
                            n5 = -n5;
                        }
                        if (n5 <= n3) continue;
                        n3 = n5;
                    }
                    this.peakLevel = (float)n3 / 32768.0f;
                }
            }
        }

        public float setLevel(float f) {
            float f2 = this.getLevel();
            return f2;
        }
    }

    private class JavaSoundRendererBufferControl
    implements BufferControl,
    Owned {
        private JavaSoundRendererBufferControl() {
        }

        public long getBufferLength() {
            return JavaSoundRenderer.this.buflenMS;
        }

        public Component getControlComponent() {
            return null;
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public long getMinimumThreshold() {
            return -1L;
        }

        public Object getOwner() {
            return JavaSoundRenderer.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long setBufferLength(long l) {
            JavaSoundRenderer.this.buflenMS = l;
            Boolean bl = JavaSoundRenderer.this.bufferSizeChanged;
            synchronized (bl) {
                JavaSoundRenderer.this.bufferSizeChanged = Boolean.TRUE;
            }
            return JavaSoundRenderer.this.buflenMS;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public long setMinimumThreshold(long l) {
            return -1L;
        }
    }

    private class FPC
    implements FrameProcessingControl,
    Owned {
        private FPC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public int getFramesDropped() {
            return JavaSoundRenderer.this.framesDropped;
        }

        public Object getOwner() {
            return JavaSoundRenderer.this;
        }

        public void setFramesBehind(float f) {
        }

        public boolean setMinimalProcessing(boolean bl) {
            return false;
        }
    }
}

