/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.DataSink;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.device.AudioMixerMediaDevice;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.RecorderEvent;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.service.neomedia.recording.Synchronizer;

public class RecorderImpl
implements Recorder {
    public static final String[] SUPPORTED_FORMATS = new String[]{"wav", "mp3"};
    private final AudioMixerMediaDevice device;
    private RecorderEventHandler eventHandler = null;
    private MediaDeviceSession deviceSession;
    private final List<Recorder.Listener> listeners = new ArrayList<Recorder.Listener>();
    private DataSink sink;
    private boolean mute = false;
    private String filename = null;

    public RecorderImpl(AudioMixerMediaDevice device) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        this.device = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Recorder.Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<Recorder.Listener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    private ContentDescriptor getContentDescriptor(String format) throws IllegalArgumentException {
        String type;
        if ("wav".equalsIgnoreCase(format)) {
            type = "audio.x_wav";
        } else if ("mp3".equalsIgnoreCase(format)) {
            type = "audio.mpeg";
        } else if ("gsm".equalsIgnoreCase(format)) {
            type = "audio.x_gsm";
        } else if ("au".equalsIgnoreCase(format)) {
            type = "audio.basic";
        } else if ("aiff".equalsIgnoreCase(format)) {
            type = "audio.x_aiff";
        } else {
            throw new IllegalArgumentException(format + " is not a supported recording format.");
        }
        return new ContentDescriptor(type);
    }

    @Override
    public List<String> getSupportedFormats() {
        return Arrays.asList(SUPPORTED_FORMATS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Recorder.Listener listener) {
        if (listener != null) {
            List<Recorder.Listener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String format, String filename) throws IOException, MediaException {
        if (this.sink == null) {
            block17: {
                if (format == null) {
                    throw new NullPointerException("format");
                }
                if (filename == null) {
                    throw new NullPointerException("filename");
                }
                this.filename = filename;
                int extensionBeginIndex = filename.lastIndexOf(46);
                if (extensionBeginIndex < 0) {
                    filename = filename + '.' + format;
                } else if (extensionBeginIndex == filename.length() - 1) {
                    filename = filename + format;
                }
                MediaDeviceSession deviceSession = this.device.createSession();
                try {
                    deviceSession.setContentDescriptor(this.getContentDescriptor(format));
                    deviceSession.setMute(this.mute);
                    deviceSession.start(MediaDirection.SENDONLY);
                    this.deviceSession = deviceSession;
                }
                finally {
                    if (this.deviceSession == null) {
                        throw new MediaException("Failed to create MediaDeviceSession from AudioMixerMediaDevice for the purposes of recording");
                    }
                }
                NoDataSinkException exception = null;
                try {
                    DataSource outputDataSource = deviceSession.getOutputDataSource();
                    DataSink sink = Manager.createDataSink(outputDataSource, new MediaLocator("file:" + filename));
                    sink.open();
                    sink.start();
                    this.sink = sink;
                }
                catch (NoDataSinkException ndsex) {
                    exception = ndsex;
                }
                finally {
                    if (this.sink != null && exception == null) break block17;
                    this.stop();
                    throw new MediaException("Failed to start recording into file " + filename, exception);
                }
            }
            if (this.eventHandler != null) {
                RecorderEvent event = new RecorderEvent();
                event.setType(RecorderEvent.Type.RECORDING_STARTED);
                event.setInstant(System.currentTimeMillis());
                event.setMediaType(MediaType.AUDIO);
                event.setFilename(filename);
                this.eventHandler.handleEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        if (this.deviceSession != null) {
            this.deviceSession.close();
            this.deviceSession = null;
        }
        if (this.sink == null) return;
        this.sink.close();
        this.sink = null;
        Recorder.Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Recorder.Listener[] listeners = this.listeners.toArray(new Recorder.Listener[this.listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Recorder.Listener listener : listeners) {
                listener.recorderStopped(this);
            }
            if (this.eventHandler == null) return;
            RecorderEvent event = new RecorderEvent();
            event.setType(RecorderEvent.Type.RECORDING_ENDED);
            event.setInstant(System.currentTimeMillis());
            event.setMediaType(MediaType.AUDIO);
            event.setFilename(this.filename);
            this.eventHandler.handleEvent(event);
            return;
        }
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
        if (this.deviceSession != null) {
            this.deviceSession.setMute(mute);
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setEventHandler(RecorderEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public Synchronizer getSynchronizer() {
        return null;
    }

    @Override
    public void setSynchronizer(Synchronizer synchronizer) {
    }

    @Override
    public MediaStream getMediaStream() {
        return null;
    }
}

