/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rewriting;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.util.RTPPacket;
import org.jitsi.util.Logger;

public class SsrcRewriter {
    private static final Logger logger = Logger.getLogger(SsrcRewriter.class);
    private static final long REWRITE_SSRC_NO_REWRITE_SSRC = -1L;
    private Map<Integer, PeerSsrcEngine> peerSsrcEngines = new HashMap<Integer, PeerSsrcEngine>();
    private int currentRewriteSeqnumBase;
    private long currentRewriteSsrc = -1L;

    public RTPPacket transform(RTPPacket pkt) {
        if (this.currentRewriteSsrc == -1L) {
            return pkt;
        }
        if (!this.peerSsrcEngines.containsKey(pkt.ssrc)) {
            this.peerSsrcEngines.put(pkt.ssrc, new PeerSsrcEngine(pkt.ssrc));
        }
        for (Map.Entry<Integer, PeerSsrcEngine> entry : this.peerSsrcEngines.entrySet()) {
            if (entry.getKey() == pkt.ssrc) continue;
            entry.getValue().assertPaused();
        }
        PeerSsrcEngine peerSsrcEngine = this.peerSsrcEngines.get(pkt.ssrc);
        return peerSsrcEngine.transform(pkt);
    }

    public RTPPacket reverseTransform(RTPPacket rtpPacket) {
        return rtpPacket;
    }

    public RTCPCompoundPacket transform(RTCPCompoundPacket rtcpCompoundPacket) {
        return rtcpCompoundPacket;
    }

    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket rtcpCompoundPacket) {
        return rtcpCompoundPacket;
    }

    public long getCurrentRewriteSsrc() {
        return this.currentRewriteSsrc;
    }

    public void setCurrentRewriteSsrc(long currentRewriteSsrc) {
        if (this.currentRewriteSsrc != currentRewriteSsrc) {
            this.currentRewriteSsrc = currentRewriteSsrc;
            this.currentRewriteSeqnumBase = new Random().nextInt(65536);
        }
    }

    class PeerSsrcEngine {
        private int ssrc;
        private Interval currentInterval;
        private final NavigableMap<Integer, Interval> intervals = new TreeMap<Integer, Interval>();

        public PeerSsrcEngine(int ssrc) {
            this.ssrc = ssrc;
        }

        public RTCPCompoundPacket transform(RTCPCompoundPacket rtcpCompoundPacket) {
            return rtcpCompoundPacket;
        }

        public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket rtcpCompoundPacket) {
            return rtcpCompoundPacket;
        }

        public RTPPacket transform(RTPPacket pkt) {
            if (this.currentInterval != null && this.currentInterval.contains(pkt.seqnum)) {
                logger.debug((Object)("Retransmitting packet with SEQNUM " + pkt.seqnum + " of SSRC " + ((long)pkt.ssrc & 0xFFFFFFFFL) + " from the current interval."));
                return this.currentInterval.transform(pkt);
            }
            Map.Entry<Integer, Interval> candidateInterval = this.intervals.higherEntry(pkt.seqnum);
            if (candidateInterval != null && candidateInterval.getValue().contains(pkt.seqnum)) {
                logger.debug((Object)("Retransmitting packet with SEQNUM " + pkt.seqnum + " of SSRC " + ((long)pkt.ssrc & 0xFFFFFFFFL) + " from a previous interval."));
                return candidateInterval.getValue().transform(pkt);
            }
            if (this.currentInterval == null) {
                logger.debug((Object)("SSRC " + ((long)pkt.ssrc & 0xFFFFFFFFL) + " has resumed."));
                this.currentInterval = new Interval(pkt.seqnum, pkt.seqnum, SsrcRewriter.this.currentRewriteSeqnumBase);
            } else {
                this.currentInterval.max = pkt.seqnum;
            }
            return this.currentInterval.transform(pkt);
        }

        public RTPPacket reverseTransform(RTPPacket pkt) {
            return pkt;
        }

        public void assertPaused() {
            if (this.currentInterval != null) {
                logger.debug((Object)("Pausing SSRC " + ((long)this.ssrc & 0xFFFFFFFFL) + "."));
                this.intervals.put(this.currentInterval.max, this.currentInterval);
                SsrcRewriter.this.currentRewriteSeqnumBase = SsrcRewriter.this.currentRewriteSeqnumBase + (this.currentInterval.length() + 1);
            }
            this.currentInterval = null;
        }

        class Interval {
            private int min;
            private int max;
            private int base;

            public Interval(int min, int max, int base) {
                this.min = min;
                this.max = max;
                this.base = base;
            }

            public boolean contains(int x) {
                return this.min >= x && x <= this.max;
            }

            public String toString() {
                return "[" + this.min + ", " + this.max + "]";
            }

            public RTCPCompoundPacket transform(RTCPCompoundPacket rtcpCompoundPacket) {
                return rtcpCompoundPacket;
            }

            public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket rtcpCompoundPacket) {
                return rtcpCompoundPacket;
            }

            public RTPPacket transform(RTPPacket pkt) {
                pkt.ssrc = (int)SsrcRewriter.this.currentRewriteSsrc;
                int diff = pkt.seqnum - this.min;
                pkt.seqnum = this.base + diff;
                return pkt;
            }

            public RTPPacket reverseTransform(RTPPacket pkt) {
                return pkt;
            }

            public int length() {
                return this.max - this.min;
            }
        }
    }
}

