/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Format;
import net.sf.fmj.media.BasicConnector;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.OutputConnector;

public class BasicOutputConnector
extends BasicConnector
implements OutputConnector {
    protected InputConnector inputConnector = null;
    private boolean reset = false;

    public Format canConnectTo(InputConnector inputConnector, Format useThisFormat) {
        if (this.getProtocol() != inputConnector.getProtocol()) {
            throw new RuntimeException("protocols do not match:: ");
        }
        return null;
    }

    public Format connectTo(InputConnector inputConnector, Format useThisFormat) {
        Format format = this.canConnectTo(inputConnector, useThisFormat);
        this.inputConnector = inputConnector;
        inputConnector.setOutputConnector(this);
        int bufferSize = Math.max(this.getSize(), inputConnector.getSize());
        this.circularBuffer = new CircularBuffer(bufferSize);
        inputConnector.setCircularBuffer(this.circularBuffer);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getEmptyBuffer() {
        switch (this.protocol) {
            case 0: {
                if (!this.isEmptyBufferAvailable() && this.reset) {
                    return null;
                }
                this.reset = false;
                return this.circularBuffer.getEmptyBuffer();
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isEmptyBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {}
                    }
                    if (this.reset) {
                        return null;
                    }
                    Buffer buffer = this.circularBuffer.getEmptyBuffer();
                    this.circularBuffer.notifyAll();
                    return buffer;
                }
            }
        }
        throw new RuntimeException();
    }

    public InputConnector getInputConnector() {
        return this.inputConnector;
    }

    public boolean isEmptyBufferAvailable() {
        return this.circularBuffer.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            if (this.inputConnector != null) {
                this.inputConnector.reset();
            }
            this.circularBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReport() {
        switch (this.protocol) {
            case 0: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.writeReport();
                }
                this.getInputConnector().getModule().connectorPushed(this.getInputConnector());
                return;
            }
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        return;
                    }
                    this.circularBuffer.writeReport();
                    this.circularBuffer.notifyAll();
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

