/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.event.LocalPayloadChangeEvent;
import net.sf.fmj.media.rtp.RTPRawSender;
import net.sf.fmj.media.rtp.RTPTransmitter;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class RTPSinkStream
implements BufferTransferHandler {
    private RTPMediaThread thread = null;
    Buffer current = new Buffer();
    boolean started = false;
    Object startReq = new Integer(0);
    RTPTransmitter transmitter = null;
    RTPRawSender sender = null;
    SendSSRCInfo info = null;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    long startTime = 0L;
    long startPT = -1L;
    int rate;
    boolean mpegBFrame = false;
    boolean mpegPFrame = false;
    boolean bufSizeSet = false;
    long audioPT = 0L;
    static int THRESHOLD = 80;
    static int LEEWAY = 5;

    protected void close() {
        this.stop();
    }

    protected void setSSRCInfo(SendSSRCInfo sendSSRCInfo) {
        this.info = sendSSRCInfo;
    }

    protected void setTransmitter(RTPTransmitter rTPTransmitter) {
        this.transmitter = rTPTransmitter;
        if (this.transmitter != null) {
            this.sender = this.transmitter.getSender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    public void startStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.started = false;
        this.startPT = -1L;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushBufferStream pushBufferStream) {
        try {
            Object object = this.startReq;
            synchronized (object) {
                while (!this.started) {
                    this.startPT = -1L;
                    this.startReq.wait();
                }
            }
            pushBufferStream.read(this.current);
            if (!this.current.getFormat().matches(this.info.myformat)) {
                int n = this.transmitter.cache.sm.formatinfo.getPayload(this.current.getFormat());
                if (n == -1) {
                    return;
                }
                LocalPayloadChangeEvent localPayloadChangeEvent = new LocalPayloadChangeEvent(this.transmitter.cache.sm, this.info, this.info.payloadType, n);
                this.transmitter.cache.eventhandler.postEvent(localPayloadChangeEvent);
                this.info.payloadType = n;
                this.info.myformat = this.current.getFormat();
            }
            if (this.info.myformat instanceof VideoFormat) {
                this.transmitVideo();
            } else if (this.info.myformat instanceof AudioFormat) {
                this.transmitAudio();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transmitAudio() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.audioPT = this.startPT = this.current.getTimeStamp() <= 0L ? 0L : this.current.getTimeStamp() / 1000000L;
        }
        if ((this.current.getFlags() & 0x60) == 0) {
            this.audioPT = mpegAudio.matches(this.current.getFormat()) ? this.current.getTimeStamp() / 1000000L : (this.audioPT += ((AudioFormat)this.info.myformat).computeDuration(this.current.getLength()) / 1000000L);
            this.waitForPT(this.startTime, this.startPT, this.audioPT);
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    private void transmitVideo() {
        if (this.current.isEOM() || this.current.isDiscard()) {
            this.startPT = -1L;
            this.mpegBFrame = false;
            this.mpegPFrame = false;
            return;
        }
        if (this.startPT == -1L) {
            this.startTime = System.currentTimeMillis();
            this.startPT = this.current.getTimeStamp() / 1000000L;
        }
        if (this.current.getTimeStamp() > 0L && (this.current.getFlags() & 0x60) == 0 && (this.current.getFlags() & 0x800) != 0) {
            if (mpegVideo.matches(this.info.myformat)) {
                int n;
                byte[] byArray = (byte[])this.current.getData();
                int n2 = byArray[(n = this.current.getOffset()) + 2] & 7;
                if (n2 > 2) {
                    this.mpegBFrame = true;
                } else if (n2 == 2) {
                    this.mpegPFrame = true;
                }
                if (n2 > 2 || n2 == 2 && !this.mpegBFrame || n2 == 1 && !(this.mpegBFrame | this.mpegPFrame)) {
                    this.waitForPT(this.startTime, this.startPT, this.current.getTimeStamp() / 1000000L);
                }
            } else {
                this.waitForPT(this.startTime, this.startPT, this.current.getTimeStamp() / 1000000L);
            }
        }
        this.transmitter.TransmitPacket(this.current, this.info);
    }

    private void waitForPT(long l, long l2, long l3) {
        long l4 = l3 - l2 - (System.currentTimeMillis() - l);
        while (l4 > (long)LEEWAY) {
            if (l4 > (long)THRESHOLD) {
                l4 = THRESHOLD;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l4);
            }
            catch (Exception exception) {
                break;
            }
            l4 = l3 - l2 - (System.currentTimeMillis() - l);
        }
    }
}

