/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SSRCInUseException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.StreamClosedEvent;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.FormatInfo;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.OverallTransStats;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTCPRawReceiver;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReceiver;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPReporter;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPDemultiplexer;
import net.sf.fmj.media.rtp.RTPMediaLocator;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPRawSender;
import net.sf.fmj.media.rtp.RTPReceiver;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RTPSourceInfoCache;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCCacheCleaner;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.TrueRandom;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.PacketForwarder;
import net.sf.fmj.media.rtp.util.RTPPacketSender;
import net.sf.fmj.media.rtp.util.SSRCTable;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    private static final Logger logger = Logger.getLogger(RTPSessionMgr.class.getName());
    private static final String SOURCE_DESC_EMAIL = "fmj-devel@lists.sourceforge.net";
    private static final String SOURCE_DESC_TOOL = "FMJ RTP Player";
    boolean bindtome = false;
    private SSRCCache cache = null;
    int ttl = 0;
    int sendercount = 0;
    InetAddress localDataAddress = null;
    int localDataPort = 0;
    InetAddress localControlAddress = null;
    int localControlPort = 0;
    InetAddress dataaddress = null;
    InetAddress controladdress = null;
    int dataport = 0;
    int controlport = 0;
    RTPPushDataSource rtpsource = null;
    RTPPushDataSource rtcpsource = null;
    long defaultSSRC = 0L;
    SessionAddress localSenderAddress = null;
    private SessionAddress localReceiverAddress = null;
    UDPPacketSender udpsender = null;
    RTPPacketSender rtpsender = null;
    RTCPRawSender sender = null;
    SSRCCacheCleaner cleaner = null;
    private boolean unicast = false;
    private boolean startedparticipating = false;
    private boolean nonparticipating = false;
    private boolean nosockets = false;
    private boolean started = false;
    private boolean initialized = false;
    protected Vector sessionlistener = null;
    protected Vector remotelistener = null;
    protected Vector streamlistener = null;
    protected Vector sendstreamlistener = null;
    private static final int GET_ALL_PARTICIPANTS = -1;
    boolean encryption = false;
    final SSRCTable<net.sf.fmj.media.protocol.rtp.DataSource> dslist = new SSRCTable();
    StreamSynch streamSynch = null;
    FormatInfo formatinfo = null;
    net.sf.fmj.media.protocol.rtp.DataSource defaultsource = null;
    PushBufferStream defaultstream = null;
    Format defaultformat = null;
    BufferControl buffercontrol = null;
    OverallStats defaultstats = null;
    OverallTransStats transstats = null;
    int defaultsourceid = 0;
    Vector sendstreamlist = null;
    RTPTransmitter rtpTransmitter = null;
    private RTCPReportBuilder rtcpReportBuilder;
    boolean bds = false;
    Vector peerlist = null;
    boolean multi_unicast = false;
    Hashtable peerrtplist = null;
    Hashtable peerrtcplist = null;
    static FormatInfo supportedList = null;
    static Vector addedList = new Vector();
    private boolean newRtpInterface = false;
    private SessionAddress remoteAddress = null;
    private SessionAddress localAddress = null;
    private RTCPRawReceiver rtcpRawReceiver = null;
    private RTPRawReceiver rtpRawReceiver = null;
    private PacketForwarder rtpForwarder = null;
    private PacketForwarder rtcpForwarder = null;
    private RTPDemultiplexer rtpDemultiplexer = null;
    private OverallStats overallStats = null;
    private boolean participating = false;
    private UDPPacketSender udpPacketSender = null;
    private Vector remoteAddresses = null;
    private RTCPTransmitter rtcpTransmitter = null;
    private RTPConnector rtpConnector = null;
    private DatagramSocket dataSocket = null;
    private DatagramSocket controlSocket = null;
    private final int MAX_PORT = 65535;

    public static boolean formatSupported(Format format) {
        if (supportedList == null) {
            supportedList = new FormatInfo();
        }
        if (supportedList.getPayload(format) != -1) {
            return true;
        }
        for (int i = 0; i < addedList.size(); ++i) {
            Format format2 = (Format)addedList.elementAt(i);
            if (!format2.matches(format)) continue;
            return true;
        }
        return false;
    }

    public RTPSessionMgr() {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.streamSynch = new StreamSynch();
    }

    public RTPSessionMgr(net.sf.fmj.media.protocol.rtp.DataSource dataSource) throws IOException {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.UpdateEncodings(dataSource);
        RTPMediaLocator rTPMediaLocator = null;
        try {
            rTPMediaLocator = new RTPMediaLocator(dataSource.getLocator().toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("RTP URL is Malformed " + malformedURLException.getMessage());
        }
        net.sf.fmj.media.protocol.rtp.DataSource dataSource2 = this.createNewDS(rTPMediaLocator);
        RTPControl rTPControl = (RTPControl)dataSource.getControl("javax.media.rtp.RTPControl");
        dataSource2.setControl(rTPControl);
        String string = rTPMediaLocator.getSessionAddress();
        this.dataport = rTPMediaLocator.getSessionPort();
        this.controlport = this.dataport + 1;
        this.ttl = rTPMediaLocator.getTTL();
        try {
            this.dataaddress = InetAddress.getByName(string);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "error retrieving address " + string + " by name" + throwable.getMessage(), throwable);
        }
        this.controladdress = this.dataaddress;
        SessionAddress sessionAddress = new SessionAddress();
        try {
            this.initSession(sessionAddress, this.setSDES(), 0.05, 0.25);
        }
        catch (SessionManagerException sessionManagerException) {
            throw new IOException("SessionManager exception " + sessionManagerException.getMessage());
        }
    }

    public RTPSessionMgr(RTPPushDataSource rTPPushDataSource) {
        this.sessionlistener = new Vector();
        this.remotelistener = new Vector();
        this.streamlistener = new Vector();
        this.sendstreamlistener = new Vector();
        this.sendstreamlist = new Vector(1);
        this.peerlist = new Vector();
        this.peerrtplist = new Hashtable(5);
        this.peerrtcplist = new Hashtable(5);
        this.nosockets = true;
        this.rtpsource = rTPPushDataSource;
        if (this.rtpsource instanceof RTPSocket) {
            this.rtcpsource = ((RTPSocket)this.rtpsource).getControlChannel();
        }
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        net.sf.fmj.media.protocol.rtp.DataSource dataSource = this.createNewDS(null);
        this.UpdateEncodings(rTPPushDataSource);
        RTPControl rTPControl = (RTPControl)rTPPushDataSource.getControl(RTPControl.class.getName());
        dataSource.setControl(rTPControl);
        this.initSession(this.setSDES(), 0.05, 0.25);
        this.startSession(this.rtpsource, this.rtcpsource, null);
    }

    public void addFormat(Format format, int n) {
        if (this.formatinfo != null) {
            this.formatinfo.add(n, format);
        }
        if (format != null) {
            addedList.addElement(format);
        }
    }

    public void addMRL(RTPMediaLocator rTPMediaLocator) {
        net.sf.fmj.media.protocol.rtp.DataSource dataSource;
        int n = (int)rTPMediaLocator.getSSRC();
        if (n != 0 && (dataSource = this.dslist.get(n)) == null) {
            this.createNewDS(rTPMediaLocator);
        }
    }

    public void addPeer(SessionAddress sessionAddress) throws IOException, InvalidSessionAddressException {
        SSRCInfo sSRCInfo;
        Object object;
        for (int i = 0; i < this.peerlist.size(); ++i) {
            object = (SessionAddress)this.peerlist.elementAt(i);
            if (!((SessionAddress)object).equals(sessionAddress)) continue;
            return;
        }
        this.peerlist.addElement(sessionAddress);
        this.CheckRTPPorts(sessionAddress.getDataPort(), sessionAddress.getControlPort());
        RTCPRawReceiver rTCPRawReceiver = null;
        RTPRawReceiver rTPRawReceiver = null;
        InetAddress inetAddress = sessionAddress.getDataAddress();
        InetAddress inetAddress2 = sessionAddress.getControlAddress();
        int n = sessionAddress.getDataPort();
        int n2 = sessionAddress.getControlPort();
        this.CheckRTPAddress(inetAddress, inetAddress2);
        InetAddress inetAddress3 = null;
        try {
            inetAddress3 = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "InitSession : UnknownHostExcpetion " + throwable.getMessage(), throwable);
        }
        if (!inetAddress.isMulticastAddress() && !inetAddress.equals(inetAddress3)) {
            this.bindtome = !this.isBroadcast(inetAddress) || this.Win32();
        }
        if (this.bindtome) {
            return;
        }
        try {
            rTCPRawReceiver = new RTCPRawReceiver(n2, inetAddress2.getHostAddress(), this.defaultstats, this.streamSynch);
            if (inetAddress != null) {
                rTPRawReceiver = new RTPRawReceiver(n, inetAddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        finally {
            if (inetAddress != null && rTPRawReceiver == null && rTCPRawReceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rTCPRawReceiver.closeSource();
            }
        }
        try {
            rTCPRawReceiver = new RTCPRawReceiver(n2, inetAddress3.getHostAddress(), this.defaultstats, this.streamSynch);
            if (inetAddress != null) {
                rTPRawReceiver = new RTPRawReceiver(n, inetAddress3.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        finally {
            if (inetAddress != null && rTPRawReceiver == null && rTCPRawReceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rTCPRawReceiver.closeSource();
            }
        }
        PacketForwarder packetForwarder = new PacketForwarder(rTCPRawReceiver, new RTCPReceiver(this.cache));
        object = null;
        if (rTPRawReceiver != null) {
            object = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        packetForwarder.startPF("RTCP Forwarder for address" + inetAddress2.toString() + "port " + n2);
        if (object != null) {
            ((PacketForwarder)object).startPF("RTP Forwarder for address " + inetAddress.toString() + "port " + n);
        }
        this.peerrtplist.put(sessionAddress, object);
        this.peerrtcplist.put(sessionAddress, packetForwarder);
        if (this.cache.ourssrc != null) {
            if (this.cache.ourssrc.reporter == null) {
                this.controladdress = inetAddress2;
                this.controlport = n2;
                this.cache.ourssrc.reporter = this.startParticipating(n2, inetAddress.getHostAddress(), this.cache.ourssrc);
            }
            if (this.cache.ourssrc.reporter.transmit.sender.peerlist == null) {
                this.cache.ourssrc.reporter.transmit.sender.peerlist = new Vector();
            }
        }
        this.cache.ourssrc.reporter.transmit.sender.peerlist.addElement(sessionAddress);
        if (this.cache != null) {
            Enumeration<SSRCInfo> enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                sSRCInfo = enumeration.nextElement();
                if (!(sSRCInfo instanceof SendSSRCInfo)) continue;
                sSRCInfo.reporter.transmit.sender.control = true;
                if (sSRCInfo.reporter.transmit.sender.peerlist != null) continue;
                sSRCInfo.reporter.transmit.sender.peerlist = new Vector();
                sSRCInfo.reporter.transmit.sender.peerlist.addElement(sessionAddress);
            }
        }
        for (int i = 0; i < this.sendstreamlist.size(); ++i) {
            sSRCInfo = (SendSSRCInfo)this.sendstreamlist.elementAt(i);
            if (((SendSSRCInfo)sSRCInfo).sinkstream.transmitter.sender.peerlist != null) continue;
            ((SendSSRCInfo)sSRCInfo).sinkstream.transmitter.sender.peerlist = new Vector();
            ((SendSSRCInfo)sSRCInfo).sinkstream.transmitter.sender.peerlist.addElement(sessionAddress);
        }
    }

    public void addReceiveStreamListener(ReceiveStreamListener receiveStreamListener) {
        if (!this.streamlistener.contains(receiveStreamListener)) {
            this.streamlistener.addElement(receiveStreamListener);
        }
    }

    public void addRemoteListener(RemoteListener remoteListener) {
        if (!this.remotelistener.contains(remoteListener)) {
            this.remotelistener.addElement(remoteListener);
        }
    }

    void addSendStream(SendStream sendStream) {
        this.sendstreamlist.addElement(sendStream);
    }

    public void addSendStreamListener(SendStreamListener sendStreamListener) {
        if (!this.sendstreamlistener.contains(sendStreamListener)) {
            this.sendstreamlistener.addElement(sendStreamListener);
        }
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.sessionlistener.contains(sessionListener)) {
            this.sessionlistener.addElement(sessionListener);
        }
    }

    public void addTarget(SessionAddress sessionAddress) throws IOException {
        this.remoteAddresses.addElement(sessionAddress);
        if (this.remoteAddresses.size() > 1) {
            this.setRemoteAddresses();
            return;
        }
        this.remoteAddress = sessionAddress;
        logger.finest("Added target: " + sessionAddress);
        try {
            this.rtcpRawReceiver = new RTCPRawReceiver(this.localAddress, sessionAddress, this.defaultstats, this.streamSynch, this.controlSocket);
            this.rtpRawReceiver = new RTPRawReceiver(this.localAddress, sessionAddress, this.defaultstats, this.dataSocket);
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException(unknownHostException.getMessage());
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtpRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + sessionAddress.getControlHostAddress() + " port " + sessionAddress.getControlPort());
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + sessionAddress.getDataHostAddress() + " port " + sessionAddress.getDataPort());
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.cache.ourssrc != null && this.participating) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtcpRawReceiver.socket);
        }
    }

    public void addUnicastAddr(InetAddress inetAddress) {
        if (this.sender != null) {
            this.sender.addDestAddr(inetAddress);
        }
    }

    private void CheckRTPAddress(InetAddress inetAddress, InetAddress inetAddress2) throws InvalidSessionAddressException {
        if (inetAddress == null && inetAddress2 == null) {
            throw new InvalidSessionAddressException("Data and control addresses are null");
        }
        if (inetAddress2 == null && inetAddress != null) {
            inetAddress2 = inetAddress;
        }
        if (inetAddress == null && inetAddress2 != null) {
            inetAddress = inetAddress2;
        }
    }

    private void CheckRTPPorts(int n, int n2) throws InvalidSessionAddressException {
        if (n == 0 || n == -1) {
            n = n2 - 1;
        }
        if (n2 == 0 || n2 == -1) {
            n2 = n + 1;
        }
        if (n != 0 && n % 2 != 0) {
            throw new InvalidSessionAddressException("Data Port must be valid and even");
        }
        if (n2 != 0 && n2 % 2 != 1) {
            throw new InvalidSessionAddressException("Control Port must be valid and odd");
        }
        if (n2 != n + 1) {
            throw new InvalidSessionAddressException("Control Port must be one higher than the Data Port");
        }
    }

    public void closeSession() {
        if (this.dslist.isEmpty() || this.nosockets) {
            this.closeSession("DataSource disconnected");
        }
    }

    public void closeSession(String string) {
        this.stopParticipating(string, this.cache.ourssrc);
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration<SSRCInfo> enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                SSRCInfo sSRCInfo = enumeration.nextElement();
                if (sSRCInfo.dstream != null) {
                    sSRCInfo.dstream.close();
                }
                if (sSRCInfo instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)sSRCInfo).close();
                }
                this.stopParticipating(string, sSRCInfo);
            }
        }
        for (int i = 0; i < this.sendstreamlist.size(); ++i) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i));
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rTCPRawReceiver = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rTCPRawReceiver != null) {
                rTCPRawReceiver.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rTPRawReceiver = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rTPRawReceiver != null) {
                rTPRawReceiver.close();
            }
        }
        if (this.multi_unicast) {
            this.removeAllPeers();
        }
    }

    public net.sf.fmj.media.protocol.rtp.DataSource createNewDS(int n) {
        net.sf.fmj.media.protocol.rtp.DataSource dataSource = new net.sf.fmj.media.protocol.rtp.DataSource();
        dataSource.setContentType("raw");
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error connecting data source " + iOException.getMessage(), iOException);
        }
        RTPSourceStream rTPSourceStream = new RTPSourceStream(dataSource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rTPSourceStream);
        this.dslist.put(n, dataSource);
        dataSource.setSSRC(n);
        dataSource.setMgr(this);
        return dataSource;
    }

    public net.sf.fmj.media.protocol.rtp.DataSource createNewDS(RTPMediaLocator rTPMediaLocator) {
        net.sf.fmj.media.protocol.rtp.DataSource dataSource = new net.sf.fmj.media.protocol.rtp.DataSource();
        dataSource.setContentType("raw");
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "IOException in createNewDS() " + iOException.getMessage(), iOException);
        }
        RTPSourceStream rTPSourceStream = new RTPSourceStream(dataSource);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(rTPSourceStream);
        if (rTPMediaLocator != null && (int)rTPMediaLocator.getSSRC() != 0) {
            this.dslist.put((int)rTPMediaLocator.getSSRC(), dataSource);
            dataSource.setSSRC((int)rTPMediaLocator.getSSRC());
            dataSource.setMgr(this);
        } else {
            this.defaultsource = dataSource;
            this.defaultstream = rTPSourceStream;
        }
        return dataSource;
    }

    public SendStream createSendStream(int n, DataSource dataSource, int n2) throws UnsupportedFormatException, IOException, SSRCInUseException {
        Serializable serializable;
        PushBufferStream[] pushBufferStreamArray;
        if (this.sendercount != 0 && (pushBufferStreamArray = this.cache.lookup(n)) != null) {
            throw new SSRCInUseException("SSRC supplied is already in use");
        }
        if (this.cache.rtcp_bw_fraction == 0.0) {
            throw new IOException("Initialized with zero RTP/RTCP outgoing bandwidth. Cannot create a sending stream ");
        }
        pushBufferStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        PushBufferStream pushBufferStream = pushBufferStreamArray[n2];
        Format format = pushBufferStream.getFormat();
        int n3 = this.formatinfo.getPayload(format);
        if (n3 == -1) {
            throw new UnsupportedFormatException("Format of Stream not supported in RTP Session Manager", format);
        }
        SendSSRCInfo sendSSRCInfo = null;
        if (this.sendercount == 0) {
            sendSSRCInfo = new SendSSRCInfo(this.cache.ourssrc);
            sendSSRCInfo.ours = true;
            this.cache.ourssrc = sendSSRCInfo;
            this.cache.getMainCache().put(sendSSRCInfo.ssrc, sendSSRCInfo);
        } else {
            sendSSRCInfo = (SendSSRCInfo)this.cache.get(n, this.dataaddress, this.dataport, 3);
            sendSSRCInfo.ours = true;
            sendSSRCInfo.reporter = !this.nosockets ? this.startParticipating(this.controlport, this.controladdress.getHostAddress(), sendSSRCInfo) : this.startParticipating(this.rtcpsource, (SSRCInfo)sendSSRCInfo);
        }
        sendSSRCInfo.payloadType = n3;
        sendSSRCInfo.sinkstream.setSSRCInfo(sendSSRCInfo);
        sendSSRCInfo.setFormat(format);
        if (format instanceof VideoFormat) {
            sendSSRCInfo.clockrate = 90000;
        } else if (format instanceof AudioFormat) {
            sendSSRCInfo.clockrate = (int)((AudioFormat)format).getSampleRate();
        } else {
            throw new UnsupportedFormatException("Format not supported", format);
        }
        sendSSRCInfo.pds = dataSource;
        pushBufferStream.setTransferHandler(sendSSRCInfo.sinkstream);
        if (this.multi_unicast) {
            if (this.peerlist.size() > 0) {
                serializable = (SessionAddress)this.peerlist.firstElement();
                this.dataport = serializable.getDataPort();
                this.dataaddress = serializable.getDataAddress();
            } else {
                throw new IOException("At least one peer must be added");
            }
        }
        if (this.rtpTransmitter == null) {
            if (this.rtpConnector != null) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpConnector);
            } else if (this.nosockets) {
                this.rtpTransmitter = this.startDataTransmission(this.rtpsource);
            } else {
                if (this.newRtpInterface) {
                    this.dataport = this.remoteAddress.getDataPort();
                    this.dataaddress = this.remoteAddress.getDataAddress();
                }
                this.rtpTransmitter = this.startDataTransmission(this.dataport, this.dataaddress.getHostAddress());
            }
            if (this.rtpTransmitter == null) {
                throw new IOException("Cannot create a transmitter");
            }
        }
        sendSSRCInfo.sinkstream.setTransmitter(this.rtpTransmitter);
        this.addSendStream(sendSSRCInfo);
        if (this.multi_unicast) {
            for (int i = 0; i < this.peerlist.size(); ++i) {
                SessionAddress sessionAddress = (SessionAddress)this.peerlist.elementAt(i);
                if (sendSSRCInfo.sinkstream.transmitter.sender.peerlist == null) {
                    sendSSRCInfo.sinkstream.transmitter.sender.peerlist = new Vector();
                }
                sendSSRCInfo.sinkstream.transmitter.sender.peerlist.addElement(sessionAddress);
                if (this.cache == null) continue;
                Enumeration<SSRCInfo> enumeration = this.cache.cache.elements();
                while (enumeration.hasMoreElements()) {
                    SSRCInfo sSRCInfo = enumeration.nextElement();
                    if (!(sSRCInfo instanceof SendSSRCInfo)) continue;
                    sSRCInfo.reporter.transmit.sender.control = true;
                    if (sSRCInfo.reporter.transmit.sender.peerlist == null) {
                        sSRCInfo.reporter.transmit.sender.peerlist = new Vector();
                    }
                    sSRCInfo.reporter.transmit.sender.peerlist.addElement(sessionAddress);
                }
            }
        }
        sendSSRCInfo.sinkstream.startStream();
        serializable = new NewSendStreamEvent(this, sendSSRCInfo);
        this.cache.eventhandler.postEvent((RTPEvent)serializable);
        return sendSSRCInfo;
    }

    public SendStream createSendStream(DataSource dataSource, int n) throws IOException, UnsupportedFormatException {
        int n2;
        if (this.sendercount == 0 && this.cache.ourssrc != null) {
            n2 = this.cache.ourssrc.ssrc;
        } else {
            while (this.cache.lookup(n2 = (int)this.generateSSRC(GenerateSSRCCause.CREATE_SEND_STREAM)) != null) {
            }
        }
        SendStream sendStream = null;
        try {
            sendStream = this.createSendStream(n2, dataSource, n);
            if (this.newRtpInterface) {
                this.setRemoteAddresses();
            }
        }
        catch (SSRCInUseException sSRCInUseException) {
            // empty catch block
        }
        return sendStream;
    }

    public void dispose() {
        if (this.rtpConnector != null) {
            this.rtpConnector.close();
            this.rtpConnector = null;
        }
        if (this.defaultsource != null) {
            this.defaultsource.disconnect();
        }
        if (this.cache != null) {
            Enumeration<SSRCInfo> enumeration = this.cache.cache.elements();
            while (enumeration.hasMoreElements()) {
                SSRCInfo sSRCInfo = enumeration.nextElement();
                if (sSRCInfo.dstream != null) {
                    sSRCInfo.dstream.close();
                }
                if (sSRCInfo instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)sSRCInfo).close();
                }
                this.stopParticipating("dispose", sSRCInfo);
            }
        }
        for (int i = 0; i < this.sendstreamlist.size(); ++i) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i));
        }
        if (this.rtpTransmitter != null) {
            this.rtpTransmitter.close();
        }
        if (this.rtcpTransmitter != null) {
            this.rtcpTransmitter.close();
        }
        if (this.rtcpForwarder != null) {
            RTCPRawReceiver rTCPRawReceiver = (RTCPRawReceiver)this.rtcpForwarder.getSource();
            this.rtcpForwarder.close();
            if (rTCPRawReceiver != null) {
                rTCPRawReceiver.close();
            }
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpForwarder != null) {
            RTPRawReceiver rTPRawReceiver = (RTPRawReceiver)this.rtpForwarder.getSource();
            this.rtpForwarder.close();
            if (rTPRawReceiver != null) {
                rTPRawReceiver.close();
            }
        }
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
        if (this.controlSocket != null) {
            this.controlSocket.close();
        }
    }

    private int findLocalPorts() {
        boolean bl = false;
        int n = -1;
        while (!bl) {
            do {
                double d;
                if ((n = (int)((d = Math.random()) * 65535.0)) % 2 == 0) continue;
                ++n;
            } while (n < 1024 || n > 65534);
            try {
                DatagramSocket datagramSocket = new DatagramSocket(n);
                datagramSocket.close();
                datagramSocket = new DatagramSocket(n + 1);
                datagramSocket.close();
                bl = true;
            }
            catch (SocketException socketException) {
                bl = false;
            }
        }
        return n;
    }

    public String generateCNAME() {
        return SourceDescription.generateCNAME();
    }

    public long generateSSRC() {
        return TrueRandom.nextInt();
    }

    protected long generateSSRC(GenerateSSRCCause generateSSRCCause) {
        return this.generateSSRC();
    }

    public Vector getActiveParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Participant participant = enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector2 = participant.getStreams()).size() <= 0) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Vector getAllParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || participant instanceof LocalParticipant && this.nonparticipating) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Object getControl(String string) {
        if (string.equals("javax.media.control.BufferControl")) {
            return this.buffercontrol;
        }
        return null;
    }

    public Object[] getControls() {
        Object[] objectArray = new Object[]{this.buffercontrol};
        return objectArray;
    }

    public net.sf.fmj.media.protocol.rtp.DataSource getDataSource(RTPMediaLocator rTPMediaLocator) {
        if (rTPMediaLocator == null) {
            return this.defaultsource;
        }
        int n = (int)rTPMediaLocator.getSSRC();
        return n == 0 ? this.defaultsource : this.dslist.get(n);
    }

    public long getDefaultSSRC() {
        return this.defaultSSRC;
    }

    public Format getFormat(int n) {
        return this.formatinfo.get(n);
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.defaultstats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.transstats;
    }

    public LocalParticipant getLocalParticipant() {
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || this.nonparticipating || !(participant instanceof LocalParticipant)) continue;
            return (LocalParticipant)participant;
        }
        return null;
    }

    public SessionAddress getLocalReceiverAddress() {
        return this.localReceiverAddress;
    }

    public SessionAddress getLocalSessionAddress() {
        if (this.newRtpInterface) {
            return this.localAddress;
        }
        SessionAddress sessionAddress = new SessionAddress(this.localDataAddress, this.localDataPort, this.localControlAddress, this.localControlPort);
        return sessionAddress;
    }

    public long getLocalSSRC() {
        return this.cache == null || this.cache.ourssrc == null ? Long.MAX_VALUE : (long)this.cache.ourssrc.ssrc;
    }

    public int getMulticastScope() {
        return this.ttl;
    }

    public Vector getPassiveParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Participant participant = enumeration.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (vector2 = participant.getStreams()).size() != 0) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public Vector getPeers() {
        return this.peerlist;
    }

    private String getProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public Vector getReceiveStreams() {
        Vector<RTPStream> vector = new Vector<RTPStream>();
        Vector vector2 = this.getAllParticipants();
        for (int i = 0; i < vector2.size(); ++i) {
            Participant participant = (Participant)vector2.elementAt(i);
            Vector vector3 = participant.getStreams();
            for (int j = 0; j < vector3.size(); ++j) {
                RTPStream rTPStream = (RTPStream)vector3.elementAt(j);
                if (!(rTPStream instanceof ReceiveStream)) continue;
                vector.addElement(rTPStream);
            }
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getRemoteParticipants() {
        Vector<Participant> vector = new Vector<Participant>();
        RTPSourceInfoCache rTPSourceInfoCache = this.cache.getRTPSICache();
        Hashtable<String, RTPSourceInfo> hashtable = rTPSourceInfoCache.getCacheTable();
        Enumeration<RTPSourceInfo> enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Participant participant = enumeration.nextElement();
            if (participant == null || !(participant instanceof RemoteParticipant)) continue;
            vector.addElement(participant);
        }
        return vector;
    }

    public SessionAddress getRemoteSessionAddress() {
        return this.remoteAddress;
    }

    public Vector getSendStreams() {
        return new Vector(this.sendstreamlist);
    }

    public SessionAddress getSessionAddress() {
        SessionAddress sessionAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        return sessionAddress;
    }

    public int getSSRC() {
        return 0;
    }

    SSRCCache getSSRCCache() {
        return this.cache;
    }

    public SSRCInfo getSSRCInfo(int n) {
        return this.cache.lookup(n);
    }

    public RTPStream getStream(long l) {
        Vector vector = null;
        vector = this.getAllParticipants();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RTPSourceInfo rTPSourceInfo = (RTPSourceInfo)vector.elementAt(i);
            RTPStream rTPStream = rTPSourceInfo.getSSRCStream(l);
            if (rTPStream == null) continue;
            return rTPStream;
        }
        return null;
    }

    public void initialize(RTPConnector rTPConnector) {
        this.rtpConnector = rTPConnector;
        this.newRtpInterface = true;
        String string = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, string, 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        int n = (int)this.generateSSRC(GenerateSSRCCause.INITIALIZE);
        this.ttl = 1;
        double d = this.rtpConnector.getRTCPBandwidthFraction();
        this.participating = d != 0.0;
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = 384000;
        this.formatinfo.setCache(this.cache);
        if (d <= 0.0) {
            d = 0.05;
        }
        this.cache.rtcp_bw_fraction = d;
        double d2 = this.rtpConnector.getRTCPSenderBandwidthFraction();
        if (d2 <= 0.0) {
            d2 = 0.25;
        }
        this.cache.rtcp_sender_bw_fraction = d2;
        this.cache.ourssrc = this.cache.get(n, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            sourceDescriptionArray = this.setCNAME(sourceDescriptionArray);
        }
        this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        this.cache.ourssrc.ssrc = n;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        this.rtpRawReceiver = new RTPRawReceiver(this.rtpConnector, this.defaultstats);
        this.rtcpRawReceiver = new RTCPRawReceiver(this.rtpConnector, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, this.rtpRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(this.rtpRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder: " + this.rtpConnector);
        }
        this.rtcpForwarder = new PacketForwarder(this.rtcpRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder: " + this.rtpConnector);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (this.participating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
        }
    }

    public void initialize(SessionAddress sessionAddress) throws InvalidSessionAddressException {
        String string = SourceDescription.generateCNAME();
        SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, string, 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        double d = 0.05;
        double d2 = 0.25;
        SessionAddress[] sessionAddressArray = new SessionAddress[]{sessionAddress};
        this.initialize(sessionAddressArray, sourceDescriptionArray, d, d2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(SessionAddress[] sessionAddressArray, SourceDescription[] sourceDescriptionArray, double d, double d2, EncryptionInfo encryptionInfo) throws InvalidSessionAddressException {
        InetAddress inetAddress;
        if (this.initialized) {
            return;
        }
        this.newRtpInterface = true;
        this.remoteAddresses = new Vector();
        int n = (int)this.generateSSRC(GenerateSSRCCause.INITIALIZE);
        this.ttl = 1;
        boolean bl = this.participating = d != 0.0;
        if (sessionAddressArray.length == 0) {
            throw new InvalidSessionAddressException("At least one local address is required!");
        }
        this.localAddress = sessionAddressArray[0];
        if (this.localAddress == null) {
            throw new InvalidSessionAddressException("Invalid local address: null");
        }
        InetAddress[] inetAddressArray = null;
        try {
            inetAddress = this.localAddress.getDataAddress();
            String string = null;
            string = inetAddress.getHostAddress().equals("0.0.0.0") ? "0.0.0.0" : inetAddress.getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Error during initialization: " + throwable.getMessage(), throwable);
            return;
        }
        if (this.localAddress.getDataAddress() == null) {
            this.localAddress.setDataHostAddress(inetAddress);
        }
        if (this.localAddress.getControlAddress() == null) {
            this.localAddress.setControlHostAddress(inetAddress);
        }
        if (this.localAddress.getDataAddress().isMulticastAddress()) {
            if (!this.localAddress.getControlAddress().isMulticastAddress()) throw new InvalidSessionAddressException("Invalid multicast address");
            this.ttl = this.localAddress.getTimeToLive();
        } else {
            Object object;
            boolean bl2 = true;
            boolean bl3 = true;
            try {
                logger.fine("Looking for local data address: " + this.localAddress.getDataAddress() + " and control address" + this.localAddress.getControlAddress());
                if (this.localAddress.getDataHostAddress().equals("0.0.0.0") || this.localAddress.getDataHostAddress().equals("::0")) {
                    bl2 = true;
                }
                if (this.localAddress.getControlHostAddress().equals("0.0.0.0") || this.localAddress.getControlHostAddress().equals("::0")) {
                    bl3 = true;
                }
                object = NetworkInterface.getNetworkInterfaces();
                while (!(!object.hasMoreElements() || bl2 && bl3)) {
                    NetworkInterface networkInterface = (NetworkInterface)object.nextElement();
                    Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        try {
                            InetAddress inetAddress2 = enumeration.nextElement();
                            logger.fine("Testing iface address " + this.localAddress.getDataAddress());
                            if (inetAddress2.equals(this.localAddress.getDataAddress())) {
                                bl2 = true;
                            }
                            if (!inetAddress2.equals(this.localAddress.getControlAddress())) continue;
                            bl3 = true;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error while enumerating local interfaces.", exception);
            }
            if (!bl2) {
                object = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Data Address " + (String)object);
            }
            if (!bl3) {
                object = "Does not belong to any of this hosts local interfaces";
                throw new InvalidSessionAddressException("Local Control Address " + (String)object);
            }
            if (this.localAddress.getDataPort() == -1) {
                int n2 = this.findLocalPorts();
                this.localAddress.setDataPort(n2);
                this.localAddress.setControlPort(n2 + 1);
            }
            if (!this.localAddress.getDataAddress().isMulticastAddress()) {
                try {
                    this.dataSocket = new DatagramSocket(this.localAddress.getDataPort(), this.localAddress.getDataAddress());
                }
                catch (SocketException socketException) {
                    throw new InvalidSessionAddressException("Can't open local data port: " + this.localAddress.getDataPort());
                }
            }
            if (!this.localAddress.getControlAddress().isMulticastAddress()) {
                try {
                    this.controlSocket = new DatagramSocket(this.localAddress.getControlPort(), this.localAddress.getControlAddress());
                }
                catch (SocketException socketException) {
                    if (this.dataSocket == null) throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                    this.dataSocket.close();
                    throw new InvalidSessionAddressException("Can't open local control port: " + this.localAddress.getControlPort());
                }
            }
        }
        this.cache = new SSRCCache(this);
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d2;
        this.cache.ourssrc = this.cache.get(n, inetAddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            SourceDescription[] sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = n;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
    }

    public int initSession(SessionAddress sessionAddress, long l, SourceDescription[] sourceDescriptionArray, double d, double d2) throws InvalidSessionAddressException {
        SourceDescription[] sourceDescriptionArray2;
        Object object;
        InetAddress inetAddress;
        if (this.initialized) {
            return -1;
        }
        if (d == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = l;
        this.localDataAddress = sessionAddress.getDataAddress();
        this.localControlAddress = sessionAddress.getControlAddress();
        this.localDataPort = sessionAddress.getDataPort();
        this.localControlPort = sessionAddress.getControlPort();
        InetAddress[] inetAddressArray = null;
        try {
            inetAddress = this.localAddress.getDataAddress();
            String string = inetAddress.getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "InitSession  RTPSessionMgr :" + throwable.getMessage(), throwable);
            return -1;
        }
        if (this.localDataAddress == null) {
            this.localDataAddress = inetAddress;
        }
        if (this.localControlAddress == null) {
            this.localControlAddress = inetAddress;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                sourceDescriptionArray2 = object.nextElement();
                Enumeration<InetAddress> enumeration = sourceDescriptionArray2.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    try {
                        InetAddress inetAddress2 = enumeration.nextElement();
                        if (inetAddress2.equals(this.localAddress.getDataAddress())) {
                            bl = true;
                        }
                        if (!inetAddress2.equals(this.localAddress.getControlAddress())) continue;
                        bl2 = true;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error while enumerating interfaces", exception);
        }
        object = "Does not belong to any of this hosts local interfaces";
        if (!bl) {
            throw new InvalidSessionAddressException("Local Data Address " + (String)object);
        }
        if (!bl2) {
            throw new InvalidSessionAddressException("Local Control Address" + (String)object);
        }
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d2;
        this.cache.ourssrc = this.cache.get((int)l, inetAddress, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = (int)l;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    public int initSession(SessionAddress sessionAddress, SourceDescription[] sourceDescriptionArray, double d, double d2) throws InvalidSessionAddressException {
        long l = this.generateSSRC(GenerateSSRCCause.INIT_SESSION);
        return this.initSession(sessionAddress, l, sourceDescriptionArray, d, d2);
    }

    private int initSession(SourceDescription[] sourceDescriptionArray, double d, double d2) {
        if (this.initialized) {
            return -1;
        }
        InetAddress inetAddress = null;
        if (d == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = this.generateSSRC(GenerateSSRCCause.INIT_SESSION);
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = d;
        this.cache.rtcp_sender_bw_fraction = d2;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "InitSession UnknownHostExcpetion " + throwable.getMessage(), throwable);
            return -1;
        }
        this.cache.ourssrc = this.cache.get((int)this.defaultSSRC, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(sourceDescriptionArray)) {
            SourceDescription[] sourceDescriptionArray2 = this.setCNAME(sourceDescriptionArray);
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray2);
        } else {
            this.cache.ourssrc.setSourceDescription(sourceDescriptionArray);
        }
        this.cache.ourssrc.ssrc = (int)this.defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    boolean isBroadcast(InetAddress inetAddress) {
        Object var2_2 = null;
        try {
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            byte[] byArray = inetAddress2.getAddress();
            int n = byArray[3] & 0xFF;
            n |= byArray[2] << 8 & 0xFF00;
            n |= byArray[1] << 16 & 0xFF0000;
            byte[] byArray2 = inetAddress.getAddress();
            int n2 = byArray2[3] & 0xFF;
            n2 |= byArray2[2] << 8 & 0xFF00;
            n2 |= byArray2[1] << 16 & 0xFF0000;
            if (((n |= byArray[0] << 24 & 0xFF000000) | 0xFF) == (n2 |= byArray2[0] << 24 & 0xFF000000)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.warning(unknownHostException.getMessage());
        }
        return false;
    }

    private boolean isCNAME(SourceDescription[] sourceDescriptionArray) {
        Object var2_2 = null;
        boolean bl = false;
        if (sourceDescriptionArray == null) {
            return bl;
        }
        for (int i = 0; i < sourceDescriptionArray.length; ++i) {
            try {
                int n = sourceDescriptionArray[i].getType();
                String string = sourceDescriptionArray[i].getDescription();
                if (n != 1 || string == null) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean isDefaultDSassigned() {
        return this.bds;
    }

    public boolean IsNonParticipating() {
        return this.nonparticipating;
    }

    public boolean isSenderDefaultAddr(InetAddress inetAddress) {
        if (this.sender == null) {
            return false;
        }
        InetAddress inetAddress2 = this.sender.getRemoteAddr();
        return inetAddress2.equals(inetAddress);
    }

    boolean isUnicast() {
        return this.unicast;
    }

    public void removeAllPeers() {
        for (int i = 0; i < this.peerlist.size(); ++i) {
            this.removePeer((SessionAddress)this.peerlist.elementAt(i));
        }
    }

    public void removeDataSource(net.sf.fmj.media.protocol.rtp.DataSource dataSource) {
        block5: {
            if (dataSource == this.defaultsource) {
                this.defaultsource = null;
                this.defaultstream = null;
                this.defaultsourceid = 0;
                this.bds = false;
            }
            this.dslist.removeObj(dataSource);
            if (dataSource != null) {
                try {
                    dataSource.disconnect();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(throwable instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)throwable;
                }
            }
        }
    }

    public void removePeer(SessionAddress sessionAddress) {
        PacketForwarder packetForwarder = (PacketForwarder)this.peerrtplist.get(sessionAddress);
        PacketForwarder packetForwarder2 = (PacketForwarder)this.peerrtplist.get(sessionAddress);
        if (packetForwarder != null) {
            packetForwarder.close();
        }
        if (packetForwarder2 != null) {
            packetForwarder2.close();
        }
        for (int i = 0; i < this.peerlist.size(); ++i) {
            SessionAddress sessionAddress2 = (SessionAddress)this.peerlist.elementAt(i);
            if (!sessionAddress2.equals(sessionAddress)) continue;
            this.peerlist.removeElementAt(i);
        }
    }

    public void removeReceiveStreamListener(ReceiveStreamListener receiveStreamListener) {
        this.streamlistener.removeElement(receiveStreamListener);
    }

    public void removeRemoteListener(RemoteListener remoteListener) {
        this.remotelistener.removeElement(remoteListener);
    }

    void removeSendStream(SendStream sendStream) {
        Object object;
        this.sendstreamlist.removeElement(sendStream);
        SendSSRCInfo sendSSRCInfo = (SendSSRCInfo)sendStream;
        if (sendSSRCInfo.sinkstream != null) {
            sendSSRCInfo.sinkstream.close();
            object = new StreamClosedEvent(this, sendStream);
            this.cache.eventhandler.postEvent((RTPEvent)object);
            this.stopParticipating("Closed Stream", sendSSRCInfo);
        }
        if (this.sendstreamlist.size() == 0 && this.cache.ourssrc != null) {
            if (this.cache.ourssrc.ssrc == sendSSRCInfo.ssrc && sendSSRCInfo.reporter == null) {
                long l = Long.MAX_VALUE;
                int n = 0;
                while ((l = this.generateSSRC(GenerateSSRCCause.REMOVE_SEND_STREAM)) != Long.MAX_VALUE && this.cache.lookup(n = (int)l) != null) {
                }
                if (l == Long.MAX_VALUE) {
                    object = new PassiveSSRCInfo(this.cache.ourssrc);
                } else {
                    object = this.cache.get(n, null, 0, 2);
                    ((SSRCInfo)object).setAlive(true);
                    SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(3, SOURCE_DESC_EMAIL, 1, false), new SourceDescription(1, this.generateCNAME(), 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
                    ((SSRCInfo)object).setSourceDescription(this.isCNAME(sourceDescriptionArray) ? sourceDescriptionArray : this.setCNAME(sourceDescriptionArray));
                    ((SSRCInfo)object).ssrc = n;
                }
            } else {
                object = new PassiveSSRCInfo(this.cache.ourssrc);
            }
            ((SSRCInfo)object).setOurs(true);
            this.cache.ourssrc = object;
            this.cache.getMainCache().put(((SSRCInfo)object).ssrc, (SSRCInfo)object);
            if (this.rtpConnector != null) {
                this.cache.ourssrc.reporter = this.startParticipating(this.rtpConnector, this.cache.ourssrc);
            }
        }
    }

    public void removeSendStreamListener(SendStreamListener sendStreamListener) {
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionlistener.removeElement(sessionListener);
    }

    public void removeTarget(SessionAddress sessionAddress, String string) {
        this.remoteAddresses.removeElement(sessionAddress);
        this.setRemoteAddresses();
        if (this.remoteAddresses.size() == 0 && this.cache != null) {
            this.stopParticipating(string, this.cache.ourssrc);
        }
    }

    public void removeTargets(String string) {
        if (this.cache != null) {
            this.stopParticipating(string, this.cache.ourssrc);
        }
        if (this.remoteAddresses != null) {
            this.remoteAddresses.removeAllElements();
        }
        this.setRemoteAddresses();
    }

    private SourceDescription[] setCNAME(SourceDescription[] sourceDescriptionArray) {
        int n;
        Object var2_2 = null;
        boolean bl = false;
        if (sourceDescriptionArray == null) {
            sourceDescriptionArray = new SourceDescription[1];
            String string = SourceDescription.generateCNAME();
            sourceDescriptionArray[0] = new SourceDescription(1, string, 1, false);
            return sourceDescriptionArray;
        }
        for (int i = 0; i < sourceDescriptionArray.length; ++i) {
            n = sourceDescriptionArray[i].getType();
            String string = sourceDescriptionArray[i].getDescription();
            if (n != 1 || string != null) continue;
            string = SourceDescription.generateCNAME();
            bl = true;
            break;
        }
        if (bl) {
            return sourceDescriptionArray;
        }
        SourceDescription[] sourceDescriptionArray2 = new SourceDescription[sourceDescriptionArray.length + 1];
        sourceDescriptionArray2[0] = new SourceDescription(1, SourceDescription.generateCNAME(), 1, false);
        n = 1;
        for (int i = 0; i < sourceDescriptionArray.length; ++i) {
            sourceDescriptionArray2[n] = new SourceDescription(sourceDescriptionArray[i].getType(), sourceDescriptionArray[i].getDescription(), 1, false);
            ++n;
        }
        return sourceDescriptionArray2;
    }

    public void setDefaultDSassigned(int n) {
        this.bds = true;
        this.defaultsourceid = n;
        this.dslist.put(n, this.defaultsource);
        this.defaultsource.setSSRC(n);
        this.defaultsource.setMgr(this);
    }

    public void setMulticastScope(int n) {
        if (n < 1) {
            n = 1;
        }
        this.ttl = n;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        if (this.udpsender != null) {
            try {
                this.udpsender.setttl(this.ttl);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "setMulticastScope Exception ", iOException);
            }
        }
    }

    private void setRemoteAddresses() {
        PacketFilter packetFilter;
        if (this.rtpTransmitter != null) {
            packetFilter = this.rtpTransmitter.getSender();
            ((RTPRawSender)packetFilter).setDestAddresses(this.remoteAddresses);
        }
        if (this.rtcpTransmitter != null) {
            packetFilter = this.rtcpTransmitter.getSender();
            ((RTCPRawSender)packetFilter).setDestAddresses(this.remoteAddresses);
        }
    }

    private SourceDescription[] setSDES() {
        SourceDescription[] sourceDescriptionArray = new SourceDescription[]{new SourceDescription(2, this.getProperty("user.name"), 1, false), new SourceDescription(1, SourceDescription.generateCNAME(), 1, false), new SourceDescription(6, SOURCE_DESC_TOOL, 1, false)};
        return sourceDescriptionArray;
    }

    public void setRTCPReportBuilder(RTCPReportBuilder rTCPReportBuilder) {
        this.rtcpReportBuilder = rTCPReportBuilder;
    }

    void setSessionBandwidth(int n) {
        this.cache.sessionbandwidth = n;
    }

    private RTPTransmitter startDataTransmission(int n, String string) throws IOException {
        RTPTransmitter rTPTransmitter = null;
        RTPRawSender rTPRawSender = null;
        if (this.localDataPort == -1) {
            this.udpsender = new UDPPacketSender(this.dataaddress, this.dataport);
        } else if (this.newRtpInterface) {
            this.udpsender = new UDPPacketSender(this.rtpRawReceiver.socket);
        } else {
            int n2 = this.localSenderAddress.getDataPort();
            InetAddress inetAddress = this.localSenderAddress.getDataAddress();
            this.udpsender = new UDPPacketSender(n2, inetAddress, this.dataaddress, this.dataport);
        }
        if (this.ttl != 1) {
            this.udpsender.setttl(this.ttl);
        }
        rTPRawSender = new RTPRawSender(this.dataport, string, this.udpsender);
        rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
        return rTPTransmitter;
    }

    private RTPTransmitter startDataTransmission(RTPConnector rTPConnector) {
        try {
            RTPRawSender rTPRawSender = null;
            RTPTransmitter rTPTransmitter = null;
            this.rtpsender = new RTPPacketSender(rTPConnector);
            rTPRawSender = new RTPRawSender(this.rtpsender);
            rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
            return rTPTransmitter;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private RTPTransmitter startDataTransmission(RTPPushDataSource rTPPushDataSource) {
        RTPRawSender rTPRawSender = null;
        RTPTransmitter rTPTransmitter = null;
        this.rtpsender = new RTPPacketSender(rTPPushDataSource);
        rTPRawSender = new RTPRawSender(this.rtpsender);
        rTPTransmitter = new RTPTransmitter(this.cache, rTPRawSender);
        return rTPTransmitter;
    }

    private synchronized RTCPReporter startParticipating(DatagramSocket datagramSocket) throws IOException {
        UDPPacketSender uDPPacketSender;
        this.udpPacketSender = uDPPacketSender = new UDPPacketSender(datagramSocket);
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.remoteAddress.getControlPort(), this.remoteAddress.getControlAddress().getHostAddress(), uDPPacketSender);
        this.rtcpTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        this.rtcpTransmitter.setSSRCInfo(this.cache.ourssrc);
        this.rtcpTransmitter.setReportBuilder(this.rtcpReportBuilder);
        RTCPReporter rTCPReporter = new RTCPReporter(this.cache, this.rtcpTransmitter);
        this.startedparticipating = true;
        return rTCPReporter;
    }

    private synchronized RTCPReporter startParticipating(int n, String string, SSRCInfo sSRCInfo) throws IOException {
        this.startedparticipating = true;
        UDPPacketSender uDPPacketSender = null;
        if (this.localControlPort == -1) {
            uDPPacketSender = new UDPPacketSender(this.controladdress, this.controlport);
            this.localControlPort = uDPPacketSender.getLocalPort();
            this.localControlAddress = uDPPacketSender.getLocalAddress();
        } else {
            uDPPacketSender = new UDPPacketSender(this.localControlPort, this.localControlAddress, this.controladdress, this.controlport);
        }
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(n, string, uDPPacketSender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        rTCPTransmitter.setReportBuilder(this.rtcpReportBuilder);
        return new RTCPReporter(this.cache, rTCPTransmitter);
    }

    private synchronized RTCPReporter startParticipating(RTPConnector rTPConnector, SSRCInfo sSRCInfo) {
        this.startedparticipating = true;
        try {
            this.rtpsender = new RTPPacketSender(rTPConnector.getControlOutputStream());
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "error initializing rtp sender  " + iOException.getMessage(), iOException);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        rTCPTransmitter.setReportBuilder(this.rtcpReportBuilder);
        return new RTCPReporter(this.cache, rTCPTransmitter);
    }

    private synchronized RTCPReporter startParticipating(RTPPushDataSource rTPPushDataSource, SSRCInfo sSRCInfo) {
        this.startedparticipating = true;
        this.rtpsender = new RTPPacketSender(rTPPushDataSource);
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        rTCPTransmitter.setReportBuilder(this.rtcpReportBuilder);
        return new RTCPReporter(this.cache, rTCPTransmitter);
    }

    private synchronized RTCPReporter startParticipating(SessionAddress sessionAddress, SessionAddress sessionAddress2, SSRCInfo sSRCInfo, DatagramSocket datagramSocket) throws IOException {
        this.localReceiverAddress = sessionAddress;
        this.startedparticipating = true;
        UDPPacketSender uDPPacketSender = null;
        int n = sessionAddress2.getControlPort();
        InetAddress inetAddress = sessionAddress2.getControlAddress();
        int n2 = sessionAddress.getControlPort();
        InetAddress inetAddress2 = sessionAddress.getControlAddress();
        uDPPacketSender = n == -1 ? new UDPPacketSender(inetAddress, n) : (n == n2 ? new UDPPacketSender(datagramSocket) : new UDPPacketSender(n, inetAddress, this.controladdress, this.controlport));
        if (this.ttl != 1) {
            uDPPacketSender.setttl(this.ttl);
        }
        RTCPRawSender rTCPRawSender = new RTCPRawSender(this.controlport, this.controladdress.getHostAddress(), uDPPacketSender);
        RTCPTransmitter rTCPTransmitter = new RTCPTransmitter(this.cache, rTCPRawSender);
        rTCPTransmitter.setSSRCInfo(sSRCInfo);
        rTCPTransmitter.setReportBuilder(this.rtcpReportBuilder);
        return new RTCPReporter(this.cache, rTCPTransmitter);
    }

    void startRTCPReports(InetAddress inetAddress) {
        if (!this.nonparticipating && !this.startedparticipating) {
            try {
                if (this.cache.ourssrc != null) {
                    this.cache.ourssrc.reporter = this.startParticipating(this.controlport, inetAddress.getHostAddress(), this.cache.ourssrc);
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "start rtcp reports  " + iOException.getMessage(), iOException);
            }
        }
    }

    public void startSession() throws IOException {
        SessionAddress sessionAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        try {
            this.startSession(sessionAddress, this.ttl, null);
        }
        catch (SessionManagerException sessionManagerException) {
            throw new IOException("SessionManager exception " + sessionManagerException.getMessage());
        }
    }

    public int startSession(int n, EncryptionInfo encryptionInfo) throws IOException {
        this.multi_unicast = true;
        if (n < 1) {
            n = 1;
        }
        this.ttl = n;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        return 0;
    }

    private int startSession(RTPPushDataSource rTPPushDataSource, RTPPushDataSource rTPPushDataSource2, EncryptionInfo encryptionInfo) {
        if (!this.initialized) {
            return -1;
        }
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        RTPRawReceiver rTPRawReceiver = new RTPRawReceiver(rTPPushDataSource, this.defaultstats);
        RTCPRawReceiver rTCPRawReceiver = new RTCPRawReceiver(rTPPushDataSource2, this.defaultstats, this.streamSynch);
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder " + rTPPushDataSource);
        }
        this.rtcpForwarder = new PacketForwarder(rTCPRawReceiver, new RTCPReceiver(this.cache));
        if (this.rtcpForwarder != null) {
            this.rtcpForwarder.startPF("RTCP Forwarder " + rTPPushDataSource);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(rTPPushDataSource2, this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public int startSession(SessionAddress sessionAddress, int n, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        if (n < 1) {
            n = 1;
        }
        this.ttl = n;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.controlport = sessionAddress.getControlPort();
        this.dataport = sessionAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionAddress.getDataAddress();
        this.controladdress = sessionAddress.getControlAddress();
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rTCPRawReceiver = null;
        RTPRawReceiver rTPRawReceiver = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "InitSession  RTPSessionMgr : " + throwable.getMessage(), throwable);
            return -1;
        }
        if (this.dataaddress.equals(inetAddress)) {
            this.unicast = true;
        }
        if (!this.dataaddress.isMulticastAddress() && !this.dataaddress.equals(inetAddress)) {
            boolean bl = this.bindtome = !this.isBroadcast(this.dataaddress) || this.Win32();
        }
        if (this.bindtome) {
            return -1;
        }
        try {
            rTCPRawReceiver = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rTPRawReceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        finally {
            if (this.dataaddress != null && rTPRawReceiver == null && rTCPRawReceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rTCPRawReceiver.closeSource();
            }
        }
        try {
            rTCPRawReceiver = new RTCPRawReceiver(this.controlport, inetAddress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rTPRawReceiver = new RTPRawReceiver(this.dataport, inetAddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        finally {
            if (this.dataaddress != null && rTPRawReceiver == null && rTCPRawReceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rTCPRawReceiver.closeSource();
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rTCPRawReceiver, new RTCPReceiver(this.cache));
        if (rTPRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public int startSession(SessionAddress sessionAddress, SessionAddress sessionAddress2, SessionAddress sessionAddress3, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        this.localSenderAddress = sessionAddress2;
        this.cache.sessionbandwidth = 384000;
        this.controlport = sessionAddress.getControlPort();
        this.dataport = sessionAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionAddress.getDataAddress();
        this.controladdress = sessionAddress.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Local Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rTCPRawReceiver = null;
        RTPRawReceiver rTPRawReceiver = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "InitSession : UnknownHostExcpetion " + throwable.getMessage(), throwable);
            return -1;
        }
        try {
            rTCPRawReceiver = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats, this.streamSynch);
            if (this.dataaddress != null) {
                rTPRawReceiver = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
            }
        }
        catch (SocketException socketException) {
            throw new IOException(socketException.getMessage());
        }
        finally {
            if (this.dataaddress != null && rTPRawReceiver == null && rTCPRawReceiver != null) {
                logger.warning("could not create RTCP/RTP raw receivers");
                rTCPRawReceiver.closeSource();
            }
        }
        this.rtpDemultiplexer = new RTPDemultiplexer(this.cache, rTPRawReceiver, this.streamSynch);
        this.rtcpForwarder = new PacketForwarder(rTCPRawReceiver, new RTCPReceiver(this.cache));
        if (rTPRawReceiver != null) {
            this.rtpForwarder = new PacketForwarder(rTPRawReceiver, new RTPReceiver(this.cache, this.rtpDemultiplexer));
        }
        this.rtcpForwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpForwarder != null) {
            this.rtpForwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.controlport = sessionAddress3.getControlPort();
        this.dataport = sessionAddress3.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = sessionAddress3.getDataAddress();
        this.controladdress = sessionAddress3.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Remote Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        this.cleaner = new SSRCCacheCleaner(this.cache, this.streamSynch);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startParticipating(sessionAddress, sessionAddress2, this.cache.ourssrc, rTCPRawReceiver.socket);
        }
        this.started = true;
        return 0;
    }

    private synchronized void stopParticipating(String string, SSRCInfo sSRCInfo) {
        if (sSRCInfo.reporter != null) {
            sSRCInfo.reporter.close(string);
            sSRCInfo.reporter = null;
        }
    }

    public String toString() {
        String string;
        if (this.newRtpInterface) {
            int n = 0;
            int n2 = 0;
            String string2 = "";
            if (this.localAddress != null) {
                n = this.localAddress.getControlPort();
                n2 = this.localAddress.getDataPort();
                string2 = this.localAddress.getDataHostAddress();
            }
            string = "RTPManager \n\tSSRCCache  " + this.cache + "\n\tDataport  " + n2 + "\n\tControlport  " + n + "\n\tAddress  " + string2 + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDemux  " + this.rtpDemultiplexer;
        } else {
            string = "RTPSession Manager  \n\tSSRCCache  " + this.cache + "\n\tDataport  " + this.dataport + "\n\tControlport  " + this.controlport + "\n\tAddress  " + this.dataaddress + "\n\tRTPForwarder  " + this.rtpForwarder + "\n\tRTPDEmux  " + this.rtpDemultiplexer;
        }
        return string;
    }

    public void UpdateEncodings(DataSource dataSource) {
        RTPControlImpl rTPControlImpl = (RTPControlImpl)dataSource.getControl(RTPControl.class.getName());
        if (rTPControlImpl != null && rTPControlImpl.codeclist != null) {
            Enumeration<Integer> enumeration = rTPControlImpl.codeclist.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = enumeration.nextElement();
                this.formatinfo.add(n, rTPControlImpl.codeclist.get(n));
            }
        }
    }

    private boolean Win32() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

