/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceptionStats;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.util.RTPInfo;

public abstract class RTPControlImpl
implements RTPControl,
RTPInfo {
    String cname = null;
    Hashtable<Integer, Format> codeclist = new Hashtable(5);
    int rtptime = 0;
    int seqno = 0;
    int payload = -1;
    String codec = "";
    Format currentformat = null;
    SSRCInfo stream = null;

    public void addFormat(Format format, int n) {
        this.codeclist.put(new Integer(n), format);
    }

    public abstract String getCNAME();

    public Component getControlComponent() {
        return null;
    }

    public Format getFormat() {
        return this.currentformat;
    }

    public Format getFormat(int n) {
        return this.codeclist.get(new Integer(n));
    }

    public Format[] getFormatList() {
        Format[] formatArray = new Format[this.codeclist.size()];
        int n = 0;
        Enumeration<Format> enumeration = this.codeclist.elements();
        while (enumeration.hasMoreElements()) {
            Format format = enumeration.nextElement();
            formatArray[n++] = (Format)format.clone();
        }
        return formatArray;
    }

    public GlobalReceptionStats getGlobalStats() {
        return null;
    }

    public ReceptionStats getReceptionStats() {
        if (this.stream == null) {
            return null;
        }
        RecvSSRCInfo recvSSRCInfo = (RecvSSRCInfo)this.stream;
        return recvSSRCInfo.getSourceReceptionStats();
    }

    public abstract int getSSRC();

    public void setRTPInfo(int n, int n2) {
        this.rtptime = n;
        this.seqno = n2;
    }

    public String toString() {
        String string = "\n\tRTPTime is " + this.rtptime + "\n\tSeqno is " + this.seqno;
        string = this.codeclist != null ? string + "\n\tCodecInfo is " + this.codeclist.toString() : string + "\n\tcodeclist is null";
        return string;
    }
}

