/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTPParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RTCPReport
implements Report {
    private String byeReason = "";
    private String cName = null;
    protected Vector<RTCPFeedback> feedbackReports = new Vector();
    protected RTCPHeader header;
    private boolean isBye = false;
    protected Participant participant;
    protected int sdesBytes = 0;
    protected Vector<SourceDescription> sourceDescriptions = new Vector();
    private long ssrc = 0L;
    private long systemTimeStamp;

    public RTCPReport(byte[] byArray, int n, int n2) throws IOException {
        this.header = new RTCPHeader(byArray, n, n2);
        if (this.header.getPadding() == 1) {
            throw new IOException("First packet has padding");
        }
        if ((this.header.getLength() + 1) * 4 > n2) {
            throw new IOException("Invalid Length");
        }
        this.ssrc = this.header.getSsrc();
        int n3 = 8;
        switch (this.header.getPacketType()) {
            case 200: {
                n3 += 20;
            }
            case 201: {
                this.readFeedbackReports(byArray, n + n3, n2 - n3);
                this.readSourceDescription(byArray, n += (this.header.getLength() + 1) * 4, n2 -= (this.header.getLength() + 1) * 4);
                this.readBye(byArray, n += this.sdesBytes, n2 -= this.sdesBytes);
                break;
            }
        }
    }

    public String getByeReason() {
        return this.byeReason;
    }

    public String getCName() {
        return this.cName;
    }

    @Override
    public Vector<RTCPFeedback> getFeedbackReports() {
        return this.feedbackReports;
    }

    @Override
    public Participant getParticipant() {
        return this.participant;
    }

    @Override
    public Vector<SourceDescription> getSourceDescription() {
        return this.sourceDescriptions;
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    public long getSystemTimeStamp() {
        return this.systemTimeStamp;
    }

    public boolean isByePacket() {
        return this.isBye;
    }

    protected void readBye(byte[] byArray, int n, int n2) throws IOException {
        RTCPHeader rTCPHeader;
        if (n2 > 0 && (rTCPHeader = new RTCPHeader(byArray, n, n2)).getPacketType() == 203) {
            int n3;
            this.isBye = true;
            if ((rTCPHeader.getLength() + 1) * 4 > 8 && (n3 = byArray[n + 8] & 0xFF) < n2 - 8 && n3 > 0) {
                this.byeReason = new String(byArray, n + 8 + 1, n3);
            }
        }
    }

    protected void readFeedbackReports(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < this.header.getReceptionCount(); ++i) {
            RTCPFeedback rTCPFeedback = new RTCPFeedback(byArray, n, n2);
            this.feedbackReports.add(rTCPFeedback);
            n += 24;
        }
    }

    protected void readSourceDescription(byte[] byArray, int n, int n2) throws IOException {
        RTCPHeader rTCPHeader;
        if (n2 > 0 && (rTCPHeader = new RTCPHeader(byArray, n, n2)).getPacketType() == 202) {
            this.ssrc = rTCPHeader.getSsrc();
            this.sdesBytes = (rTCPHeader.getLength() + 1) * 4;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n + 8, n2));
            int n3 = 1;
            while (n3 != 0) {
                n3 = dataInputStream.readUnsignedByte();
                if (n3 == 0) continue;
                int n4 = dataInputStream.readUnsignedByte();
                byte[] byArray2 = new byte[n4];
                dataInputStream.readFully(byArray2);
                String string = new String(byArray2, "UTF-8");
                SourceDescription sourceDescription = new SourceDescription(n3, string, 0, false);
                this.sourceDescriptions.add(sourceDescription);
                if (n3 != 1) continue;
                this.cName = string;
            }
        }
    }

    protected void setParticipant(RTPParticipant rTPParticipant) {
        this.participant = rTPParticipant;
        Vector vector = rTPParticipant.getStreams();
        if (vector.size() == 0) {
            Vector vector2 = rTPParticipant.getSourceDescription();
            for (int i = 0; i < vector2.size(); ++i) {
                SourceDescription sourceDescription = (SourceDescription)vector2.get(i);
                rTPParticipant.addSourceDescription(sourceDescription);
            }
        }
    }

    public void setSystemTimeStamp(long l) {
        this.systemTimeStamp = l;
    }
}

