/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.control;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.MonitorControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.control.MonitorThread;
import net.sf.fmj.media.util.AudioCodecChain;
import net.sf.fmj.media.util.CodecChain;
import net.sf.fmj.media.util.LoopThread;
import net.sf.fmj.media.util.VideoCodecChain;

public class MonitorAdapter
implements MonitorControl,
Owned {
    protected CodecChain cc = null;
    protected boolean enabled = false;
    protected boolean closed = false;
    protected Component visualComponent = null;
    protected Component controlComponent = null;
    protected Checkbox cbEnabled = null;
    protected Format format = null;
    protected float inFrameRate = 0.0f;
    protected float previewFrameRate = 30.0f;
    protected long lastPreviewTime = 0L;
    protected long previewInterval = 33333333L;
    protected MouseListener ml = null;
    protected PopupMenu rateMenu = null;
    protected LoopThread loopThread;
    protected int[] frameRates = new int[]{0, 1, 2, 5, 7, 10, 15, 20, 30, 60, 90};
    CircularBuffer bufferQ;
    Object owner;
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");

    public MonitorAdapter(Format format, Object object) {
        this.format = format;
        this.owner = object;
    }

    private void addPopupMenu(Component component) {
        MenuItem menuItem;
        this.visualComponent = component;
        this.rateMenu = new PopupMenu("Monitor Rate");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    String string = actionEvent.getActionCommand();
                    int n = string.indexOf(" ");
                    String string2 = string.substring(0, n);
                    try {
                        int n2 = Integer.parseInt(string2);
                        MonitorAdapter.this.setPreviewFrameRate(n2);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block2;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
        };
        component.add(this.rateMenu);
        int n = 0;
        for (int i = 0; i < this.frameRates.length; ++i) {
            if (!((float)this.frameRates[i] < this.inFrameRate)) continue;
            menuItem = new MenuItem(this.frameRates[i] + " fps");
            this.rateMenu.add(menuItem);
            menuItem.addActionListener(actionListener);
            n = this.frameRates[i];
        }
        if ((float)n < this.inFrameRate) {
            menuItem = new MenuItem(this.inFrameRate + " fps");
            this.rateMenu.add(menuItem);
            menuItem.addActionListener(actionListener);
        }
        this.ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        component.addMouseListener(this.ml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.cc == null) {
            return;
        }
        this.loopThread.kill();
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufferQ.notifyAll();
        }
        this.cc.close();
        this.cc = null;
    }

    private Object copyData(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = new byte[((byte[])object).length];
            System.arraycopy(object, 0, byArray, 0, byArray.length);
            return byArray;
        }
        if (object instanceof short[]) {
            short[] sArray = new short[((short[])object).length];
            System.arraycopy(object, 0, sArray, 0, sArray.length);
            return sArray;
        }
        if (object instanceof int[]) {
            int[] nArray = new int[((int[])object).length];
            System.arraycopy(object, 0, nArray, 0, nArray.length);
            return nArray;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doProcess() {
        Buffer buffer;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            while (!this.bufferQ.canRead() && this.enabled && !this.closed) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception exception) {}
            }
            if (this.closed) {
                return false;
            }
            if (!this.enabled) {
                return true;
            }
            buffer = this.bufferQ.read();
        }
        boolean bl = false;
        if (buffer.getFormat() instanceof AudioFormat) {
            bl = true;
        } else {
            long l = buffer.getTimeStamp();
            if (l >= this.lastPreviewTime + this.previewInterval || l <= this.lastPreviewTime) {
                if (mpegVideo.matches(this.format)) {
                    int n;
                    byte[] byArray = (byte[])buffer.getData();
                    int n2 = byArray[(n = buffer.getOffset()) + 2] & 7;
                    if (n2 == 1) {
                        this.lastPreviewTime = l;
                        bl = true;
                    }
                } else {
                    this.lastPreviewTime = l;
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        this.cc.process(buffer, bl);
        CircularBuffer circularBuffer2 = this.bufferQ;
        synchronized (circularBuffer2) {
            this.bufferQ.readReport();
            this.bufferQ.notifyAll();
        }
        return true;
    }

    public void finalize() {
        if (this.visualComponent != null) {
            this.visualComponent.remove(this.rateMenu);
            this.visualComponent.removeMouseListener(this.ml);
        }
    }

    public Component getControlComponent() {
        Panel panel;
        if (this.controlComponent != null) {
            return this.controlComponent;
        }
        if (this.cc == null && !this.open()) {
            return null;
        }
        this.controlComponent = this.cc.getControlComponent();
        if (this.format instanceof AudioFormat && this.controlComponent != null) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Audio");
            panel.add("West", this.cbEnabled);
            panel.add("Center", this.controlComponent);
            this.controlComponent = panel;
            panel.setBackground(Color.lightGray);
        }
        if (this.format instanceof VideoFormat && this.controlComponent != null) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Video");
            panel.add("South", this.cbEnabled);
            panel.add("Center", this.controlComponent);
            this.addPopupMenu(this.controlComponent);
            this.controlComponent = panel;
            panel.setBackground(Color.lightGray);
        }
        if (this.cbEnabled != null) {
            this.cbEnabled.setState(this.isEnabled());
            this.cbEnabled.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    MonitorAdapter.this.setEnabled(MonitorAdapter.this.cbEnabled.getState());
                }
            });
        }
        return this.controlComponent;
    }

    public Object getOwner() {
        return this.owner;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean open() {
        try {
            if (this.format instanceof VideoFormat) {
                VideoFormat videoFormat = (VideoFormat)this.format;
                this.cc = new VideoCodecChain(videoFormat);
                this.inFrameRate = videoFormat.getFrameRate();
                if (this.inFrameRate < 0.0f) {
                    this.inFrameRate = 30.0f;
                }
                this.inFrameRate = (float)((int)((double)(this.inFrameRate * 10.0f) + 0.5)) / 10.0f;
            } else if (this.format instanceof AudioFormat) {
                this.cc = new AudioCodecChain((AudioFormat)this.format);
            }
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            Log.warning("Failed to initialize the monitor control: " + unsupportedFormatException);
            return false;
        }
        if (this.cc == null) {
            return false;
        }
        this.bufferQ = new CircularBuffer(2);
        this.loopThread = new MonitorThread(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Buffer buffer) {
        if (buffer == null || this.previewFrameRate <= 0.0f || this.format == null || buffer.isEOM() || buffer.isDiscard() || (buffer.getFlags() & 0x200) != 0) {
            return;
        }
        if (!this.format.matches(buffer.getFormat())) {
            return;
        }
        Buffer buffer2 = null;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            while (!this.bufferQ.canWrite() && this.enabled && !this.closed) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception exception) {}
            }
            if (!this.enabled || this.closed) {
                return;
            }
            buffer2 = this.bufferQ.getEmptyBuffer();
        }
        buffer2.setData(this.copyData(buffer.getData()));
        buffer2.setFlags(buffer.getFlags());
        buffer2.setFormat(buffer.getFormat());
        buffer2.setSequenceNumber(buffer.getSequenceNumber());
        buffer2.setHeader(buffer.getHeader());
        buffer2.setLength(buffer.getLength());
        buffer2.setOffset(buffer.getOffset());
        buffer2.setRtpTimeStamp(buffer.getRtpTimeStamp());
        buffer2.setHeaderExtension(buffer.getHeaderExtension());
        buffer2.setTimeStamp(buffer.getTimeStamp());
        circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.bufferQ.writeReport();
            this.bufferQ.notifyAll();
        }
    }

    public void reset() {
        if (this.cc != null) {
            this.cc.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEnabled(boolean bl) {
        if (bl) {
            if (this.cc == null) {
                if (!this.open()) {
                    return false;
                }
            } else {
                this.cc.reset();
            }
            if (!this.cc.prefetch()) {
                return false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (this.bufferQ.canRead()) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
            }
            this.enabled = true;
            this.loopThread.start();
        } else if (!bl && this.cc != null) {
            this.loopThread.pause();
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.enabled = false;
                this.bufferQ.notifyAll();
            }
            this.cc.deallocate();
        }
        return this.enabled;
    }

    public float setPreviewFrameRate(float f) {
        if (f > this.inFrameRate) {
            f = this.inFrameRate;
        }
        this.previewFrameRate = f;
        this.previewInterval = (long)(1.0E9 / (double)f);
        return f;
    }
}

