/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.ChangeTools;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.GroupListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGroup
implements Group {
    private final SimpleBuddyList buddyList;
    private CopyOnWriteArrayList<GroupListener> listeners = new CopyOnWriteArrayList();
    private List<SimpleBuddy> buddies = new ArrayList<SimpleBuddy>();

    AbstractGroup(SimpleBuddyList buddyList) {
        this.buddyList = buddyList;
    }

    void sortBuddies() {
        this.buddies = this.getSortedBuddies();
    }

    protected abstract List<SimpleBuddy> getSortedBuddies();

    protected List<SimpleBuddy> getBuddies() {
        return this.buddies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimpleBuddy> getBuddiesCopy() {
        Object object = this.getBuddyListLock();
        synchronized (object) {
            return DefensiveTools.getUnmodifiableCopy(this.getBuddies());
        }
    }

    protected Object getBuddyListLock() {
        return this.buddyList.getLock();
    }

    protected BuddyList getBuddyList() {
        return this.buddyList;
    }

    void addBuddies(Collection<? extends SimpleBuddy> buddies) {
        this.buddies.addAll(buddies);
        assert (this.isGroupValid());
    }

    void removeBuddies(Collection<? extends SimpleBuddy> buddies) {
        this.buddies.removeAll(buddies);
        assert (this.isGroupValid());
    }

    void addBuddy(SimpleBuddy buddy) {
        this.buddies.add(buddy);
        assert (this.isGroupValid());
    }

    protected boolean isGroupValid() {
        for (SimpleBuddy buddy : this.buddies) {
            if (buddy != null) continue;
            return false;
        }
        HashSet<SimpleBuddy> set = new HashSet<SimpleBuddy>(this.buddies);
        return set.size() == this.buddies.size();
    }

    SimpleBuddy getBuddy(int id) {
        for (SimpleBuddy buddy : this.getBuddies()) {
            if (buddy.getItem().getId() != id) continue;
            return buddy;
        }
        return null;
    }

    void removeBuddy(Buddy buddy) {
        boolean removed = this.buddies.remove(buddy);
        if (!removed) {
            throw new IllegalArgumentException("buddy " + buddy + " is not " + "in group " + this);
        }
    }

    protected CopyOnWriteArrayList<GroupListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void addGroupListener(GroupListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    @Override
    public void removeGroupListener(GroupListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected GroupState saveState() {
        return new GroupState();
    }

    protected void detectChanges(GroupState oldState, GroupState newState) {
        String newName;
        assert (!Thread.holdsLock(this));
        String oldName = oldState.getName();
        if (ChangeTools.areEqual(oldName, newName = newState.getName())) {
            for (GroupListener listener : this.getListeners()) {
                listener.groupNameChanged(this, oldName, newName);
            }
        }
    }

    public String toString() {
        return "Group " + this.getName() + ": " + this.buddies.size() + " buddies";
    }

    protected class GroupState {
        private final String name = this.getName();

        protected GroupState() {
        }

        public String getName() {
            return this.name;
        }
    }
}

