/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.sdp.IceSdpUtils;

public class SdpUtils {
    public static String createSDPDescription(Agent agent) throws Throwable {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sdess = factory.createSessionDescription();
        IceSdpUtils.initSessionDescription(sdess, agent);
        return sdess.toString();
    }

    public static void parseSDP(Agent localAgent, String sdp) throws Exception {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sdess = factory.createSessionDescription(sdp);
        for (IceMediaStream stream : localAgent.getStreams()) {
            stream.setRemotePassword(sdess.getAttribute("ice-pwd"));
            stream.setRemoteUfrag(sdess.getAttribute("ice-ufrag"));
        }
        Connection globalConn = sdess.getConnection();
        String globalConnAddr = null;
        if (globalConn != null) {
            globalConnAddr = globalConn.getAddress();
        }
        Vector mdescs = sdess.getMediaDescriptions(true);
        for (MediaDescription desc : mdescs) {
            String streamName = desc.getMedia().getMediaType();
            IceMediaStream stream = localAgent.getStream(streamName);
            if (stream == null) continue;
            Vector attributes = desc.getAttributes(true);
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals("candidate")) continue;
                SdpUtils.parseCandidate(attribute, stream);
            }
            Connection streamConn = desc.getConnection();
            String streamConnAddr = null;
            streamConnAddr = streamConn != null ? streamConn.getAddress() : globalConnAddr;
            int port = desc.getMedia().getMediaPort();
            TransportAddress defaultRtpAddress = new TransportAddress(streamConnAddr, port, Transport.UDP);
            int rtcpPort = port + 1;
            String rtcpAttributeValue = desc.getAttribute("rtcp");
            if (rtcpAttributeValue != null) {
                rtcpPort = Integer.parseInt(rtcpAttributeValue);
            }
            TransportAddress defaultRtcpAddress = new TransportAddress(streamConnAddr, rtcpPort, Transport.UDP);
            Component rtpComponent = stream.getComponent(1);
            Component rtcpComponent = stream.getComponent(2);
            RemoteCandidate defaultRtpCandidate = rtpComponent.findRemoteCandidate(defaultRtpAddress);
            rtpComponent.setDefaultRemoteCandidate(defaultRtpCandidate);
            if (rtcpComponent == null) continue;
            RemoteCandidate defaultRtcpCandidate = rtcpComponent.findRemoteCandidate(defaultRtcpAddress);
            rtcpComponent.setDefaultRemoteCandidate(defaultRtcpCandidate);
        }
    }

    private static RemoteCandidate parseCandidate(Attribute attribute, IceMediaStream stream) {
        String value = null;
        try {
            value = attribute.getValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(value);
        String foundation = tokenizer.nextToken();
        int componentID = Integer.parseInt(tokenizer.nextToken());
        Transport transport = Transport.parse(tokenizer.nextToken());
        long priority = Long.parseLong(tokenizer.nextToken());
        String address = tokenizer.nextToken();
        int port = Integer.parseInt(tokenizer.nextToken());
        TransportAddress transAddr = new TransportAddress(address, port, transport);
        tokenizer.nextToken();
        CandidateType type = CandidateType.parse(tokenizer.nextToken());
        Component component = stream.getComponent(componentID);
        if (component == null) {
            return null;
        }
        RemoteCandidate relatedCandidate = null;
        if (tokenizer.countTokens() >= 4) {
            tokenizer.nextToken();
            String relatedAddr = tokenizer.nextToken();
            tokenizer.nextToken();
            int relatedPort = Integer.parseInt(tokenizer.nextToken());
            TransportAddress raddr = new TransportAddress(relatedAddr, relatedPort, Transport.UDP);
            relatedCandidate = component.findRemoteCandidate(raddr);
        }
        RemoteCandidate cand = new RemoteCandidate(transAddr, component, type, foundation, priority, relatedCandidate);
        component.addRemoteCandidate(cand);
        return cand;
    }
}

