/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ChangedAddressAttribute;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.SourceAddressAttribute;
import org.ice4j.attribute.UnknownAttributesAttribute;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;

public class MessageFactoryTest
extends TestCase {
    private MsgFixture msgFixture;

    public MessageFactoryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testCreateBindingErrorResponse() throws StunException {
        char errorCode = '\u0190';
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode);
        expectedReturn.addAttribute(errorCodeAtt);
        Response actualReturn = MessageFactory.createBindingErrorResponse(errorCode);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponse1() throws StunException {
        char errorCode = '\u0190';
        String reasonPhrase = "Bad Request";
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        expectedReturn.addAttribute(errorCodeAtt);
        Response actualReturn = MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase);
        MessageFactoryTest.assertEquals((String)"Failed to create an error code attribute.", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponseUnknownAttributes() throws StunException {
        char errorCode = '\u01a4';
        char[] unknownAttributes = new char[]{'\u0015', '\u0016', '\u0017'};
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode);
        errorCodeAtt.setReasonPhrase(ErrorCodeAttribute.getDefaultReasonPhrase(errorCode));
        expectedReturn.addAttribute(errorCodeAtt);
        UnknownAttributesAttribute unknownAtts = AttributeFactory.createUnknownAttributesAttribute();
        for (int i = 0; i < unknownAttributes.length; ++i) {
            unknownAtts.addAttributeID(unknownAttributes[i]);
        }
        expectedReturn.addAttribute(unknownAtts);
        Response actualReturn = MessageFactory.createBindingErrorResponseUnknownAttributes(unknownAttributes);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingErrorResponseUnknownAttributes1() throws StunException {
        char errorCode = '\u01a4';
        String reasonPhrase = "UnknwonAttributes";
        char[] unknownAttributes = new char[]{'\u0015', '\u0016', '\u0017'};
        Response expectedReturn = new Response();
        expectedReturn.setMessageType('\u0111');
        ErrorCodeAttribute errorCodeAtt = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        expectedReturn.addAttribute(errorCodeAtt);
        UnknownAttributesAttribute unknownAtts = AttributeFactory.createUnknownAttributesAttribute();
        for (int i = 0; i < unknownAttributes.length; ++i) {
            unknownAtts.addAttributeID(unknownAttributes[i]);
        }
        expectedReturn.addAttribute(unknownAtts);
        Response actualReturn = MessageFactory.createBindingErrorResponseUnknownAttributes(reasonPhrase, unknownAttributes);
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingRequest() throws StunException {
        Request bindingRequest;
        Request expectedReturn = bindingRequest = new Request();
        bindingRequest.setMessageType('\u0001');
        Request actualReturn = MessageFactory.createBindingRequest();
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateBindingResponse() throws Exception {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        MappedAddressAttribute mappedAddress = AttributeFactory.createMappedAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904, Transport.UDP));
        bindingResponse.addAttribute(mappedAddress);
        SourceAddressAttribute sourceAddress = AttributeFactory.createSourceAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478, Transport.UDP));
        bindingResponse.addAttribute(sourceAddress);
        ChangedAddressAttribute changedAddress = AttributeFactory.createChangedAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479, Transport.UDP));
        bindingResponse.addAttribute(changedAddress);
        Response expectedReturn = bindingResponse;
        Response actualReturn = MessageFactory.create3489BindingResponse(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904, Transport.UDP), new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478, Transport.UDP), new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479, Transport.UDP));
        MessageFactoryTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }
}

