/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.VCardXEP0153;
import net.java.sip.communicator.service.protocol.AbstractOperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;

public class OperationSetServerStoredAccountInfoJabberImpl
extends AbstractOperationSetServerStoredAccountInfo {
    private static final Logger logger = Logger.getLogger(OperationSetServerStoredAccountInfoJabberImpl.class);
    private InfoRetreiver infoRetreiver = null;
    private ProtocolProviderServiceJabberImpl jabberProvider = null;
    public static final List<Class<? extends ServerStoredDetails.GenericDetail>> supportedTypes = new ArrayList<Class<? extends ServerStoredDetails.GenericDetail>>();
    private String uin = null;

    protected OperationSetServerStoredAccountInfoJabberImpl(ProtocolProviderServiceJabberImpl jabberProvider, InfoRetreiver infoRetreiver, String uin) {
        this.infoRetreiver = infoRetreiver;
        this.jabberProvider = jabberProvider;
        this.uin = uin;
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(Class<T> detailClass) {
        this.assertConnected();
        return this.infoRetreiver.getDetailsAndDescendants(this.uin, detailClass);
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        this.assertConnected();
        return this.infoRetreiver.getDetails(this.uin, detailClass);
    }

    public Iterator<ServerStoredDetails.GenericDetail> getAllAvailableDetails() {
        this.assertConnected();
        return this.infoRetreiver.getContactDetails(this.uin).iterator();
    }

    public Iterator<Class<? extends ServerStoredDetails.GenericDetail>> getSupportedDetailTypes() {
        return supportedTypes.iterator();
    }

    public boolean isDetailClassSupported(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return supportedTypes.contains(detailClass);
    }

    public int getMaxDetailInstances(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return 1;
    }

    public void addDetail(ServerStoredDetails.GenericDetail detail) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!this.isDetailClassSupported(detail.getClass())) {
            throw new IllegalArgumentException("implementation does not support such details " + detail.getClass());
        }
        Iterator<ServerStoredDetails.GenericDetail> iter = this.getDetails(detail.getClass());
        int currentDetailsSize = 0;
        while (iter.hasNext()) {
            ++currentDetailsSize;
            iter.next();
        }
        if (currentDetailsSize > this.getMaxDetailInstances(detail.getClass())) {
            throw new ArrayIndexOutOfBoundsException("Max count for this detail is already reached");
        }
        this.infoRetreiver.getCachedContactDetails(this.uin).add(detail);
    }

    public boolean removeDetail(ServerStoredDetails.GenericDetail detail) {
        return this.infoRetreiver.getCachedContactDetails(this.uin).remove(detail);
    }

    public boolean replaceDetail(ServerStoredDetails.GenericDetail currentDetailValue, ServerStoredDetails.GenericDetail newDetailValue) throws ClassCastException {
        if (!newDetailValue.getClass().equals(currentDetailValue.getClass())) {
            throw new ClassCastException("New value to be replaced is not as the current one");
        }
        if (currentDetailValue.equals((Object)newDetailValue)) {
            return true;
        }
        boolean isFound = false;
        Iterator<ServerStoredDetails.GenericDetail> iter = this.infoRetreiver.getDetails(this.uin, currentDetailValue.getClass());
        while (iter.hasNext()) {
            ServerStoredDetails.GenericDetail item = iter.next();
            if (!item.equals((Object)currentDetailValue)) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            return false;
        }
        this.removeDetail(currentDetailValue);
        this.addDetail(newDetailValue);
        return true;
    }

    public void save() throws OperationFailedException {
        this.assertConnected();
        List<ServerStoredDetails.GenericDetail> details = this.infoRetreiver.getContactDetails(this.uin);
        VCardXEP0153 vCard = new VCardXEP0153();
        for (ServerStoredDetails.GenericDetail detail : details) {
            if (detail instanceof ServerStoredDetails.ImageDetail) {
                byte[] avatar = ((ServerStoredDetails.ImageDetail)detail).getBytes();
                if (avatar == null) {
                    vCard.setAvatar(new byte[0]);
                } else {
                    vCard.setAvatar(avatar);
                }
                this.fireServerStoredDetailsChangeEvent((ProtocolProviderService)this.jabberProvider, 1, null, detail);
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.FirstNameDetail.class)) {
                vCard.setFirstName((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.MiddleNameDetail.class)) {
                vCard.setMiddleName((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.LastNameDetail.class)) {
                vCard.setLastName((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.NicknameDetail.class)) {
                vCard.setNickName((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.URLDetail.class)) {
                if (detail.getDetailValue() == null) continue;
                vCard.setField("URL", ((URL)detail.getDetailValue()).toString());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.BirthDateDetail.class)) {
                if (detail.getDetailValue() == null) continue;
                Calendar c = ((ServerStoredDetails.BirthDateDetail)detail).getCalendar();
                SimpleDateFormat dateFormat = new SimpleDateFormat(JabberActivator.getResources().getI18NString("plugin.accountinfo.BDAY_FORMAT"));
                String strdate = dateFormat.format(c.getTime());
                vCard.setField("BDAY", strdate);
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.AddressDetail.class)) {
                vCard.setAddressFieldHome("STREET", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.CityDetail.class)) {
                vCard.setAddressFieldHome("LOCALITY", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.ProvinceDetail.class)) {
                vCard.setAddressFieldHome("REGION", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.PostalCodeDetail.class)) {
                vCard.setAddressFieldHome("PCODE", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.CountryDetail.class)) {
                vCard.setAddressFieldHome("CTRY", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.PhoneNumberDetail.class)) {
                vCard.setPhoneHome("VOICE", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.WorkPhoneDetail.class)) {
                vCard.setPhoneWork("VOICE", (String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.EmailAddressDetail.class)) {
                vCard.setEmailHome((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.WorkEmailAddressDetail.class)) {
                vCard.setEmailWork((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.WorkOrganizationNameDetail.class)) {
                vCard.setOrganization((String)detail.getDetailValue());
                continue;
            }
            if (detail.getClass().equals(ServerStoredDetails.JobTitleDetail.class)) {
                vCard.setField("TITLE", (String)detail.getDetailValue());
                continue;
            }
            if (!detail.getClass().equals(ServerStoredDetails.AboutMeDetail.class)) continue;
            vCard.setField("ABOUTME", (String)detail.getDetailValue());
        }
        try {
            vCard.save((Connection)this.jabberProvider.getConnection());
        }
        catch (XMPPException xmppe) {
            logger.error((Object)"Error loading/saving vcard: ", (Throwable)xmppe);
            throw new OperationFailedException("Error loading/saving vcard: ", 1, (Throwable)xmppe);
        }
    }

    public boolean isDetailClassEditable(Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        return this.isDetailClassSupported(detailClass);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.jabberProvider == null) {
            throw new IllegalStateException("The jabber provider must be non-null and signed on before being able to communicate.");
        }
        if (!this.jabberProvider.isRegistered()) {
            throw new IllegalStateException("The jabber provider must be signed on before being able to communicate.");
        }
    }

    static {
        supportedTypes.add(ServerStoredDetails.ImageDetail.class);
        supportedTypes.add(ServerStoredDetails.FirstNameDetail.class);
        supportedTypes.add(ServerStoredDetails.MiddleNameDetail.class);
        supportedTypes.add(ServerStoredDetails.LastNameDetail.class);
        supportedTypes.add(ServerStoredDetails.NicknameDetail.class);
        supportedTypes.add(ServerStoredDetails.AddressDetail.class);
        supportedTypes.add(ServerStoredDetails.CityDetail.class);
        supportedTypes.add(ServerStoredDetails.ProvinceDetail.class);
        supportedTypes.add(ServerStoredDetails.PostalCodeDetail.class);
        supportedTypes.add(ServerStoredDetails.CountryDetail.class);
        supportedTypes.add(ServerStoredDetails.EmailAddressDetail.class);
        supportedTypes.add(ServerStoredDetails.WorkEmailAddressDetail.class);
        supportedTypes.add(ServerStoredDetails.PhoneNumberDetail.class);
        supportedTypes.add(ServerStoredDetails.WorkPhoneDetail.class);
        supportedTypes.add(ServerStoredDetails.WorkOrganizationNameDetail.class);
        supportedTypes.add(ServerStoredDetails.URLDetail.class);
        supportedTypes.add(ServerStoredDetails.BirthDateDetail.class);
        supportedTypes.add(ServerStoredDetails.JobTitleDetail.class);
        supportedTypes.add(ServerStoredDetails.AboutMeDetail.class);
    }
}

