/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.SoftwareAttribute;

public class SoftwareAttributeTest
extends TestCase {
    private SoftwareAttribute softwareAttribute = null;
    MsgFixture msgFixture = null;
    String softwareValue = "turnserver.org";
    byte[] attributeBinValue = new byte[]{-128, 34, 0, (byte)this.softwareValue.length(), 116, 117, 114, 110, 115, 101, 114, 118, 101, 114, 46, 111, 114, 103, 0, 0};

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.softwareAttribute = new SoftwareAttribute();
        this.softwareAttribute.setSoftware(this.softwareValue.getBytes());
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.softwareAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0000';
        SoftwareAttribute decoded = new SoftwareAttribute();
        char length = (char)this.softwareValue.length();
        decoded.decodeAttributeBody(this.softwareValue.getBytes(), offset, length);
        SoftwareAttributeTest.assertEquals((String)"decode failed", (Object)this.softwareAttribute, (Object)decoded);
    }

    public void testEncode() {
        SoftwareAttributeTest.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.softwareAttribute.encode(), this.attributeBinValue));
    }

    public void testEquals() {
        SoftwareAttribute softwareAttribute2 = new SoftwareAttribute();
        softwareAttribute2.setSoftware(this.softwareValue.getBytes());
        SoftwareAttributeTest.assertEquals((String)"testequals failed", (Object)this.softwareAttribute, (Object)softwareAttribute2);
        softwareAttribute2 = new SoftwareAttribute();
        softwareAttribute2.setSoftware("some other software".getBytes());
        SoftwareAttributeTest.assertFalse((String)"testequals failed", (boolean)this.softwareAttribute.equals(softwareAttribute2));
        SoftwareAttributeTest.assertFalse((String)"testequals failed", (boolean)this.softwareAttribute.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.softwareValue.length();
        char actualReturn = this.softwareAttribute.getDataLength();
        SoftwareAttributeTest.assertEquals((String)"getDataLength - failed", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "SOFTWARE";
        String actualReturn = this.softwareAttribute.getName();
        SoftwareAttributeTest.assertEquals((String)"getting name failed", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetGetSoftware() {
        byte[] expectedReturn = this.softwareValue.getBytes();
        SoftwareAttribute att = new SoftwareAttribute();
        att.setSoftware(expectedReturn);
        byte[] actualReturn = att.getSoftware();
        SoftwareAttributeTest.assertTrue((String)"software setter or getter failed", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }
}

