/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Controls;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.util.RTPInfo;
import org.jitsi.impl.neomedia.control.AbstractControls;
import org.jitsi.impl.neomedia.control.AbstractFormatControl;
import org.jitsi.impl.neomedia.control.ControlsAdapter;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.util.Logger;

public abstract class AbstractBufferCaptureDevice<AbstractBufferStreamT extends AbstractBufferStream<?>>
implements CaptureDevice,
Controls {
    private static final Logger logger = Logger.getLogger(AbstractBufferCaptureDevice.class);
    private static final FormatControl[] EMPTY_FORMAT_CONTROLS = new FormatControl[0];
    private boolean connected = false;
    private final Object controlsSyncRoot = new Object();
    private FormatControl[] formatControls;
    private FrameRateControl[] frameRateControls;
    private final ReentrantLock lock = new ReentrantLock();
    private RTPInfo[] rtpInfos;
    private boolean started = false;
    private AbstractBufferStream<?>[] streams;
    private final Object streamSyncRoot = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        this.lock();
        try {
            if (!this.connected) {
                this.doConnect();
                this.connected = true;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected FormatControl createFormatControl(final int streamIndex) {
        return new AbstractFormatControl(){
            private Format format;

            @Override
            public Format getFormat() {
                this.format = AbstractBufferCaptureDevice.this.internalGetFormat(streamIndex, this.format);
                return this.format;
            }

            @Override
            public Format[] getSupportedFormats() {
                return AbstractBufferCaptureDevice.this.getSupportedFormats(streamIndex);
            }

            @Override
            public Format setFormat(Format format) {
                Format setFormat = super.setFormat(format);
                if (setFormat != null && (setFormat = AbstractBufferCaptureDevice.this.internalSetFormat(streamIndex, setFormat, format)) != null) {
                    this.format = setFormat;
                }
                return setFormat;
            }
        };
    }

    protected FormatControl[] createFormatControls() {
        FormatControl[] formatControlArray;
        FormatControl formatControl = this.createFormatControl(0);
        if (formatControl == null) {
            formatControlArray = EMPTY_FORMAT_CONTROLS;
        } else {
            FormatControl[] formatControlArray2 = new FormatControl[1];
            formatControlArray = formatControlArray2;
            formatControlArray2[0] = formatControl;
        }
        return formatControlArray;
    }

    protected FrameRateControl createFrameRateControl() {
        return null;
    }

    protected RTPInfo createRTPInfo() {
        return new RTPInfo(){

            @Override
            public String getCNAME() {
                return null;
            }
        };
    }

    protected abstract AbstractBufferStreamT createStream(int var1, FormatControl var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void defaultDoStart() throws IOException {
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            if (this.streams != null) {
                for (AbstractBufferStream<?> stream : this.streams) {
                    stream.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void defaultDoStop() throws IOException {
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            if (this.streams != null) {
                for (AbstractBufferStream<?> stream : this.streams) {
                    stream.stop();
                }
            }
        }
    }

    final Object[] defaultGetControls() {
        int rtpInfoCount;
        FormatControl[] formatControls = this.internalGetFormatControls();
        int formatControlCount = formatControls == null ? 0 : formatControls.length;
        FrameRateControl[] frameRateControls = this.internalGetFrameRateControls();
        int frameRateControlCount = frameRateControls == null ? 0 : frameRateControls.length;
        RTPInfo[] rtpInfos = this.internalGetRTPInfos();
        int n = rtpInfoCount = rtpInfos == null ? 0 : rtpInfos.length;
        if (formatControlCount == 0 && frameRateControlCount == 0 && rtpInfoCount == 0) {
            return ControlsAdapter.EMPTY_CONTROLS;
        }
        Object[] controls = new Object[formatControlCount + frameRateControlCount + rtpInfoCount];
        int offset = 0;
        if (formatControlCount != 0) {
            System.arraycopy(formatControls, 0, controls, offset, formatControlCount);
            offset += formatControlCount;
        }
        if (frameRateControlCount != 0) {
            System.arraycopy(frameRateControls, 0, controls, offset, frameRateControlCount);
            offset += frameRateControlCount;
        }
        if (rtpInfoCount != 0) {
            System.arraycopy(rtpInfos, 0, controls, offset, rtpInfoCount);
            offset += rtpInfoCount;
        }
        return controls;
    }

    final Format defaultGetFormat(int streamIndex, Format oldValue) {
        if (oldValue != null) {
            return oldValue;
        }
        Format[] supportedFormats = this.getSupportedFormats(streamIndex);
        return supportedFormats == null || supportedFormats.length < 1 ? null : supportedFormats[0];
    }

    final Format[] defaultGetSupportedFormats(int streamIndex) {
        CaptureDeviceInfo captureDeviceInfo = this.getCaptureDeviceInfo();
        return captureDeviceInfo == null ? null : captureDeviceInfo.getFormats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.lock();
        try {
            try {
                this.stop();
            }
            catch (IOException ioex) {
                logger.error("Failed to stop " + this.getClass().getSimpleName(), ioex);
            }
            if (this.connected) {
                this.doDisconnect();
                this.connected = false;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract void doConnect() throws IOException;

    protected abstract void doDisconnect();

    protected abstract void doStart() throws IOException;

    protected abstract void doStop() throws IOException;

    @Override
    public abstract CaptureDeviceInfo getCaptureDeviceInfo();

    public static CaptureDeviceInfo getCaptureDeviceInfo(DataSource captureDevice) {
        Vector captureDeviceInfos = CaptureDeviceManager.getDeviceList(null);
        MediaLocator locator = captureDevice.getLocator();
        for (CaptureDeviceInfo captureDeviceInfo : captureDeviceInfos) {
            if (!captureDeviceInfo.getLocator().toString().equals(locator.toString())) continue;
            return captureDeviceInfo;
        }
        return null;
    }

    @Override
    public Object getControl(String controlType) {
        return AbstractControls.getControl(this, controlType);
    }

    @Override
    public Object[] getControls() {
        return this.defaultGetControls();
    }

    protected abstract Format getFormat(int var1, Format var2);

    @Override
    public FormatControl[] getFormatControls() {
        return AbstractFormatControl.getFormatControls(this);
    }

    Object getStreamSyncRoot() {
        return this.streamSyncRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SourceStreamT extends SourceStream> SourceStreamT[] getStreams(Class<SourceStreamT> clz) {
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            return this.internalGetStreams(clz);
        }
    }

    protected abstract Format[] getSupportedFormats(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Format internalGetFormat(int streamIndex, Format oldValue) {
        block21: {
            boolean locked;
            Object object = this;
            synchronized (object) {
                locked = this.lock.tryLock();
            }
            try {
                if (!locked) break block21;
                object = this.getStreamSyncRoot();
                synchronized (object) {
                    block22: {
                        Format streamFormat;
                        AbstractBufferStream<?> stream;
                        if (this.streams == null || (stream = this.streams[streamIndex]) == null || (streamFormat = stream.internalGetFormat()) == null) break block22;
                        Format format = streamFormat;
                        return format;
                    }
                }
            }
            finally {
                if (locked) {
                    AbstractBufferCaptureDevice abstractBufferCaptureDevice = this;
                    synchronized (abstractBufferCaptureDevice) {
                        this.lock.unlock();
                    }
                }
            }
        }
        return this.getFormat(streamIndex, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormatControl[] internalGetFormatControls() {
        Object object = this.controlsSyncRoot;
        synchronized (object) {
            if (this.formatControls == null) {
                this.formatControls = this.createFormatControls();
            }
            return this.formatControls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameRateControl[] internalGetFrameRateControls() {
        Object object = this.controlsSyncRoot;
        synchronized (object) {
            if (this.frameRateControls == null) {
                FrameRateControl[] frameRateControlArray;
                FrameRateControl frameRateControl = this.createFrameRateControl();
                if (frameRateControl == null) {
                    frameRateControlArray = new FrameRateControl[]{};
                } else {
                    FrameRateControl[] frameRateControlArray2 = new FrameRateControl[1];
                    frameRateControlArray = frameRateControlArray2;
                    frameRateControlArray2[0] = frameRateControl;
                }
                this.frameRateControls = frameRateControlArray;
            }
            return this.frameRateControls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTPInfo[] internalGetRTPInfos() {
        Object object = this.controlsSyncRoot;
        synchronized (object) {
            if (this.rtpInfos == null) {
                RTPInfo[] rTPInfoArray;
                RTPInfo rtpInfo = this.createRTPInfo();
                if (rtpInfo == null) {
                    rTPInfoArray = new RTPInfo[]{};
                } else {
                    RTPInfo[] rTPInfoArray2 = new RTPInfo[1];
                    rTPInfoArray = rTPInfoArray2;
                    rTPInfoArray2[0] = rtpInfo;
                }
                this.rtpInfos = rTPInfoArray;
            }
            return this.rtpInfos;
        }
    }

    private <SourceStreamT extends SourceStream> SourceStreamT[] internalGetStreams(Class<SourceStreamT> clz) {
        FormatControl[] formatControls;
        if (this.streams == null && (formatControls = this.internalGetFormatControls()) != null) {
            int formatControlCount = formatControls.length;
            this.streams = new AbstractBufferStream[formatControlCount];
            for (int i = 0; i < formatControlCount; ++i) {
                this.streams[i] = this.createStream(i, formatControls[i]);
            }
            if (this.started) {
                for (AbstractBufferStream<?> stream : this.streams) {
                    try {
                        stream.start();
                    }
                    catch (IOException ioex) {
                        throw new UndeclaredThrowableException(ioex);
                    }
                }
            }
        }
        int streamCount = this.streams == null ? 0 : this.streams.length;
        SourceStream[] clone = (SourceStream[])Array.newInstance(clz, streamCount);
        if (streamCount != 0) {
            System.arraycopy(this.streams, 0, clone, 0, streamCount);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Format internalSetFormat(int streamIndex, Format oldValue, Format newValue) {
        this.lock();
        try {
            Object object = this.getStreamSyncRoot();
            synchronized (object) {
                block8: {
                    AbstractBufferStream<?> stream;
                    if (this.streams == null || (stream = this.streams[streamIndex]) == null) break block8;
                    Format format = stream.internalSetFormat(newValue);
                    return format;
                }
            }
        }
        finally {
            this.unlock();
        }
        return this.setFormat(streamIndex, oldValue, newValue);
    }

    private synchronized void lock() {
        this.lock.lock();
    }

    protected abstract Format setFormat(int var1, Format var2, Format var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.lock();
        try {
            if (!this.started) {
                if (!this.connected) {
                    throw new IOException(this.getClass().getName() + " not connected");
                }
                this.doStart();
                this.started = true;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.lock();
        try {
            if (this.started) {
                this.doStop();
                this.started = false;
            }
        }
        finally {
            this.unlock();
        }
    }

    AbstractBufferStream<?>[] streams() {
        return this.streams;
    }

    private synchronized void unlock() {
        this.lock.unlock();
    }
}

