/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

public class ALawDecoderUtil {
    private static short[] aLawToPcmMap = new short[256];

    public static void aLawDecode(boolean bigEndian, byte[] data, int offset, int length, byte[] decoded) {
        if (bigEndian) {
            ALawDecoderUtil.aLawDecodeBigEndian(data, offset, length, decoded);
        } else {
            ALawDecoderUtil.aLawDecodeLittleEndian(data, offset, length, decoded);
        }
    }

    public static short aLawDecode(byte alaw) {
        return aLawToPcmMap[alaw & 0xFF];
    }

    public static void aLawDecodeBigEndian(byte[] data, int offset, int length, byte[] decoded) {
        int size = length;
        for (int i = 0; i < size; ++i) {
            decoded[2 * i + 1] = (byte)(aLawToPcmMap[data[offset + i] & 0xFF] & 0xFF);
            decoded[2 * i] = (byte)(aLawToPcmMap[data[offset + i] & 0xFF] >> 8);
        }
    }

    public static void aLawDecodeLittleEndian(byte[] data, int offset, int length, byte[] decoded) {
        int size = length;
        for (int i = 0; i < size; ++i) {
            decoded[2 * i] = (byte)(aLawToPcmMap[data[offset + i] & 0xFF] & 0xFF);
            decoded[2 * i + 1] = (byte)(aLawToPcmMap[data[offset + i] & 0xFF] >> 8);
        }
    }

    private static short decode(byte alaw) {
        alaw = (byte)(alaw ^ 0xD5);
        int sign = alaw & 0x80;
        int exponent = (alaw & 0x70) >> 4;
        int data = alaw & 0xF;
        data <<= 4;
        data += 8;
        if (exponent != 0) {
            data += 256;
        }
        if (exponent > 1) {
            data <<= exponent - 1;
        }
        return (short)(sign == 0 ? data : -data);
    }

    static {
        for (int i = 0; i < aLawToPcmMap.length; ++i) {
            ALawDecoderUtil.aLawToPcmMap[i] = ALawDecoderUtil.decode((byte)i);
        }
    }
}

