/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCryptoContext;

public class SRTPTransformer
extends SinglePacketTransformer {
    SRTPContextFactory forwardFactory;
    SRTPContextFactory reverseFactory;
    private final Map<Integer, SRTPCryptoContext> contexts;

    public SRTPTransformer(SRTPContextFactory factory) {
        this(factory, factory);
    }

    public SRTPTransformer(SRTPContextFactory forwardFactory, SRTPContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new HashMap<Integer, SRTPCryptoContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextFactory(SRTPContextFactory factory, boolean forward) {
        Map<Integer, SRTPCryptoContext> map = this.contexts;
        synchronized (map) {
            if (forward) {
                if (this.forwardFactory != null && this.forwardFactory != factory) {
                    this.forwardFactory.close();
                }
                this.forwardFactory = factory;
            } else {
                if (this.reverseFactory != null && this.reverseFactory != factory) {
                    this.reverseFactory.close();
                }
                this.reverseFactory = factory;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, SRTPCryptoContext> map = this.contexts;
        synchronized (map) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            Iterator<SRTPCryptoContext> i = this.contexts.values().iterator();
            while (i.hasNext()) {
                SRTPCryptoContext context = i.next();
                i.remove();
                if (context == null) continue;
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRTPCryptoContext getContext(int ssrc, SRTPContextFactory engine, int deriveSrtpKeysIndex) {
        SRTPCryptoContext context;
        Map<Integer, SRTPCryptoContext> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(ssrc);
            if (context == null && (context = engine.getDefaultContext()) != null) {
                context = context.deriveContext(ssrc, 0, 0L);
                context.deriveSrtpKeys(deriveSrtpKeysIndex);
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if ((pkt.readByte(0) & 0xC0) != 128) {
            return null;
        }
        SRTPCryptoContext context = this.getContext(pkt.getSSRC(), this.reverseFactory, pkt.getSequenceNumber());
        return context != null && context.reverseTransformPacket(pkt) ? pkt : null;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        SRTPCryptoContext context = this.getContext(pkt.getSSRC(), this.forwardFactory, 0);
        return context.transformPacket(pkt) ? pkt : null;
    }
}

