/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.ice4j.socket.DelegatingDatagramSocket;
import org.ice4j.socket.StunDatagramPacketFilter;

public class DelegatingSocket
extends Socket {
    protected final Socket delegate;
    private final DelegatingSocket delegateAsDelegatingSocket;
    private final ByteBuffer frameLengthByteBuffer = ByteBuffer.allocate(2);
    private InputStream inputStream = null;
    private long lastLostPacketLogTime = 0L;
    private long lastRtpSequenceNumber = -1L;
    private long nbLostRtpPackets = 0L;
    private long nbReceivedRtpPackets = 0L;
    private long nbSentRtpPackets = 0L;
    private OutputStream outputStream = null;

    public static void receiveFromInputStream(DatagramPacket p, InputStream inputStream, InetAddress inetAddress, int port) throws IOException {
        int readLen;
        int len;
        int b0 = inputStream.read();
        int b1 = inputStream.read();
        if (b0 == -1 || b1 == -1) {
            p.setLength(0);
            throw new SocketException("read failed");
        }
        int frameLen = (b0 & 0xFF) << 8 | b1 & 0xFF;
        byte[] data = p.getData();
        int off = 0;
        for (readLen = 0; readLen < frameLen; readLen += len) {
            len = inputStream.read(data, off, frameLen - off);
            if (len == -1) {
                throw new SocketException("read failed");
            }
            off += len;
        }
        if (readLen != frameLen) {
            throw new SocketException("Failed to receive data from socket");
        }
        p.setAddress(inetAddress);
        p.setData(data, 0, frameLen);
        p.setPort(port);
    }

    public DelegatingSocket() {
        this((Socket)null);
    }

    public DelegatingSocket(InetAddress address, int port) throws IOException {
        this((Socket)null);
    }

    public DelegatingSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this((Socket)null);
    }

    public DelegatingSocket(Proxy proxy) {
        this((Socket)null);
    }

    public DelegatingSocket(Socket delegate) {
        this.delegate = delegate;
        this.delegateAsDelegatingSocket = delegate instanceof DelegatingSocket ? (DelegatingSocket)delegate : null;
    }

    protected DelegatingSocket(SocketImpl impl) throws SocketException {
        this((Socket)null);
    }

    public DelegatingSocket(String host, int port) throws UnknownHostException, IOException {
        this((Socket)null);
    }

    public DelegatingSocket(String host, int port, InetAddress localAddr, int localPort) {
        this((Socket)null);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.delegate == null) {
            super.bind(bindpoint);
        } else {
            this.delegate.bind(bindpoint);
        }
    }

    public void close() throws IOException {
        if (this.delegate == null) {
            super.close();
        } else {
            this.delegate.close();
        }
    }

    public void connect(SocketAddress endpoint) throws IOException {
        if (this.delegate == null) {
            super.connect(endpoint);
        } else {
            this.delegate.connect(endpoint);
        }
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.delegate == null) {
            super.connect(endpoint, timeout);
        } else {
            this.delegate.connect(endpoint, timeout);
        }
    }

    public SocketChannel getChannel() {
        return this.delegate == null ? super.getChannel() : this.delegate.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.delegate == null ? super.getInetAddress() : this.delegate.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate == null ? super.getInputStream() : this.delegate.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.delegate == null ? super.getKeepAlive() : this.delegate.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.delegate == null ? super.getLocalAddress() : this.delegate.getLocalAddress();
    }

    public int getLocalPort() {
        return this.delegate == null ? super.getLocalPort() : this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate == null ? super.getLocalSocketAddress() : this.delegate.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.delegate == null ? super.getOOBInline() : this.delegate.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate == null ? super.getOutputStream() : this.delegate.getOutputStream();
    }

    public int getPort() {
        return this.delegate == null ? super.getPort() : this.delegate.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate == null ? super.getReceiveBufferSize() : this.delegate.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.delegate == null ? super.getRemoteSocketAddress() : this.delegate.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate == null ? super.getReuseAddress() : this.delegate.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.delegate == null ? super.getSendBufferSize() : this.delegate.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.delegate == null ? super.getSoLinger() : this.delegate.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.delegate == null ? super.getSoTimeout() : this.delegate.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate == null ? super.getTcpNoDelay() : this.delegate.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.delegate == null ? super.getTrafficClass() : this.delegate.getTrafficClass();
    }

    public boolean isBound() {
        return this.delegate == null ? super.isBound() : this.delegate.isBound();
    }

    public boolean isClosed() {
        return this.delegate == null ? super.isClosed() : this.delegate.isClosed();
    }

    public boolean isConnected() {
        return this.delegate == null ? super.isConnected() : this.delegate.isConnected();
    }

    public boolean isInputShutdown() {
        return this.delegate == null ? super.isInputShutdown() : this.delegate.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.delegate == null ? super.isOutputShutdown() : this.delegate.isOutputShutdown();
    }

    public void receive(DatagramPacket p) throws IOException {
        if (this.delegateAsDelegatingSocket != null) {
            this.delegateAsDelegatingSocket.receive(p);
        } else {
            SocketChannel channel = this.getChannel();
            if (channel == null) {
                if (this.inputStream == null) {
                    this.inputStream = this.getInputStream();
                }
                DelegatingSocket.receiveFromInputStream(p, this.inputStream, this.getInetAddress(), this.getPort());
            } else {
                this.receiveFromChannel(channel, p);
            }
            if (!StunDatagramPacketFilter.isStunPacket(p)) {
                ++this.nbReceivedRtpPackets;
            }
            InetSocketAddress localAddress = (InetSocketAddress)super.getLocalSocketAddress();
            DelegatingDatagramSocket.logPacketToPcap(p, this.nbReceivedRtpPackets, false, localAddress.getAddress(), localAddress.getPort());
            this.updateRtpLosses(p);
        }
    }

    private synchronized void receiveFromChannel(SocketChannel channel, DatagramPacket p) throws IOException {
        while (this.frameLengthByteBuffer.hasRemaining()) {
            int read = channel.read(this.frameLengthByteBuffer);
            if (read != -1) continue;
            throw new SocketException("Failed to receive data from socket.");
        }
        this.frameLengthByteBuffer.flip();
        byte b0 = this.frameLengthByteBuffer.get();
        byte b1 = this.frameLengthByteBuffer.get();
        int frameLength = (b0 & 0xFF) << 8 | b1 & 0xFF;
        this.frameLengthByteBuffer.flip();
        byte[] data = p.getData();
        if (data == null || data.length < frameLength) {
            data = new byte[frameLength];
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, frameLength);
        while (byteBuffer.hasRemaining()) {
            int read = channel.read(byteBuffer);
            if (read != -1) continue;
            throw new SocketException("Failed to receive data from socket.");
        }
        p.setAddress(this.getInetAddress());
        p.setData(data, 0, frameLength);
        p.setPort(this.getPort());
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.delegateAsDelegatingSocket != null) {
            this.delegateAsDelegatingSocket.send(p);
        } else {
            if (this.outputStream == null) {
                this.outputStream = this.getOutputStream();
            }
            this.outputStream.write(p.getData(), p.getOffset(), p.getLength());
            ++this.nbSentRtpPackets;
            InetSocketAddress localAddress = (InetSocketAddress)super.getLocalSocketAddress();
            DelegatingDatagramSocket.logPacketToPcap(p, this.nbSentRtpPackets, true, localAddress.getAddress(), localAddress.getPort());
        }
    }

    public void sendUrgentData(int data) throws IOException {
        if (this.delegate == null) {
            super.sendUrgentData(data);
        } else {
            this.delegate.sendUrgentData(data);
        }
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setKeepAlive(on);
        } else {
            this.delegate.setKeepAlive(on);
        }
    }

    public void setOOBInline(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setOOBInline(on);
        } else {
            this.delegate.setOOBInline(on);
        }
    }

    public void setOriginalInputStream(InputStream inputStream) {
        if (this.inputStream == null && inputStream != null) {
            this.inputStream = inputStream;
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        if (this.delegate == null) {
            super.setPerformancePreferences(connectionTime, latency, bandwidth);
        } else {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setReceiveBufferSize(size);
        } else {
            this.delegate.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setReuseAddress(on);
        } else {
            this.delegate.setReuseAddress(on);
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.delegate == null) {
            super.setSendBufferSize(size);
        } else {
            this.delegate.setSendBufferSize(size);
        }
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.delegate == null) {
            super.setSoLinger(on, linger);
        } else {
            this.delegate.setSoLinger(on, linger);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.delegate == null) {
            super.setSoTimeout(timeout);
        } else {
            this.delegate.setSoTimeout(timeout);
        }
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.delegate == null) {
            super.setTcpNoDelay(on);
        } else {
            this.delegate.setTcpNoDelay(on);
        }
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate == null) {
            super.setTrafficClass(tc);
        } else {
            this.delegate.setTrafficClass(tc);
        }
    }

    public void shutdownInput() throws IOException {
        if (this.delegate == null) {
            super.shutdownInput();
        } else {
            this.delegate.shutdownInput();
        }
    }

    public void shutdownOutput() throws IOException {
        if (this.delegate == null) {
            super.shutdownOutput();
        } else {
            this.delegate.shutdownOutput();
        }
    }

    public String toString() {
        return this.delegate == null ? super.toString() : this.delegate.toString();
    }

    private void updateRtpLosses(DatagramPacket p) {
        if (!StunDatagramPacketFilter.isStunPacket(p)) {
            long newSeq = DelegatingDatagramSocket.getRtpSequenceNumber(p);
            if (this.lastRtpSequenceNumber != -1L) {
                this.nbLostRtpPackets += DelegatingDatagramSocket.getNbLost(this.lastRtpSequenceNumber, newSeq);
            }
            this.lastRtpSequenceNumber = newSeq;
            this.lastLostPacketLogTime = DelegatingDatagramSocket.logRtpLosses(this.nbLostRtpPackets, this.nbReceivedRtpPackets, this.lastLostPacketLogTime);
        }
    }
}

