/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.usersearch;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.extensions.usersearch.UserSearchIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.ReportedData;
import org.xmlpull.v1.XmlPullParser;

public class UserSearchProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        UserSearchIQ search = new UserSearchIQ();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && parser.getName().equals("item")) {
                search.setData(this.parseItems(parser));
                return search;
            }
            if (eventType == 2 && parser.getName().equals("instructions")) continue;
            if (eventType == 2 && !parser.getNamespace().equals("jabber:x:data")) {
                search.addField(parser.getName(), null);
                continue;
            }
            if (eventType == 2 && parser.getNamespace().equals("jabber:x:data")) {
                search.addExtension(PacketParserUtils.parsePacketExtension((String)parser.getName(), (String)parser.getNamespace(), (XmlPullParser)parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return search;
    }

    protected ReportedData parseItems(XmlPullParser parser) throws Exception {
        ReportedData data = new ReportedData();
        data.addColumn(new ReportedData.Column("JID", "jid", "jid-single"));
        boolean done = false;
        ArrayList<ReportedData.Field> fields = new ArrayList<ReportedData.Field>();
        while (!done) {
            int eventType;
            if (parser.getAttributeCount() > 0) {
                String jid = parser.getAttributeValue("", "jid");
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(jid);
                ReportedData.Field field = new ReportedData.Field("jid", valueList);
                fields.add(field);
            }
            if ((eventType = parser.next()) == 2 && parser.getName().equals("item")) {
                fields = new ArrayList();
                continue;
            }
            if (eventType == 3 && parser.getName().equals("item")) {
                ReportedData.Row row = new ReportedData.Row(fields);
                data.addRow(row);
                continue;
            }
            if (eventType == 2) {
                ReportedData.Column column;
                String name = parser.getName();
                String value = parser.nextText();
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                ReportedData.Field field = new ReportedData.Field(name, valueList);
                fields.add(field);
                boolean exists = false;
                Iterator cols = data.getColumns();
                while (cols.hasNext()) {
                    column = (ReportedData.Column)cols.next();
                    if (!column.getVariable().equals(name)) continue;
                    exists = true;
                }
                if (exists) continue;
                column = new ReportedData.Column(name, name, "text-single");
                data.addColumn(column);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return data;
    }
}

