/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Set;
import org.postgresql.PGNotification;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.v2.QueryExecutorImpl;
import org.postgresql.util.HostSpec;

class ProtocolConnectionImpl
implements ProtocolConnection {
    private String serverVersion;
    private int cancelPid;
    private int cancelKey;
    private boolean standardConformingStrings;
    private int transactionState;
    private SQLWarning warnings;
    private boolean closed = false;
    private final ArrayList notifications = new ArrayList();
    private final PGStream pgStream;
    private final String user;
    private final String database;
    private final QueryExecutorImpl executor;
    private final Logger logger;

    ProtocolConnectionImpl(PGStream pgStream, String user, String database, Logger logger) {
        this.pgStream = pgStream;
        this.user = user;
        this.database = database;
        this.logger = logger;
        this.executor = new QueryExecutorImpl(this, pgStream, logger);
    }

    @Override
    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public synchronized int getTransactionState() {
        return this.transactionState;
    }

    @Override
    public synchronized PGNotification[] getNotifications() throws SQLException {
        PGNotification[] array = this.notifications.toArray(new PGNotification[this.notifications.size()]);
        this.notifications.clear();
        return array;
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        SQLWarning chain = this.warnings;
        this.warnings = null;
        return chain;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueryCancel() throws SQLException {
        if (this.cancelPid <= 0) {
            return;
        }
        PGStream cancelStream = null;
        try {
            if (this.logger.logDebug()) {
                this.logger.debug(" FE=> CancelRequest(pid=" + this.cancelPid + ",ckey=" + this.cancelKey + ")");
            }
            cancelStream = new PGStream(this.pgStream.getHostSpec());
            cancelStream.SendInteger4(16);
            cancelStream.SendInteger2(1234);
            cancelStream.SendInteger2(5678);
            cancelStream.SendInteger4(this.cancelPid);
            cancelStream.SendInteger4(this.cancelKey);
            cancelStream.flush();
            cancelStream.ReceiveEOF();
            cancelStream.close();
            cancelStream = null;
        }
        catch (IOException e) {
            if (this.logger.logDebug()) {
                this.logger.debug("Ignoring exception on cancel request:", e);
            }
        }
        finally {
            if (cancelStream != null) {
                try {
                    cancelStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void close() {
        block4: {
            if (this.closed) {
                return;
            }
            try {
                if (this.logger.logDebug()) {
                    this.logger.debug(" FE=> Terminate");
                }
                this.pgStream.SendChar(88);
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException ioe) {
                if (!this.logger.logDebug()) break block4;
                this.logger.debug("Discarding IOException on close:", ioe);
            }
        }
        this.closed = true;
    }

    @Override
    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    void setEncoding(Encoding encoding) throws IOException {
        this.pgStream.setEncoding(encoding);
    }

    void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    void setBackendKeyData(int cancelPid, int cancelKey) {
        this.cancelPid = cancelPid;
        this.cancelKey = cancelKey;
    }

    synchronized void setStandardConformingStrings(boolean value) {
        this.standardConformingStrings = value;
    }

    synchronized void addWarning(SQLWarning newWarning) {
        if (this.warnings == null) {
            this.warnings = newWarning;
        } else {
            this.warnings.setNextWarning(newWarning);
        }
    }

    synchronized void addNotification(PGNotification notification) {
        this.notifications.add(notification);
    }

    synchronized void setTransactionState(int state) {
        this.transactionState = state;
    }

    @Override
    public int getProtocolVersion() {
        return 2;
    }

    @Override
    public void setBinaryReceiveOids(Set<Integer> ignored) {
    }

    @Override
    public boolean getIntegerDateTimes() {
        return false;
    }

    @Override
    public int getBackendPID() {
        return this.cancelPid;
    }
}

