/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop;

import java.io.File;
import java.net.URL;
import org.jdesktop.jdic.desktop.DesktopException;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.jdic.desktop.internal.BrowserService;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.LaunchService;
import org.jdesktop.jdic.desktop.internal.MailerService;
import org.jdesktop.jdic.desktop.internal.ServiceManager;

public class Desktop {
    private Desktop() {
    }

    private static void checkFileValid(File file) throws DesktopException {
        if (file == null || !file.exists()) {
            throw new DesktopException("The given file doesn't exist.");
        }
        if (!file.canRead()) {
            throw new DesktopException("The given file couldn't be read.");
        }
    }

    public static void open(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File file2 = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(file2);
        try {
            launchService.open(file2);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    public static boolean isPrintable(File file) {
        if (file == null) {
            return false;
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File file2 = launchService.resolveLinkFile(file);
        try {
            Desktop.checkFileValid(file2);
        }
        catch (DesktopException desktopException) {
            return false;
        }
        return launchService.isPrintable(file2);
    }

    public static void print(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File file2 = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(file2);
        if (!Desktop.isPrintable(file2)) {
            throw new DesktopException("The given file is not printable.");
        }
        try {
            launchService.print(file2);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    public static boolean isEditable(File file) {
        if (file == null) {
            return false;
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File file2 = launchService.resolveLinkFile(file);
        try {
            Desktop.checkFileValid(file2);
        }
        catch (DesktopException desktopException) {
            return false;
        }
        return launchService.isEditable(file2);
    }

    public static void edit(File file) throws DesktopException {
        if (file == null) {
            throw new DesktopException("The given file is null.");
        }
        LaunchService launchService = (LaunchService)ServiceManager.getService("LaunchService");
        File file2 = launchService.resolveLinkFile(file);
        Desktop.checkFileValid(file2);
        if (!Desktop.isEditable(file2)) {
            throw new DesktopException("The given file is not editable.");
        }
        try {
            launchService.edit(file2);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    public static void browse(URL uRL) throws DesktopException {
        if (uRL == null) {
            throw new DesktopException("The given URL is null.");
        }
        BrowserService browserService = (BrowserService)ServiceManager.getService("BrowserService");
        try {
            browserService.show(uRL);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    private static void browse(URL uRL, String string) throws DesktopException {
        if (uRL == null) {
            throw new DesktopException("The given URL is null.");
        }
        if (string == null) {
            throw new DesktopException("The given target is null.");
        }
        BrowserService browserService = (BrowserService)ServiceManager.getService("BrowserService");
        try {
            browserService.show(uRL, string);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    public static void mail() throws DesktopException {
        MailerService mailerService = (MailerService)ServiceManager.getService("MailerService");
        try {
            mailerService.open();
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }

    public static void mail(Message message) throws DesktopException {
        if (message == null) {
            throw new DesktopException("The given message is null.");
        }
        MailerService mailerService = (MailerService)ServiceManager.getService("MailerService");
        try {
            mailerService.open(message);
        }
        catch (LaunchFailedException launchFailedException) {
            throw new DesktopException(launchFailedException.getMessage());
        }
    }
}

