/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;

public class FlapErrorCmd
extends FlapCommand {
    public static final int CHANNEL_ERROR = 3;
    private final int code;

    protected FlapErrorCmd(FlapPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock flapData = packet.getData();
        this.code = BinaryTools.getUShort((ByteBlock)flapData, (int)0);
    }

    public FlapErrorCmd(int code) {
        super(3);
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        this.code = code;
    }

    public final int getErrorCode() {
        return this.code;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.code);
    }

    public String toString() {
        return "FlapErrorCmd: code=0x" + Integer.toHexString(this.code);
    }
}

