/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LineContainsRegExp
extends BaseParamFilterReader
implements ChainableReader {
    private static final String REGEXP_KEY = "regexp";
    private Vector regexps;
    private String line;

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.line != null) {
            n = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            int n2 = this.regexps.size();
            while (this.line != null) {
                int n3 = 0;
                while (n3 < n2) {
                    RegularExpression regularExpression = (RegularExpression)this.regexps.elementAt(n3);
                    Regexp regexp = regularExpression.getRegexp(this.getProject());
                    boolean bl = regexp.matches(this.line);
                    if (!bl) {
                        this.line = null;
                        break;
                    }
                    ++n3;
                }
                if (this.line != null) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return n;
    }

    public final void addConfiguredRegexp(RegularExpression regularExpression) {
        this.regexps.addElement(regularExpression);
    }

    private final void setRegexps(Vector vector) {
        this.regexps = vector;
    }

    private final Vector getRegexps() {
        return this.regexps;
    }

    public final Reader chain(Reader reader) {
        LineContainsRegExp lineContainsRegExp = new LineContainsRegExp(reader);
        lineContainsRegExp.setRegexps(this.getRegexps());
        lineContainsRegExp.setInitialized(true);
        return lineContainsRegExp;
    }

    private final void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (REGEXP_KEY.equals(parameterArray[n].getType())) {
                    String string = parameterArray[n].getValue();
                    RegularExpression regularExpression = new RegularExpression();
                    regularExpression.setPattern(string);
                    this.regexps.addElement(regularExpression);
                }
                ++n;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.regexps = new Vector();
        this.line = null;
    }

    public LineContainsRegExp() {
        this.this();
    }

    public LineContainsRegExp(Reader reader) {
        super(reader);
        this.this();
    }
}

