/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.iobalancer;

import com.hazelcast.nio.tcp.MigratableHandler;
import com.hazelcast.nio.tcp.iobalancer.LoadImbalance;
import com.hazelcast.nio.tcp.iobalancer.MigrationStrategy;
import java.util.Set;

class EventCountBasicMigrationStrategy
implements MigrationStrategy {
    private static final double MIN_MAX_RATIO_MIGRATION_THRESHOLD = 0.8;
    private static final double MAXIMUM_NO_OF_EVENTS_AFTER_MIGRATION_COEFFICIENT = 0.9;

    EventCountBasicMigrationStrategy() {
    }

    @Override
    public boolean imbalanceDetected(LoadImbalance imbalance) {
        long min = imbalance.minimumEvents;
        long max = imbalance.maximumEvents;
        if (min == Long.MIN_VALUE || max == Long.MAX_VALUE) {
            return false;
        }
        long lowerBound = (long)(0.8 * (double)max);
        return min < lowerBound;
    }

    @Override
    public MigratableHandler findHandlerToMigrate(LoadImbalance imbalance) {
        Set<MigratableHandler> candidates = imbalance.getHandlersOwnerBy(imbalance.sourceSelector);
        long migrationThreshold = (long)((double)(imbalance.maximumEvents - imbalance.minimumEvents) * 0.9);
        MigratableHandler candidate = null;
        long eventCountInSelectedHandler = 0L;
        for (MigratableHandler handler : candidates) {
            long eventCount = imbalance.getEventCount(handler);
            if (eventCount <= eventCountInSelectedHandler || eventCount >= migrationThreshold) continue;
            eventCountInSelectedHandler = eventCount;
            candidate = handler;
        }
        return candidate;
    }
}

