/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissedMessagesCmd
extends IcbmCommand {
    private final List<MissedMsgInfo> missedMsgInfos;

    protected MissedMessagesCmd(SnacPacket packet) {
        super(10);
        MissedMsgInfo info;
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock block = packet.getData();
        ArrayList<MissedMsgInfo> messages = new ArrayList<MissedMsgInfo>();
        while ((info = MissedMsgInfo.readMissedMsgInfo(block)) != null) {
            messages.add(info);
            block = block.subBlock(info.getTotalSize());
        }
        this.missedMsgInfos = DefensiveTools.getUnmodifiable(messages);
    }

    public MissedMessagesCmd(Collection<MissedMsgInfo> missedMsgInfos) {
        super(10);
        this.missedMsgInfos = DefensiveTools.getSafeNonnullListCopy(missedMsgInfos, (String)"missedMsgInfos");
    }

    public final List<MissedMsgInfo> getMissedMsgInfos() {
        return this.missedMsgInfos;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        if (this.missedMsgInfos != null) {
            for (MissedMsgInfo missedMsgInfo : this.missedMsgInfos) {
                missedMsgInfo.write(out);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MissedMessagesCmd: ");
        if (this.missedMsgInfos != null) {
            buffer.append(this.missedMsgInfos.size());
            buffer.append(" missed: ");
            boolean first = true;
            for (MissedMsgInfo missedMsgInfo : this.missedMsgInfos) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(missedMsgInfo);
            }
        }
        return buffer.toString();
    }
}

