/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.concurrent.lock.GetRemainingLeaseTimeOperation;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockPortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public final class GetRemainingLeaseRequest
extends KeyBasedClientRequest
implements Portable {
    private Data key;

    public GetRemainingLeaseRequest() {
    }

    public GetRemainingLeaseRequest(Data key) {
        this.key = key;
    }

    @Override
    protected final Operation prepareOperation() {
        String name = (String)this.getClientEngine().toObject(this.key);
        return new GetRemainingLeaseTimeOperation(new InternalLockNamespace(name), this.key);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public int getFactoryId() {
        return LockPortableHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }

    public Permission getRequiredPermission() {
        String name = (String)this.getClientEngine().toObject(this.key);
        return new LockPermission(name, "read");
    }
}

