/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.exceptions.AssertionException;
import com.voxeo.exceptions.InputException;
import com.voxeo.exceptions.VException;
import com.voxeo.utils.Exceptions;
import com.voxeo.utils.Identifiable;
import com.voxeo.utils.Maps;
import com.voxeo.utils.Pair;
import com.voxeo.utils.SortInfo;
import com.voxeo.utils.Strings;
import com.voxeo.utils.Transformer;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objects {
    private static final Map<Class<?>, Class<?>> primitiveClassMap = new HashMap();

    public static final <T> T isNull(T t, T def) {
        return t != null ? t : def;
    }

    public static boolean anyNull(Object ... args) {
        for (Object o : args) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public static boolean allNotNull(Object ... args) {
        return !Objects.anyNull(args);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean equal(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null && rhs != null) {
            return false;
        }
        if (lhs != null && rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static boolean equalIgnoreCase(String lhs, String rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null && rhs != null) {
            return false;
        }
        if (lhs != null && rhs == null) {
            return false;
        }
        return lhs.equalsIgnoreCase(rhs);
    }

    public static <T extends Comparable> T min(T ... items) {
        Object min = null;
        for (T item : items) {
            if (min != null && item.compareTo(min) >= 0) continue;
            min = item;
        }
        return min;
    }

    public static <T extends Comparable> T max(T ... items) {
        Object max = null;
        for (T item : items) {
            if (max != null && item.compareTo(max) <= 0) continue;
            max = item;
        }
        return max;
    }

    public static <T> T getPropertyValue(Object obj, String propertyPath) {
        String[] path = propertyPath.split("\\.");
        if (path.length > 1) {
            T value = Objects.getPropertyValue(obj, path[0]);
            return Objects.getPropertyValue(value, propertyPath.substring(propertyPath.indexOf(46) + 1));
        }
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(obj.getClass(), (String)propertyPath);
        if (descriptor != null) {
            try {
                Method readMethod = descriptor.getReadMethod();
                return (T)readMethod.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("No property found for name " + propertyPath);
    }

    public static void setPropertyValue(Object obj, String propertyName, Object value) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(obj.getClass(), (String)propertyName);
        if (descriptor != null) {
            try {
                Method writeMethod = descriptor.getWriteMethod();
                Objects.assertion(writeMethod != null, "no write method for property %s", propertyName);
                writeMethod.invoke(obj, value);
            }
            catch (InvocationTargetException e) {
                Exception e2 = (Exception)e.getCause();
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)e2;
                }
                throw new RuntimeException(e2);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("No property found for name " + propertyName);
        }
    }

    public static <T> T fromString(Class<T> desiredType, String string) {
        Object result;
        if (string == null) {
            return null;
        }
        Constructor<T> ctor = Objects.getStringConstructor(desiredType);
        if (ctor != null) {
            result = BeanUtils.instantiateClass(ctor, (Object[])new Object[]{string});
        } else {
            Method valueOfMethod = null;
            for (Method method : desiredType.getMethods()) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(String.class)) continue;
                valueOfMethod = method;
                break;
            }
            if (valueOfMethod != null) {
                try {
                    result = valueOfMethod.invoke(desiredType, string);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new VException(e);
                }
            } else {
                throw new InputException("Cannot convert %s to %s", string, desiredType);
            }
        }
        return (T)result;
    }

    public static <T> Constructor<T> getStringConstructor(Class<T> clazz) {
        Constructor<?> result = null;
        for (Constructor<?> ctor : clazz.getConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != 1 || !types[0].equals(String.class)) continue;
            result = ctor;
            break;
        }
        return result;
    }

    public static boolean hasProperty(Object obj, String propertyName) {
        return null != BeanUtils.getPropertyDescriptor(obj.getClass(), (String)propertyName);
    }

    public static boolean hasWritableProperty(Object obj, String propertyName) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(obj.getClass(), (String)propertyName);
        return null != descriptor && descriptor.getWriteMethod() != null;
    }

    public static Class<?> getPropertyType(Object object, String name) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)name);
        Objects.assertion(descriptor != null, "no property of name %s", name);
        return descriptor.getPropertyType();
    }

    public static <T> List<T> singletonList(T item) {
        ArrayList<T> r = new ArrayList<T>(1);
        r.add(item);
        return r;
    }

    @Deprecated
    public static <T> Set<T> singletonSet(T item) {
        HashSet<T> r = new HashSet<T>(1);
        r.add(item);
        return r;
    }

    public static <T> T[] copy(T[] orig) {
        if (orig != null) {
            Object[] r = (Object[])Array.newInstance(orig.getClass().getComponentType(), orig.length);
            System.arraycopy(orig, 0, r, 0, orig.length);
            return r;
        }
        return null;
    }

    public static <T> T invoke(Object target, String methodName, Object ... args) {
        Class<?> clazz = target.getClass();
        if (args == null) {
            args = new Object[]{};
        }
        Class[] paramClasses = new Class[args.length];
        int i = 0;
        for (Object param : args) {
            paramClasses[i++] = param.getClass();
        }
        try {
            Method method = Objects.findMethod(clazz, methodName, paramClasses);
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (T)method.invoke(target, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            throw new NoSuchMethodException(methodName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramClasses) {
        return Objects.doFindMethod(clazz, methodName, 0, paramClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method doFindMethod(Class<?> clazz, String methodName, int paramIndex, Class<?>[] paramClasses) {
        Class<?> paramClazz;
        Class<?> primitiveClazz;
        if (paramIndex == paramClasses.length) {
            try {
                return clazz.getMethod(methodName, paramClasses);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Method result = Objects.doFindMethod(clazz, methodName, paramIndex + 1, paramClasses);
        if (result == null && (primitiveClazz = primitiveClassMap.get(paramClazz = paramClasses[paramIndex])) != null) {
            try {
                paramClasses[paramIndex] = primitiveClazz;
                result = Objects.doFindMethod(clazz, methodName, paramIndex, paramClasses);
            }
            finally {
                paramClasses[paramIndex] = paramClazz;
            }
        }
        return result;
    }

    public static <T> T extractSingleElement(Collection<T> collection) {
        return collection.size() > 0 ? (T)collection.iterator().next() : null;
    }

    public static <T, V extends T> int indexOf(T[] array, V value) {
        int r = -1;
        int idx = 0;
        for (T element : array) {
            if (Objects.equal(element, value)) {
                r = idx;
                break;
            }
            ++idx;
        }
        return r;
    }

    public static <T> Collection<T> findAll(Collection<T> collection, String propertyName, Object propertyValue) {
        ArrayList<T> results = new ArrayList<T>(collection.size());
        for (T item : collection) {
            T value = Objects.getPropertyValue(item, propertyName);
            if (value == null || !value.equals(propertyValue)) continue;
            results.add(item);
        }
        return results;
    }

    public static <T> T findByProperty(Collection<T> collection, String propertyName, Object propertyValue) {
        for (T item : collection) {
            T value = Objects.getPropertyValue(item, propertyName);
            if (value == null || !value.equals(propertyValue)) continue;
            return item;
        }
        return null;
    }

    public static <T> int indexOf(T[] array, String propertyName, Object propertyValue) {
        for (int i = 0; i < array.length; ++i) {
            T item = array[i];
            T value = Objects.getPropertyValue(item, propertyName);
            if (value == null || !value.equals(propertyValue)) continue;
            return i;
        }
        return -1;
    }

    public static <T extends Identifiable<I>, I> T findById(I id, Collection<? extends T> collection) {
        for (Identifiable object : collection) {
            Object objectId = object.getId();
            if (!Objects.equal(objectId, id)) continue;
            return (T)object;
        }
        return null;
    }

    public static <T extends Identifiable<I>, I> boolean removeById(I id, Collection<? extends T> collection) {
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            Identifiable object = (Identifiable)it.next();
            if (!object.getId().equals(id)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static <T> T extractFirst(Collection<T> collection) {
        return Objects.extractFirst(collection.iterator());
    }

    public static <T> T extractFirst(Enumeration<T> enumeration) {
        if (enumeration.hasMoreElements()) {
            return enumeration.nextElement();
        }
        return null;
    }

    public static <T> T extractFirst(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <K, T extends Collection<K>> T drain(Iterator<K> iterator, T collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <K> List<K> drain(Iterator<K> iterator) {
        LinkedList<K> r = new LinkedList<K>();
        while (iterator.hasNext()) {
            r.add(iterator.next());
        }
        return r;
    }

    public static <T> T clone(T object) {
        return Objects.invoke(object, "clone", new Object[0]);
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static Map<String, String> toMap(String[][] params) {
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (int i = 0; i < params.length; ++i) {
            map.put(params[i][0], params[i][1]);
        }
        return map;
    }

    public static int max(int[] a) {
        int max = Integer.MIN_VALUE;
        for (int x : a) {
            max = Math.max(x, max);
        }
        return max;
    }

    public static void applyProperties(Map<String, String> properties, Object target) {
        Objects.applyProperties(properties, target, true);
    }

    public static void applyProperties(Map<String, String> properties, Object target, boolean ignoreInvalidPropertyNames) {
        for (String key : properties.keySet()) {
            if (Objects.hasProperty(target, key)) {
                Objects.setPropertyValue(target, key, properties.get(key));
                continue;
            }
            if (ignoreInvalidPropertyNames) continue;
            throw new IllegalArgumentException("Bad property name: " + key);
        }
    }

    public static <T> T narrow(Class<T> clazz, Object obj) {
        if (obj == null || clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        throw Exceptions.make(IllegalArgumentException.class, "Can't cast instance of %s to %s", obj.getClass(), clazz);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static <T> T make(Class<T> type, String className, Object ... args) throws ClassNotFoundException, SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return Objects.make(type.getName(), args);
    }

    public static <T> T make(String className, Object ... args) throws ClassNotFoundException, SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        return (T)Objects.make(clazz, args);
    }

    public static <T> T make(Class<T> clazz, Object ... args) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> ctor = null;
        for (Constructor<?> tempCtor : clazz.getConstructors()) {
            Class<?>[] paramTypes = tempCtor.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            boolean accept = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isAssignableFrom(args[i].getClass())) continue;
                accept = false;
                break;
            }
            if (!accept) continue;
            ctor = tempCtor;
            break;
        }
        if (ctor != null) {
            if (args.length > 0) {
                return ctor.newInstance(args);
            }
            return ctor.newInstance(new Object[0]);
        }
        throw new IllegalArgumentException("No constructor found for arguments passed in for class " + clazz);
    }

    @Deprecated
    public static <T extends Map<?, ?>> T makeMap(String ... args) {
        Object result = Maps.make(args);
        return result;
    }

    @Deprecated
    public static <T extends Map<?, ?>> T makeMap(Object ... args) {
        Object result = Maps.make(args);
        return result;
    }

    @Deprecated
    public static <T extends Map<?, ?>, K extends Enum<K>> T makeEnumMap(Class<K> keyClazz) {
        Object result = Maps.makeEnumMap(keyClazz);
        return result;
    }

    @Deprecated
    public static <T extends Map<?, ?>, K extends Enum<K>> T makeEnumMap(K firstKey, Object ... args) {
        Object result = Maps.makeEnumMap(firstKey, args);
        return result;
    }

    @Deprecated
    public static <K, V, MapType extends Map<? super K, ? super V>> MapType makeMap(K key, V value) {
        Object result = Maps.make(key, value);
        return result;
    }

    public static <T extends Comparable<T>> boolean betweenInclusive(T number, T min, T max) {
        int minResult = number.compareTo(min);
        int maxResult = number.compareTo(max);
        return minResult >= 0 && maxResult <= 0;
    }

    public static <T extends Comparable<T>> boolean betweenExclusive(T number, T min, T max) {
        int minResult = number.compareTo(min);
        int maxResult = number.compareTo(max);
        return minResult > 0 && maxResult < 0;
    }

    public static <F, T> List<T> transform(Collection<? extends F> from, Transformer<F, T> transformer) {
        ArrayList<T> list = new ArrayList<T>(from.size());
        for (F item : from) {
            list.add(transformer.transform(item));
        }
        return list;
    }

    public static <T> void fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    public static <K, V> K getFirstKeyForValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <K, V> Map<K, V> populateMap(Collection<? extends V> objects, String keyName, Map<K, V> map) {
        for (V value : objects) {
            Object key = Objects.getPropertyValue(value, keyName);
            map.put(key, value);
        }
        return map;
    }

    public static <T extends Comparable> int nullSafeCompare(T lhs, T rhs) {
        if (lhs == null) {
            if (rhs == null) {
                return 0;
            }
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (lhs instanceof String) {
            return ((String)((Object)lhs)).compareToIgnoreCase((String)((Object)rhs));
        }
        return lhs.compareTo(rhs);
    }

    public static <T extends Comparable> int nullSafeCompare(T lhs, T rhs, boolean ignoreCase) {
        if (lhs == null) {
            if (rhs == null) {
                return 0;
            }
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (lhs instanceof String) {
            return ((String)((Object)lhs)).compareToIgnoreCase((String)((Object)rhs));
        }
        return lhs.compareTo(rhs);
    }

    public static <T> void sortByProperties(List<T> list, String ... propertyNames) {
        Objects.sortByProperties(list, true, false, propertyNames);
    }

    public static <T> void sortByProperties(List<T> list, boolean ignoreCase, boolean descending, String ... propertyNames) {
        SortInfo[] infos = new SortInfo[propertyNames.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new SortInfo(propertyNames[i], ignoreCase, descending);
        }
        Objects.sortByProperties(list, infos);
    }

    public static <T> void sortByProperties(List<T> list, final SortInfo[] infos) {
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T lhs, T rhs) {
                for (SortInfo info : infos) {
                    Comparable rhsProperty;
                    String propertyName = info.propertyName;
                    Comparable lhsProperty = (Comparable)Objects.getPropertyValue(lhs, propertyName);
                    int comp = Objects.nullSafeCompare(lhsProperty, rhsProperty = (Comparable)Objects.getPropertyValue(rhs, propertyName), info.ignoreCase);
                    if (comp == 0) continue;
                    return (info.descending ? -1 : 1) * comp;
                }
                return 0;
            }
        });
    }

    public static <A extends Annotation> A findAnnotation(Class<A> annotationClazz, Class<?> targetClazz) {
        Class<?> clazz = targetClazz;
        while (!clazz.equals(Object.class)) {
            A annotation = clazz.getAnnotation(annotationClazz);
            if (annotation != null) {
                return annotation;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String name) {
        for (Class<?> target = clazz; target != null; target = target.getSuperclass()) {
            try {
                return target.getDeclaredField(name);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static List<Method> findMethodsMarkedWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(annotationClazz) == null) continue;
                list.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static <T> T first(Collection<T> items) {
        if (items != null && !items.isEmpty()) {
            return items.iterator().next();
        }
        return null;
    }

    public static <T> T proxy(Class<T> targetClazz, InvocationHandler handler) {
        return (T)Objects.proxy(new Class[]{targetClazz}, handler);
    }

    public static <T> T proxy(String className, InvocationHandler handler) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(className, true, classLoader);
            return (T)Objects.proxy(clazz, handler);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T proxy(Set<String> classNames, InvocationHandler handler) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class[] classes = new Class[classNames.size()];
            int i = 0;
            for (String className : classNames) {
                classes[i] = Class.forName(className, true, classLoader);
                ++i;
            }
            return (T)Objects.proxy(classes, handler);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object proxy(Class<?>[] targetClazzes, InvocationHandler handler) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), targetClazzes, handler);
    }

    public static <T> Enumeration<T> enumerate(final Iterable<T> iterable) {
        return new Enumeration<T>(){
            Iterator<T> iterator;
            {
                this.iterator = iterable.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return this.iterator.next();
            }
        };
    }

    public static <T extends Cloneable> T clone(T obj) {
        try {
            Cloneable result = (Cloneable)Objects.invoke(obj, "clone", new Object[0]);
            return (T)result;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static void assertion(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new AssertionException(Strings.isEmpty(msg) ? null : String.format(msg, args));
        }
    }

    public static void assertion(boolean condition) {
        Objects.assertion(condition, null, new Object[0]);
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedList interfaces = new LinkedList();
        while (!clazz.equals(Object.class)) {
            for (Class<?> iface : clazz.getInterfaces()) {
                interfaces.add(iface);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }

    public static <T, F> T[] transform(F[] froms, T[] to, Transformer<? super F, ? extends T> transformer) {
        int idx = 0;
        for (F from : froms) {
            to[idx++] = transformer.transform(from);
        }
        return to;
    }

    public static <T, F> T[] transform(Iterable<F> froms, T[] to, Transformer<? super F, ? extends T> transformer) {
        int idx = 0;
        for (F from : froms) {
            to[idx++] = transformer.transform(from);
        }
        return to;
    }

    public static <T, F, C extends Collection<? super T>> C transform(Iterable<F> froms, C to, Transformer<? super F, ? extends T> transformer) {
        for (F from : froms) {
            to.add(transformer.transform(from));
        }
        return to;
    }

    public static <X, Y> Pair<X, Y> pair(X x, Y y) {
        return new Pair<X, Y>(x, y);
    }

    public static <T> T as(Object object, Class<T> clazz) {
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        }
        return (T)result;
    }

    static {
        primitiveClassMap.put(Integer.class, Integer.TYPE);
        primitiveClassMap.put(Long.class, Integer.TYPE);
        primitiveClassMap.put(Short.class, Integer.TYPE);
        primitiveClassMap.put(Boolean.class, Boolean.TYPE);
        primitiveClassMap.put(Float.class, Float.TYPE);
        primitiveClassMap.put(Double.class, Double.TYPE);
        primitiveClassMap.put(Byte.class, Byte.TYPE);
        primitiveClassMap.put(Character.class, Character.TYPE);
    }
}

