/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;

public class IOHandler {
    private static StackLogger logger = CommonLogger.getLogger(IOHandler.class);
    private SipStackImpl sipStack;
    private static final String TCP = "tcp";
    private static final String TLS = "tls";
    private final ConcurrentHashMap<String, Socket> socketTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Semaphore> socketCreationMap = new ConcurrentHashMap();

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected static String makeKey(String addr, int port) {
        return addr + ":" + port;
    }

    protected IOHandler(SIPTransactionStack sipStack) {
        this.sipStack = (SipStackImpl)sipStack;
    }

    protected void putSocket(String key, Socket sock) {
        this.socketTable.put(key, sock);
    }

    protected Socket getSocket(String key) {
        return this.socketTable.get(key);
    }

    protected void removeSocket(String key) {
        this.socketTable.remove(key);
        this.socketCreationMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] bytes, int length) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int chunksize = 8192;
            for (int p = 0; p < length; p += chunksize) {
                int chunk = p + chunksize < length ? chunksize : length - p;
                outputStream.write(bytes, p, chunk);
            }
        }
        outputStream.flush();
    }

    public SocketAddress getLocalAddressForTcpDst(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        String key = IOHandler.makeKey(dst, dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSocket(dst, dstPort, localAddress, localPort);
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    public SocketAddress getLocalAddressForTlsDst(InetAddress dst, int dstPort, InetAddress localAddress, TLSMessageChannel channel) throws IOException {
        String key = IOHandler.makeKey(dst, dstPort);
        Socket clientSock = this.getSocket(key);
        if (clientSock == null) {
            clientSock = this.sipStack.getNetworkLayer().createSSLSocket(dst, dstPort, localAddress);
            SSLSocket sslsock = (SSLSocket)clientSock;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("inaddr = " + dst);
                logger.logDebug("port = " + dstPort);
            }
            HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl(channel);
            channel.setHandshakeCompletedListener(listner);
            sslsock.addHandshakeCompletedListener(listner);
            sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
            sslsock.startHandshake();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Handshake passed");
            }
            try {
                this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy(channel.getEncapsulatedClientTransaction());
            }
            catch (SecurityException ex) {
                throw new IOException(ex.getMessage());
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TLS Security policy passed");
            }
            this.putSocket(key, clientSock);
        }
        return clientSock.getLocalSocketAddress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean isClient, MessageChannel messageChannel) throws IOException {
        int retry_count = 0;
        int max_retry = isClient ? 2 : 1;
        int length = bytes.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length + " isClient " + isClient);
        }
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        if (transport.compareToIgnoreCase(TCP) == 0) {
            String key = IOHandler.makeKey(receiverAddress, contactPort);
            Socket clientSock = null;
            this.enterIOCriticalSection(key);
            try {
                clientSock = this.getSocket(key);
                while (retry_count < max_retry) {
                    if (clientSock == null) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress);
                            logger.logDebug("port = " + contactPort);
                        }
                        clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        this.putSocket(key, clientSock);
                        break;
                    }
                    try {
                        OutputStream outputStream = clientSock.getOutputStream();
                        this.writeChunks(outputStream, bytes, length);
                        break;
                    }
                    catch (IOException ex) {
                        if (logger.isLoggingEnabled(4)) {
                            logger.logInfo("IOException occured retryCount " + retry_count);
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Removing and Closing socket");
                        }
                        this.removeSocket(key);
                        try {
                            clientSock.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        clientSock = null;
                        ++retry_count;
                        if (isClient) continue;
                        throw ex;
                    }
                }
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("Problem sending: sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " remoteHost " + messageChannel.getPeerAddress() + " remotePort " + messageChannel.getPeerPort() + " peerPacketPort " + messageChannel.getPeerPacketSourcePort() + " isClient " + isClient);
                }
                this.removeSocket(key);
                if (isClient) {
                    logger.logError("IOException occured at ", ex);
                    throw ex;
                }
                receiverAddress = InetAddress.getByName(messageChannel.getViaHost());
                contactPort = messageChannel.getViaPort();
                if (contactPort == -1) {
                    contactPort = 5060;
                }
                if ((clientSock = this.getSocket(key = IOHandler.makeKey(receiverAddress, messageChannel.getViaPort()))) == null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                    }
                    clientSock = this.sipStack.getNetworkLayer().createSocket(receiverAddress, contactPort, senderAddress);
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    this.putSocket(key, clientSock);
                    Socket socket = clientSock;
                    return socket;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sending to " + key);
                }
                try {
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    Socket socket = clientSock;
                    return socket;
                }
                catch (IOException ioe) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("IOException occured  ", ioe);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Removing and Closing socket");
                    }
                    this.removeSocket(key);
                    try {
                        clientSock.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    clientSock = null;
                    throw ioe;
                }
            }
            finally {
                this.leaveIOCriticalSection(key);
            }
            if (clientSock != null) return clientSock;
            if (!logger.isLoggingEnabled(4)) throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
            logger.logError(this.socketTable.toString());
            logger.logError("Could not connect to " + receiverAddress + ":" + contactPort);
            throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
        }
        if (transport.compareToIgnoreCase(TLS) != 0) {
            DatagramSocket datagramSock = this.sipStack.getNetworkLayer().createDatagramSocket();
            datagramSock.connect(receiverAddress, contactPort);
            DatagramPacket dgPacket = new DatagramPacket(bytes, 0, length, receiverAddress, contactPort);
            datagramSock.send(dgPacket);
            datagramSock.close();
            return null;
        }
        String key = IOHandler.makeKey(receiverAddress, contactPort);
        Socket clientSock = null;
        this.enterIOCriticalSection(key);
        try {
            clientSock = this.getSocket(key);
            while (retry_count < max_retry) {
                if (clientSock == null) {
                    clientSock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                    SSLSocket sslsock = (SSLSocket)clientSock;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("inaddr = " + receiverAddress);
                        logger.logDebug("port = " + contactPort);
                    }
                    HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel);
                    ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener(listner);
                    sslsock.addHandshakeCompletedListener(listner);
                    sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                    sslsock.startHandshake();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Handshake passed");
                    }
                    try {
                        this.sipStack.getTlsSecurityPolicy().enforceTlsPolicy(messageChannel.getEncapsulatedClientTransaction());
                    }
                    catch (SecurityException ex) {
                        throw new IOException(ex.getMessage());
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("TLS Security policy passed");
                    }
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    this.putSocket(key, clientSock);
                    break;
                }
                try {
                    OutputStream outputStream = clientSock.getOutputStream();
                    this.writeChunks(outputStream, bytes, length);
                    break;
                }
                catch (IOException ex) {
                    if (logger.isLoggingEnabled()) {
                        logger.logException(ex);
                    }
                    this.removeSocket(key);
                    try {
                        logger.logDebug("Closing socket");
                        clientSock.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    clientSock = null;
                    ++retry_count;
                }
            }
        }
        catch (SSLHandshakeException ex) {
            this.removeSocket(key);
            throw ex;
        }
        catch (IOException ex) {
            this.removeSocket(key);
            if (isClient) throw ex;
            receiverAddress = InetAddress.getByName(messageChannel.getViaHost());
            contactPort = messageChannel.getViaPort();
            if (contactPort == -1) {
                contactPort = 5060;
            }
            if ((clientSock = this.getSocket(key = IOHandler.makeKey(receiverAddress, messageChannel.getViaPort()))) == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                }
                SSLSocket sslsock = this.sipStack.getNetworkLayer().createSSLSocket(receiverAddress, contactPort, senderAddress);
                OutputStream outputStream2 = sslsock.getOutputStream();
                HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((TLSMessageChannel)messageChannel);
                ((TLSMessageChannel)messageChannel).setHandshakeCompletedListener(listner);
                sslsock.addHandshakeCompletedListener(listner);
                sslsock.setEnabledProtocols(this.sipStack.getEnabledProtocols());
                sslsock.startHandshake();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Handshake passed");
                }
                this.writeChunks(outputStream2, bytes, length);
                this.putSocket(key, clientSock);
                SSLSocket sSLSocket = sslsock;
                return sSLSocket;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("sending to " + key);
            }
            try {
                OutputStream outputStream = clientSock.getOutputStream();
                this.writeChunks(outputStream, bytes, length);
                Socket outputStream2 = clientSock;
                return outputStream2;
            }
            catch (IOException ioe) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("IOException occured  ", ioe);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Removing and Closing socket");
                }
                this.removeSocket(key);
                try {
                    clientSock.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                clientSock = null;
                throw ioe;
            }
        }
        finally {
            this.leaveIOCriticalSection(key);
        }
        if (clientSock != null) return clientSock;
        throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
    }

    private void leaveIOCriticalSection(String key) {
        Semaphore creationSemaphore = this.socketCreationMap.get(key);
        if (creationSemaphore != null) {
            creationSemaphore.release();
        }
    }

    private void enterIOCriticalSection(String key) throws IOException {
        Semaphore newCreationSemaphore;
        Semaphore creationSemaphore = this.socketCreationMap.get(key);
        if (creationSemaphore == null && (creationSemaphore = this.socketCreationMap.putIfAbsent(key, newCreationSemaphore = new Semaphore(1, true))) == null) {
            creationSemaphore = newCreationSemaphore;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("new Semaphore added for key " + key);
            }
        }
        try {
            boolean retval = creationSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }

    public void closeAll() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.socketTable.size() + " sockets from IOHandler");
        }
        Enumeration<Socket> values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            Socket s = values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

