/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.protocol.AbstractCall;
import net.java.sip.communicator.service.protocol.AbstractCallPeer;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelListener;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.ConferenceInfoDocument;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.event.SrtpListener;

public abstract class MediaAwareCallPeer<T extends MediaAwareCall<?, ?, V>, U extends CallPeerMediaHandler<?>, V extends ProtocolProviderService>
extends AbstractCallPeer<T, V>
implements SrtpListener,
CallPeerConferenceListener,
CsrcAudioLevelListener,
SimpleAudioLevelListener {
    private static final Logger logger = Logger.getLogger(MediaAwareCallPeer.class);
    private T call;
    private final List<ConferenceMembersSoundLevelListener> conferenceMembersSoundLevelListeners = new ArrayList<ConferenceMembersSoundLevelListener>();
    private byte[] image;
    private U mediaHandler;
    private PropertyChangeListener mediaHandlerPropertyChangeListener;
    private String peerID;
    private final V protocolProvider;
    private List<SoundLevelListener> streamSoundLevelListeners;
    private final Object streamSoundLevelListenersSyncRoot = new Object();
    private final List<PropertyChangeListener> videoPropertyChangeListeners = new LinkedList<PropertyChangeListener>();
    private ConferenceInfoDocument lastConferenceInfoSent = null;
    private long lastConferenceInfoSentTimestamp = -1L;
    private ConferenceInfoDocument lastConferenceInfoReceived = null;
    private boolean confInfoScheduled = false;
    private final Object confInfoScheduledSyncRoot = new Object();

    public MediaAwareCallPeer(T owningCall) {
        this.call = owningCall;
        this.protocolProvider = ((AbstractCall)owningCall).getProtocolProvider();
        this.peerID = String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode());
        super.addCallPeerConferenceListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConferenceMembersSoundLevelListener(ConferenceMembersSoundLevelListener listener) {
        if (listener == null) {
            return;
        }
        List<ConferenceMembersSoundLevelListener> list = this.conferenceMembersSoundLevelListeners;
        synchronized (list) {
            if (this.conferenceMembersSoundLevelListeners.size() == 0) {
                ((CallPeerMediaHandler)((Object)this.getMediaHandler())).setCsrcAudioLevelListener(this);
            }
            this.conferenceMembersSoundLevelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStreamSoundLevelListener(SoundLevelListener listener) {
        Object object = this.streamSoundLevelListenersSyncRoot;
        synchronized (object) {
            if (this.streamSoundLevelListeners == null || this.streamSoundLevelListeners.isEmpty()) {
                U mediaHandler = this.getMediaHandler();
                if (this.isJitsiVideobridge()) {
                    ((CallPeerMediaHandler)((Object)mediaHandler)).setCsrcAudioLevelListener(this);
                } else {
                    ((CallPeerMediaHandler)((Object)mediaHandler)).setStreamAudioLevelListener(this);
                }
            }
            this.streamSoundLevelListeners = this.streamSoundLevelListeners == null ? new ArrayList<SoundLevelListener>() : new ArrayList<SoundLevelListener>(this.streamSoundLevelListeners);
            this.streamSoundLevelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<PropertyChangeListener> list = this.videoPropertyChangeListeners;
        synchronized (list) {
            if (!this.videoPropertyChangeListeners.contains(listener) && this.videoPropertyChangeListeners.add(listener) && this.mediaHandlerPropertyChangeListener == null) {
                this.mediaHandlerPropertyChangeListener = new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        LinkedList listeners;
                        List list = MediaAwareCallPeer.this.videoPropertyChangeListeners;
                        synchronized (list) {
                            listeners = new LinkedList(MediaAwareCallPeer.this.videoPropertyChangeListeners);
                        }
                        PropertyChangeEvent thisEvent = new PropertyChangeEvent(this, event.getPropertyName(), event.getOldValue(), event.getNewValue());
                        for (PropertyChangeListener listener : listeners) {
                            listener.propertyChange(thisEvent);
                        }
                    }
                };
                this.getMediaHandler().addPropertyChangeListener(this.mediaHandlerPropertyChangeListener);
            }
        }
    }

    public void audioLevelChanged(int newLevel) {
        long audioRemoteSSRC;
        int conferenceMemberCount = this.getConferenceMemberCount();
        if (conferenceMemberCount > 0 && conferenceMemberCount < 3 && (audioRemoteSSRC = ((CallPeerMediaHandler)((Object)this.getMediaHandler())).getRemoteSSRC(MediaType.AUDIO)) != -1L) {
            this.audioLevelsReceived(new long[]{audioRemoteSSRC, newLevel});
            return;
        }
        this.fireStreamSoundLevelChanged(newLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void audioLevelsReceived(long[] audioLevels) {
        long audioRemoteSSRC;
        if (this.isJitsiVideobridge() && (audioRemoteSSRC = ((CallPeerMediaHandler)((Object)this.getMediaHandler())).getRemoteSSRC(MediaType.AUDIO)) != -1L) {
            for (int i = 0; i < audioLevels.length; i += 2) {
                if (audioLevels[i] != audioRemoteSSRC) continue;
                this.fireStreamSoundLevelChanged((int)audioLevels[i + 1]);
                break;
            }
        }
        if (this.getConferenceMemberCount() == 0) {
            return;
        }
        HashMap<ConferenceMember, Integer> levelsMap = new HashMap<ConferenceMember, Integer>();
        for (int i = 0; i < audioLevels.length; i += 2) {
            ConferenceMember mmbr = this.findConferenceMember(audioLevels[i]);
            if (mmbr == null) continue;
            levelsMap.put(mmbr, (int)audioLevels[i + 1]);
        }
        List<ConferenceMembersSoundLevelListener> list = this.conferenceMembersSoundLevelListeners;
        synchronized (list) {
            int conferenceMemberSoundLevelListenerCount = this.conferenceMembersSoundLevelListeners.size();
            if (conferenceMemberSoundLevelListenerCount > 0) {
                ConferenceMembersSoundLevelEvent ev = new ConferenceMembersSoundLevelEvent(this, levelsMap);
                for (int i = 0; i < conferenceMemberSoundLevelListenerCount; ++i) {
                    this.conferenceMembersSoundLevelListeners.get(i).soundLevelChanged(ev);
                }
            }
        }
    }

    public void callPeerAdded(CallPeerEvent evt) {
    }

    public void callPeerRemoved(CallPeerEvent evt) {
    }

    @Override
    public void conferenceFocusChanged(CallPeerConferenceEvent evt) {
    }

    @Override
    public void conferenceMemberAdded(CallPeerConferenceEvent conferenceEvent) {
        if (this.getConferenceMemberCount() > 2) {
            U mediaHandler = this.getMediaHandler();
            ((CallPeerMediaHandler)((Object)mediaHandler)).setStreamAudioLevelListener(null);
            ((CallPeerMediaHandler)((Object)mediaHandler)).setCsrcAudioLevelListener(this);
        }
    }

    @Override
    public void conferenceMemberErrorReceived(CallPeerConferenceEvent ev) {
    }

    @Override
    public void conferenceMemberRemoved(CallPeerConferenceEvent conferenceEvent) {
        if (this.getConferenceMemberCount() < 3) {
            U mediaHandler = this.getMediaHandler();
            ((CallPeerMediaHandler)((Object)mediaHandler)).setStreamAudioLevelListener(this);
            ((CallPeerMediaHandler)((Object)mediaHandler)).setCsrcAudioLevelListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamSoundLevelChanged(int newLevel) {
        List<SoundLevelListener> streamSoundLevelListeners;
        Object object = this.streamSoundLevelListenersSyncRoot;
        synchronized (object) {
            streamSoundLevelListeners = this.streamSoundLevelListeners;
        }
        if (streamSoundLevelListeners != null) {
            int streamSoundLevelListenerCount = streamSoundLevelListeners.size();
            for (int i = 0; i < streamSoundLevelListenerCount; ++i) {
                streamSoundLevelListeners.get(i).soundLevelChanged(this, newLevel);
            }
        }
    }

    @Override
    public T getCall() {
        return this.call;
    }

    @Override
    public byte[] getImage() {
        return this.image;
    }

    public U getMediaHandler() {
        return this.mediaHandler;
    }

    @Override
    public String getPeerID() {
        return this.peerID;
    }

    @Override
    public V getProtocolProvider() {
        return this.protocolProvider;
    }

    public final boolean isJitsiVideobridge() {
        CallConference conference;
        Call call = this.getCall();
        if (call != null && (conference = call.getConference()) != null) {
            return conference.isJitsiVideobridge();
        }
        return false;
    }

    public boolean isLocalVideoStreaming() {
        return ((CallPeerMediaHandler)((Object)this.getMediaHandler())).isLocalVideoTransmissionEnabled();
    }

    @Override
    public boolean isMute() {
        return ((CallPeerMediaHandler)((Object)this.getMediaHandler())).isMute();
    }

    public void logAndFail(String message, Throwable throwable) {
        logger.error((Object)message, throwable);
        this.setState(CallPeerState.FAILED, message);
    }

    public void reevalLocalHoldStatus() {
        CallPeerState state = this.getState();
        boolean locallyOnHold = ((CallPeerMediaHandler)((Object)this.getMediaHandler())).isLocallyOnHold();
        if (CallPeerState.ON_HOLD_LOCALLY.equals(state)) {
            if (!locallyOnHold) {
                this.setState(CallPeerState.CONNECTED);
            }
        } else if (CallPeerState.ON_HOLD_MUTUALLY.equals(state)) {
            if (!locallyOnHold) {
                this.setState(CallPeerState.ON_HOLD_REMOTELY);
            }
        } else if (CallPeerState.ON_HOLD_REMOTELY.equals(state)) {
            if (locallyOnHold) {
                this.setState(CallPeerState.ON_HOLD_MUTUALLY);
            }
        } else if (locallyOnHold) {
            this.setState(CallPeerState.ON_HOLD_LOCALLY);
        }
    }

    public void reevalRemoteHoldStatus() {
        boolean remotelyOnHold = ((CallPeerMediaHandler)((Object)this.getMediaHandler())).isRemotelyOnHold();
        CallPeerState state = this.getState();
        if (CallPeerState.ON_HOLD_LOCALLY.equals(state)) {
            if (remotelyOnHold) {
                this.setState(CallPeerState.ON_HOLD_MUTUALLY);
            }
        } else if (CallPeerState.ON_HOLD_MUTUALLY.equals(state)) {
            if (!remotelyOnHold) {
                this.setState(CallPeerState.ON_HOLD_LOCALLY);
            }
        } else if (CallPeerState.ON_HOLD_REMOTELY.equals(state)) {
            if (!remotelyOnHold) {
                this.setState(CallPeerState.CONNECTED);
            }
        } else if (remotelyOnHold) {
            this.setState(CallPeerState.ON_HOLD_REMOTELY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConferenceMembersSoundLevelListener(ConferenceMembersSoundLevelListener listener) {
        List<ConferenceMembersSoundLevelListener> list = this.conferenceMembersSoundLevelListeners;
        synchronized (list) {
            if (this.conferenceMembersSoundLevelListeners.remove(listener) && this.conferenceMembersSoundLevelListeners.size() == 0) {
                ((CallPeerMediaHandler)((Object)this.getMediaHandler())).setCsrcAudioLevelListener(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStreamSoundLevelListener(SoundLevelListener listener) {
        Object object = this.streamSoundLevelListenersSyncRoot;
        synchronized (object) {
            if (this.streamSoundLevelListeners != null) {
                this.streamSoundLevelListeners = new ArrayList<SoundLevelListener>(this.streamSoundLevelListeners);
                if (this.streamSoundLevelListeners.remove(listener) && this.streamSoundLevelListeners.isEmpty()) {
                    this.streamSoundLevelListeners = null;
                }
            }
            if (this.streamSoundLevelListeners == null || this.streamSoundLevelListeners.isEmpty()) {
                ((CallPeerMediaHandler)((Object)this.getMediaHandler())).setStreamAudioLevelListener(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVideoPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this.videoPropertyChangeListeners;
            synchronized (list) {
                if (this.videoPropertyChangeListeners.remove(listener) && this.videoPropertyChangeListeners.isEmpty() && this.mediaHandlerPropertyChangeListener != null) {
                    this.mediaHandlerPropertyChangeListener = null;
                }
            }
        }
    }

    public void securityMessageReceived(String messageType, String i18nMessage, int severity) {
        this.fireCallPeerSecurityMessageEvent(messageType, i18nMessage, severity);
    }

    public void securityNegotiationStarted(MediaType mediaType, SrtpControl sender) {
        this.fireCallPeerSecurityNegotiationStartedEvent(new CallPeerSecurityNegotiationStartedEvent(this, MediaAwareCallPeer.toSessionType(mediaType), sender));
    }

    public void securityTimeout(MediaType mediaType) {
        this.fireCallPeerSecurityTimeoutEvent(new CallPeerSecurityTimeoutEvent(this, MediaAwareCallPeer.toSessionType(mediaType)));
    }

    public void securityTurnedOff(MediaType mediaType) {
        if (this.call != null && !((Call)this.call).getCallState().equals(CallState.CALL_ENDED)) {
            this.fireCallPeerSecurityOffEvent(new CallPeerSecurityOffEvent(this, MediaAwareCallPeer.toSessionType(mediaType)));
        }
    }

    public void securityTurnedOn(MediaType mediaType, String cipher, SrtpControl sender) {
        ((CallPeerMediaHandler)((Object)this.getMediaHandler())).startSrtpMultistream(sender);
        this.fireCallPeerSecurityOnEvent(new CallPeerSecurityOnEvent(this, MediaAwareCallPeer.toSessionType(mediaType), cipher, sender));
    }

    public void setCall(T call) {
        this.call = call;
    }

    public void setImage(byte[] image) {
        byte[] oldImage = this.getImage();
        this.image = image;
        this.fireCallPeerChangeEvent("CallPeerImageChange", oldImage, image);
    }

    public void setLocalVideoAllowed(boolean allowed) throws OperationFailedException {
        U mediaHandler = this.getMediaHandler();
        if (((CallPeerMediaHandler)((Object)mediaHandler)).isLocalVideoTransmissionEnabled() != allowed) {
            ((CallPeerMediaHandler)((Object)mediaHandler)).setLocalVideoTransmissionEnabled(allowed);
        }
    }

    protected void setMediaHandler(U mediaHandler) {
        this.mediaHandler = mediaHandler;
    }

    @Override
    public void setMute(boolean newMuteValue) {
        ((CallPeerMediaHandler)((Object)this.getMediaHandler())).setMute(newMuteValue);
        super.setMute(newMuteValue);
    }

    public void setPeerID(String peerID) {
        this.peerID = peerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(CallPeerState newState, String reason, int reasonCode) {
        U mediaHandler;
        U u = mediaHandler = this.getMediaHandler();
        synchronized (u) {
            try {
                super.setState(newState, reason, reasonCode);
            }
            finally {
                if (CallPeerState.DISCONNECTED.equals(newState) || CallPeerState.FAILED.equals(newState)) {
                    ((CallPeerMediaHandler)((Object)mediaHandler)).close();
                }
            }
        }
    }

    public ConferenceInfoDocument getLastConferenceInfoSent() {
        return this.lastConferenceInfoSent;
    }

    public void setLastConferenceInfoSent(ConferenceInfoDocument confInfo) {
        this.lastConferenceInfoSent = confInfo;
    }

    public long getLastConferenceInfoSentTimestamp() {
        return this.lastConferenceInfoSentTimestamp;
    }

    public void setLastConferenceInfoSentTimestamp(long newTimestamp) {
        this.lastConferenceInfoSentTimestamp = newTimestamp;
    }

    public ConferenceInfoDocument getLastConferenceInfoReceived() {
        return this.lastConferenceInfoReceived;
    }

    public void setLastConferenceInfoReceived(ConferenceInfoDocument confInfo) {
        this.lastConferenceInfoReceived = confInfo;
    }

    public int getLastConferenceInfoReceivedVersion() {
        return this.lastConferenceInfoReceived == null ? -1 : this.lastConferenceInfoReceived.getVersion();
    }

    public abstract String getEntity();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfInfoScheduled() {
        Object object = this.confInfoScheduledSyncRoot;
        synchronized (object) {
            return this.confInfoScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfInfoScheduled(boolean confInfoScheduled) {
        Object object = this.confInfoScheduledSyncRoot;
        synchronized (object) {
            this.confInfoScheduled = confInfoScheduled;
        }
    }

    public abstract MediaDirection getDirection(MediaType var1);

    @Override
    public void removeConferenceMember(ConferenceMember conferenceMember) {
        MediaStream videoStream = ((CallPeerMediaHandler)((Object)this.getMediaHandler())).getStream(MediaType.VIDEO);
        if (videoStream != null) {
            videoStream.removeReceiveStreamForSsrc(conferenceMember.getVideoSsrc());
        }
        super.removeConferenceMember(conferenceMember);
    }

    private static int toSessionType(MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return 1;
            }
            case VIDEO: {
                return 2;
            }
        }
        throw new IllegalArgumentException("mediaType");
    }
}

