/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends PropertyChangeNotifier {
    public static final String CHANNELS_PROPERTY_NAME = Endpoint.class.getName() + ".channels";
    private final List<WeakReference<Channel>> channels = new LinkedList<WeakReference<Channel>>();
    private final String id;

    public Endpoint(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (channel.isExpired()) {
            return false;
        }
        boolean added = false;
        boolean removed = false;
        List<WeakReference<Channel>> list = this.channels;
        synchronized (list) {
            boolean add = true;
            Iterator<WeakReference<Channel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)i.next().get();
                if (c == null) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (c.equals(channel)) {
                    add = false;
                    continue;
                }
                if (!c.isExpired()) continue;
                i.remove();
                removed = true;
            }
            if (add) {
                this.channels.add(new WeakReference<Channel>(channel));
                added = true;
            }
        }
        if (added || removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return added;
    }

    void audioLevelChanged(Channel channel, long ssrc, int audioLevel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getChannels(MediaType mediaType) {
        LinkedList<Channel> channels;
        LinkedList<Channel> linkedList = channels = new LinkedList<Channel>();
        synchronized (linkedList) {
            Iterator<WeakReference<Channel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel channel = (Channel)i.next().get();
                if (channel == null || mediaType != null && !mediaType.equals((Object)channel.getContent().getMediaType())) continue;
                channels.add(channel);
            }
        }
        return channels;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(Channel channel) {
        if (channel == null) {
            return false;
        }
        boolean removed = false;
        List<WeakReference<Channel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<Channel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)i.next().get();
                if (c != null && !c.equals(channel) && !c.isExpired()) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return removed;
    }
}

