/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.voxeo.sftp.BaseSftpClient;
import com.voxeo.sftp.ISftpFileAttributes;
import com.voxeo.utils.Lists;
import com.voxeo.utils.Objects;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCraftSftpClient
extends BaseSftpClient {
    private final Session session;
    final ChannelSftp sftp;

    public JCraftSftpClient(Session ssh, int connectTimeout) throws JSchException {
        this.session = ssh;
        this.sftp = (ChannelSftp)ssh.openChannel("sftp");
        this.sftp.connect(connectTimeout);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.log.trace("Closing SFTP client %s", this);
        this.sftp.quit();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public ISftpFileAttributes stat(String path) throws IOException {
        ISftpFileAttributes result;
        this.log.trace("stat %s", path);
        try {
            SftpATTRS attr = this.sftp.stat(path);
            result = this.wrap(path, attr);
        }
        catch (SftpException e) {
            IOException ioException = this.wrap(e);
            if (ioException instanceof FileNotFoundException) {
                result = null;
            }
            throw ioException;
        }
        return result;
    }

    @Override
    public List<ISftpFileAttributes> ls(String path) throws IOException {
        this.log.trace("ls %s", path);
        List<ISftpFileAttributes> result = Lists.make(new Object[0]);
        try {
            Vector list = this.sftp.ls(path);
            for (ChannelSftp.LsEntry entry : list) {
                result.add(this.wrap(entry));
            }
            return result;
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    private ISftpFileAttributes wrap(ChannelSftp.LsEntry entry) {
        return this.wrap(entry.getFilename(), entry.getAttrs());
    }

    private ISftpFileAttributes wrap(final String path, final SftpATTRS attr) {
        return new ISftpFileAttributes(){

            public boolean isDirectory() {
                return attr.isDir();
            }

            public long getSize() {
                return attr.getSize();
            }

            public String getModifiedTime() {
                return attr.getMtimeString();
            }

            public String getFilename() {
                int idx = path.lastIndexOf(47);
                String result = idx != -1 ? path.substring(idx + 1) : path;
                return result;
            }
        };
    }

    @Override
    protected void doNonRecursiveRmDir(String path) throws IOException {
        try {
            this.sftp.rmdir(path);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void mkdir(String path) throws IOException {
        this.log.trace("mkdir %s", path);
        try {
            this.sftp.mkdir(path);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void get(String path, OutputStream ostream) throws IOException {
        this.log.trace("get %s", path);
        try {
            this.sftp.get(path, ostream);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void put(InputStream istream, String path) throws IOException {
        this.log.trace("put %s", path);
        try {
            this.sftp.put(istream, path);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    IOException wrap(SftpException sftpException) {
        String message = sftpException.getMessage();
        IOException result = Objects.equal("No such file", message) ? new FileNotFoundException() : new IOException(sftpException);
        return result;
    }

    @Override
    public void rm(String path) throws IOException {
        this.log.trace("rm %s", path);
        try {
            this.sftp.rm(path);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public void cd(String path) throws IOException {
        this.log.trace("cd %s", path);
        try {
            this.sftp.cd(path);
        }
        catch (SftpException e) {
            throw this.wrap(e);
        }
    }
}

