/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.logging.LoggingContext;
import com.voxeo.utils.MessageResourceUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLogger {
    private final Logger log;

    protected VLogger(Class<?> clazz) {
        this.log = Logger.getLogger(clazz);
    }

    public void setLoggingContext(String accountID, String parentSessionID, String sessionID) {
        LoggingContext context = LoggingContext.get();
        context.setCommand("1");
        context.setAccountID(accountID == null ? "0" : accountID);
        context.setSessionGUID(sessionID == null ? "" : sessionID);
        context.setSessionNumber(parentSessionID == null ? "" : parentSessionID);
    }

    public void fatal(String message, Object ... parameters) {
        this.log.fatal((Object)MessageResourceUtil.format(message, parameters, null));
    }

    public void fatal(String message, Throwable t, Object ... parameters) {
        this.log.fatal((Object)MessageResourceUtil.format(message, parameters, null), t);
    }

    public void error(String message, Object ... parameters) {
        this.log.error((Object)MessageResourceUtil.format(message, parameters, null));
    }

    public void error(String message, Throwable t, Object ... parameters) {
        this.log.error((Object)MessageResourceUtil.format(message, parameters, null), t);
    }

    public void warn(String message, Object ... parameters) {
        this.log.warn((Object)MessageResourceUtil.format(message, parameters, null));
    }

    public void warn(String message, Throwable t, Object ... parameters) {
        this.log.warn((Object)MessageResourceUtil.format(message, parameters, null), t);
    }

    public void info(String message, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageResourceUtil.format(message, parameters, null));
        }
    }

    public void info(String message, Throwable t, Object ... parameters) {
        if (this.isInfoEnabled()) {
            this.log.info((Object)MessageResourceUtil.format(message, parameters, null), t);
        }
    }

    public void debug(String message, Object ... parameters) {
        if (this.isDebugEnabled()) {
            this.log.debug((Object)MessageResourceUtil.format(message, parameters, null));
        }
    }

    public void debug(String message, Throwable t, Object ... parameters) {
        if (this.isDebugEnabled()) {
            this.log.debug((Object)MessageResourceUtil.format(message, parameters, null), t);
        }
    }

    public void trace(String message, Object ... parameters) {
        if (this.isTraceEnabled()) {
            this.log.trace((Object)MessageResourceUtil.format(message, parameters, null));
        }
    }

    public void trace(String message, Throwable t, Object ... parameters) {
        if (this.isTraceEnabled()) {
            this.log.trace((Object)MessageResourceUtil.format(message, parameters, null), t);
        }
    }

    public static VLogger getLogger(Class<?> cls) {
        return new VLogger(cls);
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }
}

