/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.util.Date;
import pl.mn.communicator.AbstractStatus;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.StatusType;

public class RemoteStatus
extends AbstractStatus
implements IRemoteStatus {
    private boolean m_blocked = false;
    private byte[] m_remoteIP = null;
    private int m_remotePort = -1;
    private int m_imageSize = -1;
    private int m_version = -1;
    private int m_descriptionSize = -1;
    private boolean m_supportsVoiceCommunication = false;
    private boolean m_supportsDirectCommunication = false;
    private boolean m_areWeInRemoteUserBuddyList = false;
    private boolean m_isUserBehindFirewall = false;

    public RemoteStatus(StatusType statusType) {
        super(statusType);
    }

    public RemoteStatus(StatusType statusType, String description) {
        super(statusType, description);
    }

    public RemoteStatus(StatusType statusType, String description, Date returnDate) {
        super(statusType, description, returnDate);
    }

    public void setBlocked(boolean blocked) {
        this.m_blocked = blocked;
    }

    public boolean isBlocked() {
        return this.m_blocked;
    }

    public byte[] getRemoteIP() {
        return this.m_remoteIP;
    }

    public void setRemoteIP(byte[] remoteIP) {
        if (remoteIP == null) {
            throw new NullPointerException("remoteIP cannot be null");
        }
        if (remoteIP.length != 4) {
            throw new IllegalArgumentException("remoteIP must contain 4 entries");
        }
        this.m_remoteIP = remoteIP;
    }

    public int getRemotePort() {
        return this.m_remotePort;
    }

    public void setRemotePort(int remotePort) {
        if (remotePort < 0 || remotePort > 65535) {
            throw new IllegalArgumentException("Incorrect remotePort number");
        }
        this.m_remotePort = remotePort;
    }

    public int getGGVersion() {
        return this.m_version;
    }

    public void setGGVersion(int version) {
        this.m_version = version;
    }

    public int getImageSize() {
        return this.m_imageSize;
    }

    public void setImageSize(int imageSize) {
        if (imageSize < 0) {
            throw new IllegalArgumentException("Illegal imageSize");
        }
        this.m_imageSize = imageSize;
    }

    public boolean supportsVoiceCommunication() {
        return this.m_supportsVoiceCommunication;
    }

    public void setSupportsVoiceCommunication(boolean supportsVoiceCommunication) {
        this.m_supportsVoiceCommunication = supportsVoiceCommunication;
    }

    public boolean supportsDirectCommunication() {
        return this.m_supportsDirectCommunication;
    }

    public void setSupportsDirectCommunication(boolean supportsDirectCommunication) {
        this.m_supportsDirectCommunication = supportsDirectCommunication;
    }

    public boolean areWeInRemoteUserBuddyList() {
        return this.m_areWeInRemoteUserBuddyList;
    }

    public void setAreWeInRemoteUserBuddyList(boolean areWeInRemoteUserBuddyList) {
        this.m_areWeInRemoteUserBuddyList = areWeInRemoteUserBuddyList;
    }

    public int getDescriptionSize() {
        return this.m_descriptionSize;
    }

    public void setDescriptionSize(int descriptionSize) {
        if (descriptionSize < 0) {
            throw new IllegalArgumentException("descriptionSize cannot be less than 0");
        }
        this.m_descriptionSize = descriptionSize;
    }

    public boolean isUserBehindFirewall() {
        return this.m_isUserBehindFirewall;
    }

    public void setUserBehindFirewall(boolean userBehingFirewall) {
        this.m_isUserBehindFirewall = true;
    }
}

