/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.cart;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;

public class Intonator
implements UtteranceProcessor {
    protected CART accentCart;
    protected CART toneCart;

    public Intonator(CART accentCart, CART toneCart) {
        this.accentCart = accentCart;
        this.toneCart = toneCart;
    }

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        for (Item syllable = utterance.getRelation("Syllable").getHead(); syllable != null; syllable = syllable.getNext()) {
            String results = (String)this.accentCart.interpret(syllable);
            if (!results.equals("NONE")) {
                syllable.getFeatures().setString("accent", results);
            }
            if ((results = (String)this.toneCart.interpret(syllable)).equals("NONE")) continue;
            syllable.getFeatures().setString("endtone", results);
        }
    }

    public String toString() {
        return "CARTIntonator";
    }
}

