/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import org.jetbrains.annotations.Nullable;

public final class OldIconHashInfo {
    private final long size;
    private final int sum;
    private final long timestamp;
    private final int hashBlockSize;

    public static int computeIconSum(InputStream inputStream) throws IOException {
        int n;
        long l = 0L;
        int n2 = -1;
        while ((n = inputStream.read()) != -1) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                n2 = n;
                break;
            }
            l += (long)(((n3 & 0xFF) << 8) + (n & 0xFF));
        }
        if (n2 != -1) {
            l += (long)n2;
        }
        l = ((l & 0xFFFF0000L) >> 16) + (l & 0xFFFFL);
        return (int)l;
    }

    public static int computeIconSum(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "data");
        try {
            return OldIconHashInfo.computeIconSum(ByteBlock.createInputStream(byteBlock));
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    @Nullable
    public static OldIconHashInfo readIconHashFromImTlvData(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 12) {
            return null;
        }
        long l = BinaryTools.getUInt(byteBlock, 0);
        int n = BinaryTools.getUShort(byteBlock, 6);
        long l2 = BinaryTools.getUInt(byteBlock, 8);
        return new OldIconHashInfo(l, n, l2, 12);
    }

    public static OldIconHashInfo readIconHashFromRvData(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 12) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 2);
        long l = BinaryTools.getUInt(byteBlock, 4);
        long l2 = BinaryTools.getUInt(byteBlock, 8);
        return new OldIconHashInfo(l, n, l2, 12);
    }

    public OldIconHashInfo(File file) throws FileNotFoundException, IOException {
        DefensiveTools.checkNull(file, "file");
        this.size = file.length();
        this.timestamp = file.lastModified();
        FileInputStream fileInputStream = new FileInputStream(file);
        this.sum = OldIconHashInfo.computeIconSum(fileInputStream);
        fileInputStream.close();
        this.hashBlockSize = -1;
    }

    private OldIconHashInfo(long l, int n, long l2, int n2) {
        DefensiveTools.checkRange(l, "size", 0L);
        DefensiveTools.checkRange(n, "sum", 0);
        DefensiveTools.checkRange(l2, "timestamp", 0L);
        DefensiveTools.checkRange(n2, "blockSize", -1);
        this.size = l;
        this.sum = n;
        this.timestamp = l2;
        this.hashBlockSize = n2;
    }

    public OldIconHashInfo(long l, int n, long l2) {
        this(l, n, l2, -1);
    }

    public final long getIconSize() {
        return this.size;
    }

    public final int getSum() {
        return this.sum;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public int getHashBlockSize() {
        return this.hashBlockSize;
    }

    public void writeToImTlv(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(12);
        BinaryTools.writeUInt(byteArrayOutputStream, this.size);
        BinaryTools.writeUShort(byteArrayOutputStream, 1);
        BinaryTools.writeUShort(byteArrayOutputStream, this.sum);
        BinaryTools.writeUInt(byteArrayOutputStream, this.timestamp);
        byteArrayOutputStream.writeTo(outputStream);
    }

    public int getImTlvFormatLength() {
        return 12;
    }

    public void writeToRvData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, 0);
        BinaryTools.writeUShort(outputStream, this.sum);
        BinaryTools.writeUInt(outputStream, this.size);
        BinaryTools.writeUInt(outputStream, this.timestamp);
    }

    public int getRvDataFormatLength() {
        return 12;
    }

    public String toString() {
        return "OldIconHashData: size=" + this.size + " bytes, sum=" + this.sum + ", lastmod=" + new Date(this.timestamp * 1000L);
    }
}

