/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class RvConnectionInfo
implements LiveWritable {
    private static final int TYPE_PROXYIP = 2;
    private static final int TYPE_INTERNALIP = 3;
    private static final int TYPE_EXTERNALIP = 4;
    private static final int TYPE_PORT = 5;
    private static final int TYPE_PROXIED = 16;
    private static final int TYPE_ENCRYPTED = 17;
    private final boolean encrypted;
    private final boolean proxied;
    private final InetAddress proxyIP;
    private final InetAddress internalIP;
    private final InetAddress externalIP;
    private final int port;

    public static RvConnectionInfo readConnectionInfo(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        Tlv tlv = tlvChain.getLastTlv(3);
        Inet4Address inet4Address = null;
        if (tlv != null) {
            inet4Address = BinaryTools.getIPFromBytes(tlv.getData(), 0);
        }
        Tlv tlv2 = tlvChain.getLastTlv(4);
        Inet4Address inet4Address2 = null;
        if (tlv2 != null) {
            inet4Address2 = BinaryTools.getIPFromBytes(tlv2.getData(), 0);
        }
        Tlv tlv3 = tlvChain.getLastTlv(2);
        Inet4Address inet4Address3 = null;
        if (tlv3 != null) {
            inet4Address3 = BinaryTools.getIPFromBytes(tlv3.getData(), 0);
        }
        int n = tlvChain.getUShort(5);
        boolean bl = tlvChain.hasTlv(16);
        boolean bl2 = tlvChain.hasTlv(17);
        return new RvConnectionInfo(inet4Address, inet4Address2, inet4Address3, n, bl, bl2);
    }

    public static RvConnectionInfo createForOutgoingRequest(InetAddress inetAddress, int n) {
        DefensiveTools.checkNull(inetAddress, "internalIP");
        return new RvConnectionInfo(inetAddress, null, null, n, false, false);
    }

    public static RvConnectionInfo createForOutgoingSecureRequest(InetAddress inetAddress, int n) {
        DefensiveTools.checkNull(inetAddress, "internalIP");
        return new RvConnectionInfo(inetAddress, null, null, n, false, true);
    }

    public static RvConnectionInfo createForOutgoingProxiedRequest(InetAddress inetAddress, int n) {
        DefensiveTools.checkNull(inetAddress, "proxyIP");
        return new RvConnectionInfo(null, null, inetAddress, n, true, false);
    }

    public RvConnectionInfo(InetAddress inetAddress, InetAddress inetAddress2, InetAddress inetAddress3, int n, boolean bl, boolean bl2) {
        DefensiveTools.checkRange(n, "port", -1);
        this.internalIP = inetAddress;
        this.externalIP = inetAddress2;
        this.proxyIP = inetAddress3;
        this.port = n;
        this.proxied = bl;
        this.encrypted = bl2;
    }

    public final InetAddress getInternalIP() {
        return this.internalIP;
    }

    public final InetAddress getExternalIP() {
        return this.externalIP;
    }

    public final boolean isProxied() {
        return this.proxied;
    }

    public final InetAddress getProxyIP() {
        return this.proxyIP;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean isEncrypted() {
        return this.encrypted;
    }

    private static void writeIP(OutputStream outputStream, int n, InetAddress inetAddress) throws IOException {
        ByteBlock byteBlock = ByteBlock.wrap(inetAddress.getAddress());
        new Tlv(n, byteBlock).write(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.internalIP != null) {
            RvConnectionInfo.writeIP(outputStream, 3, this.internalIP);
        }
        if (this.externalIP != null) {
            RvConnectionInfo.writeIP(outputStream, 4, this.externalIP);
        }
        if (this.proxyIP != null) {
            RvConnectionInfo.writeIP(outputStream, 2, this.proxyIP);
        }
        if (this.port != -1) {
            Tlv.getUShortInstance(5, this.port).write(outputStream);
        }
        if (this.proxied) {
            new Tlv(16).write(outputStream);
        }
        if (this.encrypted) {
            new Tlv(17).write(outputStream);
        }
    }

    public String toString() {
        return "ConnectionInfo: " + (this.proxied ? "(proxied) " : "") + (this.encrypted ? "(encrypted) " : "") + "internalIP=" + this.internalIP + ", externalIP=" + this.externalIP + ", proxyIP=" + this.proxyIP + ", port=" + this.port;
    }
}

