/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import net.kano.joscar.ByteBlock;

public final class TrustTools {
    private TrustTools() {
    }

    public static boolean isSigned(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            x509Certificate2.verify(x509Certificate.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isCertificateAuthority(X509Certificate x509Certificate) {
        return x509Certificate.getBasicConstraints() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadX509Certificate(File file) throws CertificateException, NoSuchProviderException, IOException {
        Certificate certificate;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
            certificate = certificateFactory.generateCertificate(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        if (certificate == null) {
            throw new NullPointerException("Unknown error: Certificate was null");
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("this file is not an X.509 certificate, it's a " + certificate.getClass().getName());
        }
        return (X509Certificate)certificate;
    }

    public static X509Certificate decodeCertificate(ByteBlock byteBlock) throws NoSuchProviderException, CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        InputStream inputStream = ByteBlock.createInputStream((ByteBlock)byteBlock);
        return (X509Certificate)certificateFactory.generateCertificate(inputStream);
    }
}

