/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.DefaultSsiItemObjFactory;
import net.kano.joscar.ssiitem.DenyItem;
import net.kano.joscar.ssiitem.PermitItem;
import net.kano.joscar.ssiitem.PrivacyItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectFactory;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.ssi.ChangeTools;
import net.kano.joustsim.oscar.oscar.service.ssi.DetectedChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.ItemIdComparator;
import net.kano.joustsim.oscar.oscar.service.ssi.PermissionList;
import net.kano.joustsim.oscar.oscar.service.ssi.PermissionListListener;
import net.kano.joustsim.oscar.oscar.service.ssi.PrivacyMode;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiTools;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SsiPermissionList
implements PermissionList,
SsiItemChangeListener {
    private SsiItemObjectFactory factory = new DefaultSsiItemObjFactory();
    private SortedSet<PrivacyItem> privacyItems = new TreeSet<SsiItemObjectWithId>(new ItemIdComparator());
    private CopyOnWriteArrayList<PermissionListListener> listeners = new CopyOnWriteArrayList();
    private List<DenyItem> denyItems = new ArrayList<DenyItem>();
    private List<PermitItem> permitItems = new ArrayList<PermitItem>();
    private AllowedBuddyChangeListener allowedBuddyChangeListener = new AllowedBuddyChangeListener();
    private BlockedBuddyChangeListener blockedBuddyChangeListener = new BlockedBuddyChangeListener();
    private final SsiService ssiService;

    public SsiPermissionList(SsiService ssiService) {
        this.ssiService = ssiService;
        ssiService.addItemChangeListener(this);
    }

    @Override
    public void handleItemCreated(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiPermissionList.this.handleItemsActuallyCreated(SsiPermissionList.this.factory.getItemObj(item));
            }
        });
    }

    @Override
    public void handleItemModified(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiItemObj itemObj = SsiPermissionList.this.factory.getItemObj(item);
                SsiPermissionList.this.handleItemActuallyModified(itemObj);
            }
        });
    }

    @Override
    public void handleItemDeleted(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiItemObj itemObj = SsiPermissionList.this.factory.getItemObj(item);
                SsiPermissionList.this.handleItemActuallyDeleted(itemObj);
            }
        });
    }

    private synchronized void handleItemsActuallyCreated(SsiItemObj item) {
        if (item instanceof PrivacyItem) {
            PrivacyItem pitem = (PrivacyItem)item;
            this.privacyItems.add(pitem);
        } else if (item instanceof DenyItem) {
            DenyItem denyItem = (DenyItem)item;
            this.denyItems.add(denyItem);
        } else if (item instanceof PermitItem) {
            PermitItem permitItem = (PermitItem)item;
            this.permitItems.add(permitItem);
        }
    }

    private synchronized void handleItemActuallyModified(SsiItemObj itemObj) {
        if (itemObj instanceof PrivacyItem) {
            PrivacyItem pitem = (PrivacyItem)itemObj;
            SsiTools.removeItemsWithId(this.privacyItems, pitem.getId());
            this.privacyItems.add(pitem);
        } else if (itemObj instanceof DenyItem) {
            DenyItem denyItem = (DenyItem)itemObj;
            SsiTools.removeItemsWithId(this.denyItems, denyItem.getId());
            this.denyItems.add(denyItem);
        } else if (itemObj instanceof PermitItem) {
            PermitItem permitItem = (PermitItem)itemObj;
            SsiTools.removeItemsWithId(this.permitItems, permitItem.getId());
            this.permitItems.add(permitItem);
        }
    }

    private synchronized void handleItemActuallyDeleted(SsiItemObj itemObj) {
        if (itemObj instanceof PrivacyItem) {
            PrivacyItem privacyItem = (PrivacyItem)itemObj;
            SsiTools.removeItemsWithId(this.privacyItems, privacyItem.getId());
        } else if (itemObj instanceof DenyItem) {
            DenyItem denyItem = (DenyItem)itemObj;
            SsiTools.removeItemsWithId(this.denyItems, denyItem.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyItems(Runnable runnable) {
        Set<Screenname> newAllowed;
        Set<Screenname> newBlocked;
        PrivacyItem newTopItem;
        Set<Screenname> oldAllowed;
        Set<Screenname> oldBlocked;
        PrivacyItem oldItem;
        assert (!Thread.holdsLock(this));
        SsiPermissionList ssiPermissionList = this;
        synchronized (ssiPermissionList) {
            oldItem = this.getPrivacyItem();
            oldBlocked = this.getBlockedBuddies();
            oldAllowed = this.getAllowedBuddies();
            runnable.run();
            newTopItem = this.getPrivacyItem();
            newBlocked = this.getBlockedBuddies();
            newAllowed = this.getAllowedBuddies();
        }
        this.updatePrivacyItem(oldItem, newTopItem);
        this.updateBlockedBuddies(oldBlocked, newBlocked);
        this.updateAllowedBuddies(oldAllowed, newAllowed);
    }

    private void updateBlockedBuddies(Set<Screenname> oldBlocked, Set<Screenname> newBlocked) {
        ChangeTools.detectChanges(oldBlocked, newBlocked, this.blockedBuddyChangeListener);
    }

    private void updateAllowedBuddies(Set<Screenname> oldAllowed, Set<Screenname> newAllowed) {
        ChangeTools.detectChanges(oldAllowed, newAllowed, this.allowedBuddyChangeListener);
    }

    @Override
    public synchronized PrivacyMode getPrivacyMode() {
        return this.getPrivacyModeFromItem(this.getPrivacyItem());
    }

    @Nullable
    private synchronized PrivacyItem getPrivacyItem() {
        return this.privacyItems.isEmpty() ? null : this.privacyItems.last();
    }

    private void updatePrivacyItem(@Nullable PrivacyItem oldItem, @Nullable PrivacyItem newItem) {
        PrivacyMode newMode;
        assert (!Thread.holdsLock(this));
        PrivacyMode oldMode = this.getPrivacyModeFromItem(oldItem);
        if (oldMode != (newMode = this.getPrivacyModeFromItem(newItem))) {
            for (PermissionListListener listener : this.listeners) {
                listener.handlePrivacyModeChange(this, oldMode, newMode);
            }
        }
    }

    @NotNull
    private PrivacyMode getPrivacyModeFromItem(@Nullable PrivacyItem item) {
        return item == null ? PrivacyMode.ALLOW_ALL : this.getPrivacyModeFromCode(item.getPrivacyMode());
    }

    private PrivacyMode getPrivacyModeFromCode(int code) {
        if (code == 1) {
            return PrivacyMode.ALLOW_ALL;
        }
        if (code == 3) {
            return PrivacyMode.ALLOW_ALLOWED;
        }
        if (code == 2) {
            return PrivacyMode.BLOCK_ALL;
        }
        if (code == 4) {
            return PrivacyMode.BLOCK_BLOCKED;
        }
        if (code == 5) {
            return PrivacyMode.ALLOW_BUDDIES;
        }
        return PrivacyMode.ALLOW_ALL;
    }

    @Override
    public synchronized Set<Screenname> getBlockedBuddies() {
        HashSet<Screenname> blocked = new HashSet<Screenname>();
        for (DenyItem denyItem : this.denyItems) {
            blocked.add(new Screenname(denyItem.getScreenname()));
        }
        return blocked;
    }

    @Override
    public synchronized Set<Screenname> getAllowedBuddies() {
        HashSet<Screenname> allowed = new HashSet<Screenname>();
        for (PermitItem permitItem : this.permitItems) {
            allowed.add(new Screenname(permitItem.getScreenname()));
        }
        return allowed;
    }

    @Override
    public synchronized Set<Screenname> getEffectiveBlockedBuddies() {
        if (this.getPrivacyMode() == PrivacyMode.BLOCK_BLOCKED) {
            return this.getBlockedBuddies();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public synchronized Set<Screenname> getEffectiveAllowedBuddies() {
        if (this.getPrivacyMode() == PrivacyMode.ALLOW_ALLOWED) {
            return this.getAllowedBuddies();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public void addToBlockList(Screenname sn) {
        int uniqueId = this.ssiService.getUniqueItemId(3, 0);
        DenyItem denyItem = new DenyItem(sn.getFormatted(), uniqueId);
        this.ssiService.sendSsiModification((ItemsCmd)new CreateItemsCmd(new SsiItem[]{denyItem.toSsiItem()}));
    }

    @Override
    public void addToAllowedList(Screenname sn) {
        int uniqueId = this.ssiService.getUniqueItemId(2, 0);
        PermitItem permitItem = new PermitItem(sn.getFormatted(), uniqueId);
        this.ssiService.sendSsiModification((ItemsCmd)new CreateItemsCmd(new SsiItem[]{permitItem.toSsiItem()}));
    }

    @Override
    public synchronized void removeFromBlockList(Screenname sn) {
        List<SsiItem> badItems = this.getDenyItemsForScreenname(sn);
        this.ssiService.sendSsiModification((ItemsCmd)new DeleteItemsCmd(badItems));
    }

    @Override
    public void removeFromAllowedList(Screenname sn) {
        List<SsiItem> badItems = this.getPermitItemsForScreenname(sn);
        this.ssiService.sendSsiModification((ItemsCmd)new DeleteItemsCmd(badItems));
    }

    private synchronized List<SsiItem> getDenyItemsForScreenname(Screenname sn) {
        ArrayList<SsiItem> badItems = new ArrayList<SsiItem>();
        for (DenyItem item : this.denyItems) {
            if (!new Screenname(item.getScreenname()).equals(sn)) continue;
            badItems.add(item.toSsiItem());
        }
        return badItems;
    }

    private synchronized List<SsiItem> getPermitItemsForScreenname(Screenname sn) {
        ArrayList<SsiItem> badItems = new ArrayList<SsiItem>();
        for (PermitItem item : this.permitItems) {
            if (!new Screenname(item.getScreenname()).equals(sn)) continue;
            badItems.add(item.toSsiItem());
        }
        return badItems;
    }

    @Override
    public void setPrivacyMode(PrivacyMode mode) {
        ModifyItemsCmd cmd;
        DefensiveTools.checkNull((Object)((Object)mode), (String)"mode");
        int privacyModeCode = this.getPrivacyModeCode(mode);
        PrivacyItem item = this.getPrivacyItem();
        if (item == null) {
            int uniqueId = this.ssiService.getUniqueItemId(4, 0);
            PrivacyItem ours = new PrivacyItem(uniqueId, privacyModeCode, 0L);
            cmd = new CreateItemsCmd(new SsiItem[]{ours.toSsiItem()});
        } else {
            PrivacyItem ours = new PrivacyItem(item);
            ours.setPrivacyMode(privacyModeCode);
            cmd = new ModifyItemsCmd(new SsiItem[]{ours.toSsiItem()});
        }
        this.ssiService.sendSsiModification((ItemsCmd)cmd);
    }

    private int getPrivacyModeCode(PrivacyMode mode) {
        if (mode == PrivacyMode.ALLOW_ALL) {
            return 1;
        }
        if (mode == PrivacyMode.ALLOW_ALLOWED) {
            return 3;
        }
        if (mode == PrivacyMode.ALLOW_BUDDIES) {
            return 5;
        }
        if (mode == PrivacyMode.BLOCK_ALL) {
            return 2;
        }
        if (mode == PrivacyMode.BLOCK_BLOCKED) {
            return 4;
        }
        throw new IllegalStateException("invalid privacy mode " + (Object)((Object)mode));
    }

    @Override
    public void addPermissionListListener(PermissionListListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    @Override
    public void removePermissionListListener(PermissionListListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockedBuddyChangeListener
    implements DetectedChangeListener<Screenname> {
        private BlockedBuddyChangeListener() {
        }

        @Override
        public void itemAdded(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems, Screenname item) {
            assert (!Thread.holdsLock(SsiPermissionList.this));
            Set oldItemsCopy = DefensiveTools.getUnmodifiableSetCopy(oldItems);
            Set newItemsCopy = DefensiveTools.getUnmodifiableSetCopy(newItems);
            for (PermissionListListener listener : SsiPermissionList.this.listeners) {
                listener.handleBuddyBlocked(SsiPermissionList.this, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemRemoved(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems, Screenname item) {
            assert (!Thread.holdsLock(SsiPermissionList.this));
            Set oldItemsCopy = DefensiveTools.getUnmodifiableSetCopy(oldItems);
            Set newItemsCopy = DefensiveTools.getUnmodifiableSetCopy(newItems);
            for (PermissionListListener listener : SsiPermissionList.this.listeners) {
                listener.handleBuddyUnblocked(SsiPermissionList.this, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemsReordered(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllowedBuddyChangeListener
    implements DetectedChangeListener<Screenname> {
        private AllowedBuddyChangeListener() {
        }

        @Override
        public void itemAdded(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems, Screenname item) {
            assert (!Thread.holdsLock(SsiPermissionList.this));
            Set oldItemsCopy = DefensiveTools.getUnmodifiableSetCopy(oldItems);
            Set newItemsCopy = DefensiveTools.getUnmodifiableSetCopy(newItems);
            for (PermissionListListener listener : SsiPermissionList.this.listeners) {
                listener.handleBuddyAllowed(SsiPermissionList.this, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemRemoved(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems, Screenname item) {
            assert (!Thread.holdsLock(SsiPermissionList.this));
            Set oldItemsCopy = DefensiveTools.getUnmodifiableSetCopy(oldItems);
            Set newItemsCopy = DefensiveTools.getUnmodifiableSetCopy(newItems);
            for (PermissionListListener listener : SsiPermissionList.this.listeners) {
                listener.handleBuddyRemovedFromAllowList(SsiPermissionList.this, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemsReordered(Collection<? extends Screenname> oldItems, Collection<? extends Screenname> newItems) {
        }
    }
}

