/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.Date;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationException;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ImMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MissedImInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingNotificationConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;

public class ImConversation
extends Conversation
implements TypingNotificationConversation {
    private final AimConnection conn;
    private final BuddyInfoTrackerListener tracker = new BuddyInfoTrackerListener(){};

    ImConversation(AimConnection conn, Screenname buddy) {
        super(buddy);
        this.conn = conn;
        this.setAlwaysOpen();
    }

    protected void opened() {
        this.conn.getBuddyInfoTracker().addTracker(this.getBuddy(), this.tracker);
    }

    protected void closed() {
        this.conn.getBuddyInfoTracker().removeTracker(this.getBuddy(), this.tracker);
    }

    public void sendMessage(Message msg) throws ConversationException {
        IcbmService service = this.conn.getIcbmService();
        if (service == null) {
            throw new ConversationException("no ICBM service to send to", (Conversation)this);
        }
        service.sendIM(this.getBuddy(), msg.getMessageBody(), msg.isAutoResponse());
        this.fireOutgoingEvent(ImMessageInfo.getInstance(this.conn.getScreenname(), this.getBuddy(), msg, new Date()));
    }

    protected void handleIncomingEvent(ConversationEventInfo event) {
        assert (!Thread.holdsLock(this));
        super.handleIncomingEvent(event);
    }

    public void setTypingState(TypingState typingState) {
        this.conn.getIcbmService().sendTypingStatus(this.getBuddy(), typingState);
        this.fireOutgoingEvent(new TypingInfo(this.conn.getScreenname(), this.getBuddy(), new Date(), typingState));
    }

    public void handleMissedMsg(MissedImInfo info) {
        for (ConversationListener listener : this.getListeners()) {
            if (!(listener instanceof ImConversationListener)) continue;
            ImConversationListener imlistener = (ImConversationListener)listener;
            imlistener.missedMessages(this, info);
        }
    }
}

