/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class RootItem
extends AbstractItemObj {
    private static final String NAME_DEFAULT = "";
    private static final int PARENTID_DEFAULT = 0;
    private static final int ID_DEFAULT = 0;
    private static final int TYPE_GROUPIDS = 200;
    @Nullable
    private int[] groupids;

    public RootItem(SsiItem ssiItem) {
        Writable writable;
        DefensiveTools.checkNull(ssiItem, "item");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        Tlv tlv = immutableTlvChain.getLastTlv(200);
        if (tlv != null) {
            writable = tlv.getData();
            this.groupids = new int[((ByteBlock)writable).getLength() / 2];
            for (int i = 0; i < this.groupids.length; ++i) {
                this.groupids[i] = BinaryTools.getUShort((ByteBlock)writable, i * 2);
            }
        } else {
            this.groupids = null;
        }
        writable = TlvTools.getMutableCopy(immutableTlvChain);
        writable.removeTlvs(200);
        this.addExtraTlvs((TlvChain)writable);
    }

    public RootItem(RootItem rootItem) {
        this(rootItem.groupids == null ? null : (int[])rootItem.groupids.clone(), rootItem.copyExtraTlvs());
    }

    public RootItem() {
        this(null, null);
    }

    public RootItem(int[] nArray) {
        this(nArray, null);
    }

    public RootItem(int[] nArray, TlvChain tlvChain) {
        super(tlvChain);
        this.groupids = nArray == null ? null : (int[])nArray.clone();
    }

    @Nullable
    public final synchronized int[] getGroupids() {
        return this.groupids == null ? null : (int[])this.groupids.clone();
    }

    public final synchronized void setGroupids(@Nullable int[] nArray) {
        this.groupids = nArray == null ? null : (int[])nArray.clone();
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.groupids != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.groupids.length * 2);
            try {
                for (int n : this.groupids) {
                    BinaryTools.writeUShort(byteArrayOutputStream, n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ByteBlock byteBlock = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
            mutableTlvChain.addTlv(new Tlv(200, byteBlock));
        }
        return this.generateItem(NAME_DEFAULT, 0, 0, 1, mutableTlvChain);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : this.groupids) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(n));
            stringBuffer.append(", ");
        }
        return "RootItem with groupids: " + stringBuffer;
    }
}

