/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import org.jetbrains.annotations.Nullable;

public class BuddyAuthRequest
extends SsiCommand {
    private final String screenname;
    @Nullable
    private final String message;

    protected BuddyAuthRequest(SnacPacket packet) {
        super(24);
        ByteBlock data = packet.getData();
        StringBlock sn = OscarTools.readScreenname(data);
        if (sn != null) {
            this.screenname = sn.getString();
            ByteBlock rest = data.subBlock(sn.getTotalSize());
            int msglen = BinaryTools.getUShort(rest, 0);
            this.message = BinaryTools.getUtf8String(data.subBlock(2, msglen));
        } else {
            this.screenname = null;
            this.message = null;
        }
    }

    public BuddyAuthRequest(String sn, @Nullable String msg) {
        super(24);
        this.screenname = sn;
        this.message = msg;
    }

    public void writeData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.screenname);
        byte[] data = this.message == null ? new byte[]{} : BinaryTools.getUtf8Bytes(this.message);
        BinaryTools.writeUShort(out, data.length);
        out.write(data);
        BinaryTools.writeUByte(out, 0);
        BinaryTools.writeUShort(out, 0);
    }
}

