/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.SendIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendImIcbm
extends AbstractImIcbm
implements SendIcbm {
    private static final int TYPE_ACK = 3;
    private final String sn;
    private final boolean ackRequested;

    protected SendImIcbm(SnacPacket snacPacket) {
        super(6, snacPacket);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = this.getChannelData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.processImTlvs(immutableTlvChain);
        this.ackRequested = immutableTlvChain.hasTlv(3);
    }

    public SendImIcbm(String string, String string2) {
        this(string, new InstantMessage(string2));
    }

    public SendImIcbm(String string, InstantMessage instantMessage) {
        this(string, instantMessage, false);
    }

    public SendImIcbm(String string, String string2, boolean bl) {
        this(string, new InstantMessage(string2), bl);
    }

    public SendImIcbm(String string, InstantMessage instantMessage, boolean bl) {
        this(string, instantMessage, bl, 0L, false, null, null, FEATURES_DEFAULT, true);
    }

    public SendImIcbm(String string, String string2, boolean bl, long l, boolean bl2, OldIconHashInfo oldIconHashInfo, Collection<ExtraInfoBlock> collection, boolean bl3) {
        this(string, new InstantMessage(string2), bl, l, bl2, oldIconHashInfo, collection, bl3);
    }

    public SendImIcbm(String string, InstantMessage instantMessage, boolean bl, long l, boolean bl2, OldIconHashInfo oldIconHashInfo, Collection<ExtraInfoBlock> collection, boolean bl3) {
        this(string, instantMessage, bl, l, bl2, oldIconHashInfo, collection, FEATURES_DEFAULT, bl3);
    }

    public SendImIcbm(String string, InstantMessage instantMessage, boolean bl, long l, boolean bl2, OldIconHashInfo oldIconHashInfo, Collection<ExtraInfoBlock> collection, ByteBlock byteBlock, boolean bl3) {
        super(6, l, instantMessage, bl, bl2, oldIconHashInfo, collection, byteBlock);
        DefensiveTools.checkNull(string, "sn");
        if (bl3 && bl) {
            throw new IllegalArgumentException("ackRequested and autoResponse cannot both be true");
        }
        this.sn = string;
        this.ackRequested = bl3;
    }

    @Override
    public final String getScreenname() {
        return this.sn;
    }

    public final boolean isAckRequested() {
        return this.ackRequested;
    }

    @Override
    protected void writeChannelData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        this.writeImTlvs(outputStream);
        if (this.ackRequested) {
            new Tlv(3).write(outputStream);
        }
    }

    @Override
    public String toString() {
        return "SendImIcbm to " + this.sn + " (id=" + this.getIcbmMessageId() + ", ackreq=" + this.ackRequested + "): " + this.getMessage();
    }
}

