/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.snaccmd.FullUserInfo;
import org.jetbrains.annotations.Nullable;

public class MissedMsgInfo
implements LiveWritable {
    public static final int REASON_TOO_LARGE = 1;
    public static final int REASON_TOO_FAST = 2;
    public static final int REASON_SENDER_WARNING_LEVEL = 3;
    public static final int REASON_YOUR_WARNING_LEVEL = 4;
    private final int channel;
    private final FullUserInfo userInfo;
    private final int number;
    private final int reason;
    private final int totalSize;

    @Nullable
    protected static MissedMsgInfo readMissedMsgInfo(ByteBlock byteBlock) {
        FullUserInfo fullUserInfo;
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 7) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ByteBlock byteBlock3 = byteBlock2.subBlock((fullUserInfo = FullUserInfo.readUserInfo(byteBlock2)).getTotalSize());
        if (byteBlock3.getLength() < 4) {
            return null;
        }
        int n2 = BinaryTools.getUShort(byteBlock3, 0) - 1;
        int n3 = BinaryTools.getUShort(byteBlock3, 2);
        ByteBlock byteBlock4 = byteBlock3.subBlock(4);
        return new MissedMsgInfo(n, fullUserInfo, n2, n3, byteBlock4.getOffset() - byteBlock.getOffset());
    }

    public MissedMsgInfo(int n, FullUserInfo fullUserInfo, int n2, int n3) {
        this(n, fullUserInfo, n2, n3, -1);
    }

    private MissedMsgInfo(int n, FullUserInfo fullUserInfo, int n2, int n3, int n4) {
        DefensiveTools.checkRange(n, "channel", 0);
        DefensiveTools.checkRange(n2, "number", 0);
        DefensiveTools.checkRange(n3, "reason", 0);
        DefensiveTools.checkRange(n4, "totalSize", -1);
        this.channel = n;
        this.userInfo = fullUserInfo;
        this.number = n2;
        this.reason = n3;
        this.totalSize = n4;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final FullUserInfo getUserInfo() {
        return this.userInfo;
    }

    public final int getNumberMissed() {
        return this.number;
    }

    public final int getReasonCode() {
        return this.reason;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.channel);
        this.userInfo.write(outputStream);
        BinaryTools.writeUShort(outputStream, this.number + 1);
        BinaryTools.writeUShort(outputStream, this.reason);
    }

    public String toString() {
        String string = MiscTools.findIntField(MissedMsgInfo.class, this.reason, "REASON_.*");
        if (string == null) {
            string = "0x" + Integer.toHexString(this.reason);
        }
        return "MissedMsgInfo from " + this.userInfo.getScreenname() + ": " + this.number + " missed on channel " + this.channel + ", reason=" + string;
    }
}

