/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImIcbm
extends AbstractIcbm {
    private static final ByteBlock ENCBLOCK_NULLS = ByteBlock.wrap(new byte[]{0, 0, 0, 0});
    private static final int TYPE_MESSAGE = 2;
    private static final int TYPE_ICONINFO = 8;
    private static final int TYPE_AUTORESPONSE = 4;
    private static final int TYPE_ICON_REQ = 9;
    private static final int TYPE_EXPRESSION_INFO = 13;
    private static final int TYPE_FEATURES = 1281;
    private static final int TYPE_MESSAGE_PARTS = 257;
    private static final int TYPE_ENCRYPTION_CODE = 3329;
    public static final ByteBlock FEATURES_OLD = ByteBlock.wrap(new byte[]{1, 1, 1, 2});
    public static final ByteBlock FEATURES_DEFAULT = ByteBlock.wrap(new byte[]{5, 1});
    private InstantMessage message;
    private boolean autoResponse;
    private boolean wantsIcon;
    private OldIconHashInfo iconInfo;
    private List<ExtraInfoBlock> expressionInfoBlocks;
    private ByteBlock featuresBlock;

    protected AbstractImIcbm(int n, SnacPacket snacPacket) {
        super(4, n, snacPacket);
    }

    protected final void processImTlvs(TlvChain tlvChain) {
        Writable writable;
        DefensiveTools.checkNull(tlvChain, "chain");
        Tlv tlv = tlvChain.getLastTlv(2);
        Tlv tlv2 = tlvChain.getLastTlv(8);
        Tlv tlv3 = tlvChain.getLastTlv(13);
        this.autoResponse = tlvChain.hasTlv(4);
        this.wantsIcon = tlvChain.hasTlv(9);
        if (tlv != null) {
            writable = TlvTools.readChain(tlv.getData());
            Tlv tlv4 = writable.getLastTlv(1281);
            this.featuresBlock = tlv4 != null ? tlv4.getData() : null;
            if (writable.hasTlv(3329)) {
                Tlv tlv5 = writable.getFirstTlv(257);
                ByteBlock byteBlock = tlv5.getData().subBlock(4);
                int n = writable.getUShort(3329);
                this.message = new InstantMessage(n, byteBlock);
            } else {
                String string;
                List<Tlv> list = writable.getTlvs(257);
                if (list.size() == 1) {
                    string = AbstractImIcbm.extractMsgFromPart(list.get(0).getData());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (Tlv tlv6 : list) {
                        ByteBlock byteBlock = tlv6.getData();
                        String string2 = AbstractImIcbm.extractMsgFromPart(byteBlock);
                        stringBuffer.append(string2);
                    }
                    string = stringBuffer.toString();
                }
                this.message = new InstantMessage(string);
            }
        } else {
            this.featuresBlock = null;
            this.message = null;
        }
        if (tlv2 != null) {
            writable = tlv2.getData();
            this.iconInfo = OldIconHashInfo.readIconHashFromImTlvData((ByteBlock)writable);
        } else {
            this.iconInfo = null;
        }
        if (tlv3 != null) {
            writable = tlv3.getData();
            this.expressionInfoBlocks = ExtraInfoBlock.readExtraInfoBlocks((ByteBlock)writable);
        }
    }

    private static String extractMsgFromPart(ByteBlock byteBlock) {
        int n = BinaryTools.getUShort(byteBlock, 0);
        int n2 = BinaryTools.getUShort(byteBlock, 2);
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        return ImEncodedString.readImEncodedString(new ImEncodingParams(n, n2), byteBlock2);
    }

    protected AbstractImIcbm(int n, long l, InstantMessage instantMessage, boolean bl, boolean bl2, OldIconHashInfo oldIconHashInfo, Collection<ExtraInfoBlock> collection, ByteBlock byteBlock) {
        super(4, n, l, 1);
        this.message = instantMessage;
        this.autoResponse = bl;
        this.wantsIcon = bl2;
        this.iconInfo = oldIconHashInfo;
        this.expressionInfoBlocks = DefensiveTools.getSafeListCopy(collection, "expInfoBlocks");
        this.featuresBlock = byteBlock;
    }

    public final InstantMessage getMessage() {
        return this.message;
    }

    public final boolean isAutoResponse() {
        return this.autoResponse;
    }

    public final boolean senderWantsIcon() {
        return this.wantsIcon;
    }

    public final OldIconHashInfo getIconInfo() {
        return this.iconInfo;
    }

    public final List<ExtraInfoBlock> getAimExpressionInfo() {
        return this.expressionInfoBlocks;
    }

    public final ByteBlock getFeaturesBlock() {
        return this.featuresBlock;
    }

    final void writeImTlvs(OutputStream outputStream) throws IOException {
        ByteBlock byteBlock;
        Object object;
        InstantMessage instantMessage;
        if (this.autoResponse) {
            new Tlv(4).write(outputStream);
        }
        if ((instantMessage = this.message) != null) {
            object = TlvTools.createMutableChain();
            if (instantMessage.isEncrypted()) {
                Tlv tlv = Tlv.getUShortInstance(3329, instantMessage.getEncryptionCode());
                ByteBlock byteBlock2 = ENCBLOCK_NULLS;
                ByteBlock byteBlock3 = instantMessage.getEncryptedData();
                byteBlock = ByteBlock.createByteBlock(Arrays.asList(byteBlock2, byteBlock3));
                object.addTlv(tlv);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImEncodedString imEncodedString = ImEncodedString.encodeString(instantMessage.getMessage());
                ImEncodingParams imEncodingParams = imEncodedString.getEncoding();
                BinaryTools.writeUShort(byteArrayOutputStream, imEncodingParams.getCharsetCode());
                BinaryTools.writeUShort(byteArrayOutputStream, imEncodingParams.getCharsetSubcode());
                byteArrayOutputStream.write(imEncodedString.getBytes());
                byteBlock = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
            }
            if (this.featuresBlock != null) {
                object.addTlv(new Tlv(1281, this.featuresBlock));
            }
            object.addTlv(new Tlv(257, byteBlock));
            new Tlv(2, ByteBlock.createByteBlock((LiveWritable)object)).write(outputStream);
        }
        if (this.iconInfo != null) {
            object = new ByteArrayOutputStream(20);
            this.iconInfo.writeToImTlv((OutputStream)object);
            byteBlock = ByteBlock.wrap(((ByteArrayOutputStream)object).toByteArray());
            new Tlv(8, byteBlock).write(outputStream);
        }
        if (this.wantsIcon) {
            new Tlv(9).write(outputStream);
        }
        if (this.expressionInfoBlocks != null) {
            object = ByteBlock.createByteBlock(this.expressionInfoBlocks);
            new Tlv(13, (Writable)object).write(outputStream);
        }
    }
}

