/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FamilyVersionsCmd
extends ConnCommand {
    private final List<SnacFamilyInfo> families;

    protected FamilyVersionsCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        int n2 = byteBlock.getLength() / 4;
        ArrayList<SnacFamilyInfo> arrayList = new ArrayList<SnacFamilyInfo>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = BinaryTools.getUShort(byteBlock, i * 4);
            int n4 = BinaryTools.getUShort(byteBlock, i * 4 + 2);
            arrayList.add(new SnacFamilyInfo(n3, n4));
        }
        this.families = DefensiveTools.getUnmodifiable(arrayList);
    }

    protected FamilyVersionsCmd(int n, Collection<SnacFamilyInfo> collection) {
        super(n);
        this.families = DefensiveTools.getSafeListCopy(collection, "families");
    }

    public final List<SnacFamilyInfo> getSnacFamilyInfos() {
        return this.families;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.families != null) {
            for (SnacFamilyInfo snacFamilyInfo : this.families) {
                BinaryTools.writeUShort(outputStream, snacFamilyInfo.getFamily());
                BinaryTools.writeUShort(outputStream, snacFamilyInfo.getVersion());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MiscTools.getClassName(this) + ": family versions: ");
        if (this.families != null) {
            for (SnacFamilyInfo snacFamilyInfo : this.families) {
                stringBuffer.append(Integer.toHexString(snacFamilyInfo.getFamily()));
                stringBuffer.append(" (v=");
                stringBuffer.append(Integer.toHexString(snacFamilyInfo.getVersion()));
                stringBuffer.append("), ");
            }
        }
        return stringBuffer.toString();
    }
}

