/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtraInfoData
implements Writable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_HASH_PRESENT = 1;
    public static final int FLAG_UPLOAD_ICON = 64;
    public static final int FLAG_ALREADY_HAVE_ICON = 128;
    public static final int FLAG_AVAILMSG_PRESENT = 4;
    public static final ByteBlock HASH_SPECIAL = ByteBlock.wrap(new byte[]{2, 1, -46, 4, 114});
    private final int flags;
    private final ByteBlock data;
    private final int totalSize;

    @NotNull
    public static ExtraInfoData getAvailableMessageBlock(@NotNull String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() + 10);
        try {
            byte[] byArray = string.getBytes("UTF-8");
            BinaryTools.writeUShort(byteArrayOutputStream, byArray.length);
            byteArrayOutputStream.write(byArray);
            BinaryTools.writeUShort(byteArrayOutputStream, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ExtraInfoData(4, ByteBlock.wrap(byteArrayOutputStream.toByteArray()));
    }

    @NotNull
    public static ExtraInfoData getItunesUrlBlock(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        return ExtraInfoData.getAvailableMessageBlock(ExtraInfoData.buildItunesUrl(string, string2, string3));
    }

    @NotNull
    public static String readAvailableMessage(ExtraInfoData extraInfoData) {
        ByteBlock byteBlock = extraInfoData.getData();
        int n = BinaryTools.getUShort(byteBlock, 0);
        if (n == -1) {
            return "";
        }
        byte[] byArray = byteBlock.subBlock(2, n).toByteArray();
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static String buildItunesUrl(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("itms://itunes.com/link?");
        boolean bl = ExtraInfoData.appendParamIfNotNull(stringBuilder, "n=", string3, false);
        bl = ExtraInfoData.appendParamIfNotNull(stringBuilder, "an=", string, bl);
        ExtraInfoData.appendParamIfNotNull(stringBuilder, "pn=", string2, bl);
        return stringBuilder.toString();
    }

    private static boolean appendParamIfNotNull(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (string2 != null) {
            try {
                if (bl) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string).append('=').append(URLEncoder.encode(string2, "UTF-8"));
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }
        return false;
    }

    @Nullable
    public static ExtraInfoData readExtraInfoData(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        short s2 = BinaryTools.getUByte(byteBlock, 1);
        if (byteBlock.getLength() < s2 + 2) {
            return null;
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(2, s2);
        return new ExtraInfoData(s, byteBlock2, 2 + s2);
    }

    private ExtraInfoData(int n, ByteBlock byteBlock, int n2) throws IllegalArgumentException {
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        DefensiveTools.checkRange(byteBlock.getLength(), "data length", 0, 255);
        this.flags = n;
        this.data = byteBlock;
        this.totalSize = n2;
    }

    public ExtraInfoData(int n, ByteBlock byteBlock) throws IllegalArgumentException {
        this(n, byteBlock, -1);
    }

    public final int getFlags() {
        return this.flags;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 2L + (this.data == null ? 0L : this.data.getWritableLength());
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.flags);
        if (this.data != null) {
            BinaryTools.writeUByte(outputStream, this.data.getLength());
            this.data.write(outputStream);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExtraInfoData extraInfoData = (ExtraInfoData)object;
        if (this.flags != extraInfoData.flags) {
            return false;
        }
        return !(this.data != null ? !this.data.equals(extraInfoData.data) : extraInfoData.data != null);
    }

    public int hashCode() {
        int n = this.flags;
        n = 29 * n + (this.data != null ? this.data.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ExtraInfoData: flags=0x" + Integer.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(ExtraInfoData.class, this.flags, "FLAG_.*") + ")" + ", data=" + BinaryTools.describeData(this.data);
    }
}

