/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.getfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvproto.getfile.GetFileEntry;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFileList
implements LiveWritable {
    public static final String GFLISTVERSION_DEFAULT = "Lst1";
    private final String gfListVersion;
    private final List<GetFileEntry> files;

    @Nullable
    public static GetFileList readGetFileList(ByteBlock byteBlock) {
        GetFileEntry getFileEntry;
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 4) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(0, 4));
        ByteBlock byteBlock2 = byteBlock.subBlock(4);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        List<Tlv> list = immutableTlvChain.getTlvs();
        LinkedList<GetFileEntry> linkedList = new LinkedList<GetFileEntry>();
        for (int i = 0; i < list.size() && (getFileEntry = GetFileEntry.readEntry(list, i)) != null; i += getFileEntry.getTotalTlvCount()) {
            linkedList.add(getFileEntry);
        }
        return new GetFileList(string, linkedList);
    }

    public GetFileList(Collection<GetFileEntry> collection) {
        this(GFLISTVERSION_DEFAULT, collection);
    }

    public GetFileList(String string, Collection<GetFileEntry> collection) {
        DefensiveTools.checkNull(string, "gfListVersion");
        this.files = DefensiveTools.getSafeNonnullListCopy(collection, "files");
        this.gfListVersion = string;
    }

    public final String getGfListVersion() {
        return this.gfListVersion;
    }

    public final List<GetFileEntry> getFileEntries() {
        return this.files;
    }

    @Override
    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(BinaryTools.getAsciiBytes(this.gfListVersion));
        for (GetFileEntry getFileEntry : this.files) {
            getFileEntry.write(outputStream);
        }
    }

    public String toString() {
        return "GetFileList: version=" + this.gfListVersion + ", files=" + this.files.size();
    }
}

