/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.StringBlock;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendBuddyListGroup
implements LiveWritable {
    private final String groupName;
    private final List<String> buddies;
    private final int totalSize;

    public static List<SendBuddyListGroup> readBuddyListGroups(ByteBlock byteBlock) {
        SendBuddyListGroup sendBuddyListGroup;
        DefensiveTools.checkNull(byteBlock, "block");
        ByteBlock byteBlock2 = byteBlock;
        LinkedList<SendBuddyListGroup> linkedList = new LinkedList<SendBuddyListGroup>();
        while ((sendBuddyListGroup = SendBuddyListGroup.readBuddyListGroup(byteBlock2)) != null) {
            linkedList.add(sendBuddyListGroup);
            byteBlock2 = byteBlock2.subBlock(sendBuddyListGroup.getTotalSize());
        }
        return DefensiveTools.getUnmodifiable(linkedList);
    }

    @Nullable
    public static SendBuddyListGroup readBuddyListGroup(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        StringBlock stringBlock = SendBuddyListGroup.readString(byteBlock);
        if (stringBlock == null || byteBlock.getLength() < stringBlock.getTotalSize() + 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, stringBlock.getTotalSize());
        ArrayList<String> arrayList = new ArrayList<String>(n);
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize() + 2);
        int n2 = stringBlock.getTotalSize() + 2;
        for (int i = 0; i < n; ++i) {
            StringBlock stringBlock2 = SendBuddyListGroup.readString(byteBlock2);
            if (stringBlock2 == null) {
                return null;
            }
            arrayList.add(stringBlock2.getString());
            byteBlock2 = byteBlock2.subBlock(stringBlock2.getTotalSize());
            n2 += stringBlock2.getTotalSize();
        }
        return new SendBuddyListGroup(stringBlock.getString(), arrayList, n2);
    }

    private static StringBlock readString(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        if (byteBlock.getLength() < n + 2) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(2, n));
        return new StringBlock(string, 2 + n);
    }

    private static void writeString(OutputStream outputStream, String string) throws IOException {
        DefensiveTools.checkNull(outputStream, "out");
        DefensiveTools.checkNull(string, "str");
        byte[] byArray = BinaryTools.getAsciiBytes(string);
        BinaryTools.writeUShort(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    private SendBuddyListGroup(String string, Collection<String> collection, int n) {
        DefensiveTools.checkNull(string, "groupName");
        List<String> list = DefensiveTools.getSafeNonnullListCopy(collection, "buddies");
        DefensiveTools.checkRange(n, "totalSize", -1);
        this.groupName = string;
        this.buddies = list;
        this.totalSize = n;
    }

    public SendBuddyListGroup(String string, Collection<String> collection) {
        this(string, collection, -1);
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final List<String> getBuddies() {
        return this.buddies;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SendBuddyListGroup.writeString(outputStream, this.groupName);
        BinaryTools.writeUShort(outputStream, this.buddies.size());
        for (String string : this.buddies) {
            SendBuddyListGroup.writeString(outputStream, string);
        }
    }

    public String toString() {
        return "SendBuddyListGroup for group '" + this.groupName + "': " + this.buddies;
    }
}

