/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.OutgoingSnacRequestListener;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.conn.RateChange;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import net.kano.joscar.snaccmd.conn.RateInfoCmd;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateMonitor {
    public static final ConnProcessor.ErrorType ERRTYPE_RATE_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_RATE_LISTENER");
    public static final int ERRORMARGIN_DEFAULT = 200;
    private static final Logger LOGGER = LoggingSystem.getLogger("net.kano.joscar.ratelim");
    private ClientSnacProcessor snacProcessor;
    private final CopyOnWriteArrayList<RateListener> listeners = new CopyOnWriteArrayList();
    private final Object listenerEventLock = new Object();
    private Map<Integer, RateClassMonitor> classToMonitor = new HashMap<Integer, RateClassMonitor>(10);
    private Map<CmdType, RateClassMonitor> typeToMonitor = new HashMap<CmdType, RateClassMonitor>(500);
    private RateClassMonitor defaultMonitor = null;
    private int errorMargin = 200;
    private OutgoingSnacRequestListener requestListener = new OutgoingSnacRequestListener(){

        public void handleSent(SnacRequestSentEvent snacRequestSentEvent) {
            RateMonitor.this.updateRate(snacRequestSentEvent);
        }

        public void handleTimeout(SnacRequestTimeoutEvent snacRequestTimeoutEvent) {
        }
    };
    private SnacResponseListener responseListener = new SnacResponseListener(){

        public void handleResponse(SnacResponseEvent snacResponseEvent) {
            SnacCommand snacCommand = snacResponseEvent.getSnacCommand();
            if (snacCommand instanceof RateInfoCmd) {
                RateInfoCmd rateInfoCmd = (RateInfoCmd)snacCommand;
                RateMonitor.this.setRateClasses(rateInfoCmd.getRateClassInfos());
            }
        }
    };
    private SnacPacketListener packetListener = new SnacPacketListener(){

        public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
            RateChange rateChange;
            RateClassInfo rateClassInfo;
            SnacCommand snacCommand = snacPacketEvent.getSnacCommand();
            if (snacCommand instanceof RateChange && (rateClassInfo = (rateChange = (RateChange)snacCommand).getRateInfo()) != null) {
                RateMonitor.this.updateRateClass(rateChange.getChangeCode(), rateClassInfo);
            }
        }
    };

    public RateMonitor(ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        this.snacProcessor = clientSnacProcessor;
        clientSnacProcessor.addGlobalRequestListener(this.requestListener);
        clientSnacProcessor.addPacketListener(this.packetListener);
        clientSnacProcessor.addGlobalResponseListener(this.responseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach() {
        ClientSnacProcessor clientSnacProcessor;
        Object object = this;
        synchronized (object) {
            if (this.snacProcessor == null) {
                return;
            }
            this.snacProcessor.removeGlobalRequestListener(this.requestListener);
            this.snacProcessor.removePacketListener(this.packetListener);
            this.snacProcessor.removeGlobalResponseListener(this.responseListener);
            clientSnacProcessor = this.snacProcessor;
            this.snacProcessor = null;
        }
        object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener rateListener : this.listeners) {
                rateListener.detached(this, clientSnacProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.typeToMonitor.clear();
        this.classToMonitor.clear();
        this.defaultMonitor = null;
        Object object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener rateListener : this.listeners) {
                rateListener.reset(this);
            }
        }
    }

    public final synchronized ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public final void addListener(RateListener rateListener) {
        DefensiveTools.checkNull(rateListener, "l");
        this.listeners.addIfAbsent(rateListener);
    }

    public final void removeListener(RateListener rateListener) {
        DefensiveTools.checkNull(rateListener, "l");
        this.listeners.remove(rateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRateClasses(Collection<RateClassInfo> collection) {
        List<RateClassInfo> list = DefensiveTools.getSafeNonnullListCopy(collection, "rateInfos");
        if (LOGGER.logFineEnabled()) {
            LOGGER.logFine("Got rate classes for monitor " + this);
        }
        Object object = this;
        synchronized (object) {
            this.reset();
            for (RateClassInfo object2 : list) {
                this.setRateClass(object2);
            }
        }
        object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener rateListener : this.listeners) {
                try {
                    rateListener.gotRateClasses(this);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, rateListener);
                }
            }
        }
    }

    private synchronized void setRateClass(RateClassInfo rateClassInfo) {
        DefensiveTools.checkNull(rateClassInfo, "rateInfo");
        RateClassMonitor rateClassMonitor = new RateClassMonitor(this, rateClassInfo);
        this.classToMonitor.put(rateClassInfo.getRateClass(), rateClassMonitor);
        List<CmdType> list = rateClassInfo.getCommands();
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            if (this.defaultMonitor == null) {
                this.defaultMonitor = rateClassMonitor;
            }
        } else {
            for (CmdType cmdType : list) {
                this.typeToMonitor.put(cmdType, rateClassMonitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRateClass(int n, RateClassInfo rateClassInfo) {
        DefensiveTools.checkRange(n, "changeCode", 0);
        DefensiveTools.checkNull(rateClassInfo, "rateInfo");
        int n2 = rateClassInfo.getRateClass();
        RateClassMonitor rateClassMonitor = this.getMonitor(n2);
        if (rateClassMonitor == null) {
            LOGGER.logWarning("updateRateClass called with unknown rate class " + n2 + ": changeCode=" + n + " - " + rateClassInfo);
            return;
        }
        rateClassMonitor.updateRateInfo(n, rateClassInfo);
        Object object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener rateListener : this.listeners) {
                try {
                    rateListener.rateClassUpdated(this, rateClassMonitor, rateClassInfo);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, rateListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(ConnProcessor.ErrorType errorType, Throwable throwable, RateListener rateListener) {
        ClientSnacProcessor clientSnacProcessor;
        RateMonitor rateMonitor = this;
        synchronized (rateMonitor) {
            clientSnacProcessor = this.snacProcessor;
        }
        if (clientSnacProcessor != null) {
            clientSnacProcessor.getFlapProcessor().handleException(errorType, throwable, rateListener);
        } else {
            LOGGER.logWarning("Rate monitor couldn't process error because not attached to SNAC processor: " + throwable.getMessage() + " (reason obj: " + rateListener + ")");
        }
    }

    private void updateRate(SnacRequestSentEvent snacRequestSentEvent) {
        CmdType cmdType = CmdType.ofCmd(snacRequestSentEvent.getRequest().getCommand());
        RateClassMonitor rateClassMonitor = this.getMonitor(cmdType);
        if (rateClassMonitor == null) {
            return;
        }
        rateClassMonitor.updateRate(snacRequestSentEvent.getSentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLimitedEvent(RateClassMonitor rateClassMonitor, boolean bl) {
        Object object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener rateListener : this.listeners) {
                try {
                    rateListener.rateClassLimited(this, rateClassMonitor, bl);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, rateListener);
                }
            }
        }
    }

    public final synchronized void setErrorMargin(int n) throws IllegalArgumentException {
        DefensiveTools.checkRange(n, "errorMargin", 0);
        this.errorMargin = n;
    }

    public final synchronized int getErrorMargin() {
        return this.errorMargin;
    }

    @Nullable
    private synchronized RateClassMonitor getMonitor(int n) {
        return this.classToMonitor.get(n);
    }

    public final synchronized RateClassMonitor getMonitor(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        RateClassMonitor rateClassMonitor = this.typeToMonitor.get(cmdType);
        if (rateClassMonitor == null) {
            rateClassMonitor = this.defaultMonitor;
        }
        return rateClassMonitor;
    }

    public final synchronized List<RateClassMonitor> getMonitors() {
        return DefensiveTools.getUnmodifiableCopy(this.classToMonitor.values());
    }

    public String toString() {
        return "RateMonitor: classes=" + this.classToMonitor.keySet() + ", errorMargin=" + this.errorMargin + ", snacProcessor=" + this.snacProcessor;
    }
}

