/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.kano.joscar.CopyOnWriteArraySet;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueRunner {
    public static final long TIMEOUT_DEFAULT = 300000L;
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.ratelim.QueueRunner");
    private long timeout = 300000L;
    private final Object lock = new Object();
    private boolean updated = true;
    private final Set<RateQueue> queues = new CopyOnWriteArraySet<RateQueue>();
    private boolean stop = false;
    private boolean running = false;
    private final Runnable r = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = QueueRunner.access$000(QueueRunner.this);
            synchronized (var1_1) {
                QueueRunner.access$102(QueueRunner.this, true);
                QueueRunner.access$000(QueueRunner.this).notifyAll();
            }
            minWait = 0L;
            lastActivity = -1L;
            current = System.currentTimeMillis();
            block11: while (true) {
                var7_6 = QueueRunner.access$000(QueueRunner.this);
                synchronized (var7_6) {
                    if (!QueueRunner.access$200(QueueRunner.this)) {
                        try {
                            if (minWait == 0L) {
                                sincelast = lastActivity == -1L ? 0L : current - lastActivity;
                                QueueRunner.access$000(QueueRunner.this).wait(Math.max(1L, QueueRunner.access$300(QueueRunner.this) - sincelast));
                            } else {
                                QueueRunner.access$000(QueueRunner.this).wait(minWait);
                            }
                        }
                        catch (InterruptedException nobigdeal) {
                            // empty catch block
                        }
                    }
                    QueueRunner.access$202(QueueRunner.this, false);
                    if (QueueRunner.access$400(QueueRunner.this)) {
                        if (QueueRunner.access$500().logFineEnabled()) {
                            QueueRunner.access$500().logFine("Stopping queue runner cycle due to stopCurrentRun() call");
                        }
                        QueueRunner.access$402(QueueRunner.this, false);
                        QueueRunner.access$102(QueueRunner.this, false);
                        break;
                    }
                    current = System.currentTimeMillis();
                    if (lastActivity != -1L && minWait == 0L && (since = current - lastActivity) > QueueRunner.access$300(QueueRunner.this)) {
                        if (QueueRunner.access$500().logFineEnabled()) {
                            QueueRunner.access$500().logFine("Stopping queue runner cycle due to inactivity: " + since + "ms");
                        }
                        QueueRunner.access$102(QueueRunner.this, false);
                        break;
                    }
                    lastActivity = current;
                }
                minWait = 0L;
                if (QueueRunner.access$600(QueueRunner.this).isEmpty()) continue;
                i$ = QueueRunner.access$600(QueueRunner.this).iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block11;
                    queue = (RateQueue)i$.next();
                    wait = 0L;
                    var12_14 = queue;
                    synchronized (var12_14) {
                        if (queue.getParentMgr().isPaused() || !queue.hasRequests()) {
                            continue;
                        }
                        if (QueueRunner.access$700(QueueRunner.this, queue)) {
                            QueueRunner.access$800(QueueRunner.this, queue);
                        }
                        v0 = finished = queue.hasRequests() == false;
                        if (!finished) {
                            wait = QueueRunner.access$900(QueueRunner.this, queue);
                        }
                    }
                    if (finished) continue;
                    if (wait < 1L) {
                        wait = 1L;
                    }
                    if (minWait != 0L && minWait <= wait) continue;
                    minWait = wait;
                }
                break;
            }
        }
    };

    QueueRunner() {
    }

    private long getWaitTime(RateQueue queue) {
        return queue.getRateClassMonitor().getOptimalWaitTime();
    }

    private boolean isReady(RateQueue queue) {
        return this.getWaitTime(queue) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueReady(RateQueue queue) {
        ConnectionQueueMgr connMgr = queue.getParentMgr();
        RateLimitingQueueMgr rateMgr = connMgr.getParentQueueMgr();
        ArrayList<SnacRequest> requests = new ArrayList<SnacRequest>();
        RateQueue rateQueue = queue;
        synchronized (rateQueue) {
            while (queue.hasRequests() && this.isReady(queue)) {
                requests.add(queue.dequeue());
            }
        }
        ClientSnacProcessor processor = connMgr.getSnacProcessor();
        for (SnacRequest request : requests) {
            rateMgr.sendSnac(processor, request);
        }
    }

    void update(ConnectionQueueMgr updated) {
        this.forceUpdate();
    }

    void update(RateQueue updated) {
        this.forceUpdate();
    }

    void update() {
        this.forceUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceUpdate() {
        Object object = this.lock;
        synchronized (object) {
            this.updated = true;
            this.updateLock();
        }
    }

    private void updateLock() {
        assert (Thread.holdsLock(this.lock));
        this.checkThread();
        this.lock.notifyAll();
    }

    private void checkThread() {
        assert (Thread.holdsLock(this.lock));
        if (this.running) {
            return;
        }
        if (this.queues.isEmpty()) {
            return;
        }
        if (logger.logFineEnabled()) {
            logger.logFine("Starting queue runner due to activity");
        }
        Thread thread = new Thread(this.r, "Queue Runner");
        thread.setDaemon(true);
        thread.start();
        while (!this.running) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopCurrentRun() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return false;
            }
            this.stop = true;
            this.lock.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            this.timeout = timeout;
            this.lock.notifyAll();
        }
    }

    void addQueue(RateQueue queue) {
        DefensiveTools.checkNull(queue, "queue");
        this.queues.add(queue);
        this.update(queue);
    }

    void addQueues(Collection<RateQueue> rateQueues) {
        List<RateQueue> safeRateQueues = DefensiveTools.getSafeNonnullListCopy(rateQueues, "rateQueues");
        this.queues.addAll(safeRateQueues);
        this.update();
    }

    void removeQueue(RateQueue queue) {
        DefensiveTools.checkNull(queue, "queue");
        this.queues.remove(queue);
    }

    void removeQueues(Collection<RateQueue> rateQueues) {
        DefensiveTools.checkNull(rateQueues, "rateQueues");
        this.queues.removeAll(rateQueues);
    }

    public String toString() {
        return "QueueRunner: queues=" + this.queues;
    }

    static /* synthetic */ Object access$000(QueueRunner x0) {
        return x0.lock;
    }

    static /* synthetic */ boolean access$102(QueueRunner x0, boolean x1) {
        x0.running = x1;
        return x0.running;
    }

    static /* synthetic */ boolean access$200(QueueRunner x0) {
        return x0.updated;
    }

    static /* synthetic */ long access$300(QueueRunner x0) {
        return x0.timeout;
    }

    static /* synthetic */ boolean access$202(QueueRunner x0, boolean x1) {
        x0.updated = x1;
        return x0.updated;
    }

    static /* synthetic */ boolean access$400(QueueRunner x0) {
        return x0.stop;
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }

    static /* synthetic */ boolean access$402(QueueRunner x0, boolean x1) {
        x0.stop = x1;
        return x0.stop;
    }

    static /* synthetic */ Set access$600(QueueRunner x0) {
        return x0.queues;
    }

    static /* synthetic */ boolean access$700(QueueRunner x0, RateQueue x1) {
        return x0.isReady(x1);
    }

    static /* synthetic */ void access$800(QueueRunner x0, RateQueue x1) {
        x0.dequeueReady(x1);
    }

    static /* synthetic */ long access$900(QueueRunner x0, RateQueue x1) {
        return x0.getWaitTime(x1);
    }
}

